package cn.yunrui.mqttclient.ebikesrv.mqttclient.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;

/**
 * 充电设备工况
 */
public class ChargeDeviceOps implements Serializable {

    private String orgNo;                                   // 单位编号
    private String chargedeviceNo;                          // 充电设备编号（二维码编号）
    private String deviceId;                                // 设备通讯标识（MQTT规约中定义的deviceId）
    private Integer plugCount;                              // 插座个数
    private Long chargedeviceId;
    private String opStatus;
    private Date firstCommTime;
    private Date latestCommTime;
    private Date firstChargeFinishTime;
    private Integer firstChargePlugSn;
    private BigDecimal firstChargeTtlDur;
    private Date latestChargeFinishTime;
    private Integer latestChargePlugSn;
    private BigDecimal latestChargeTtlDur;
    private Date currentDate;
    private Integer currDayCumCrgCnt;
    private Integer currMonthCumCrgCnt;
    private Integer currYearCumCrgCnt;
    private Integer cumCrgCnt;
    private BigDecimal curPower;
    private Date curPowerTime;

    public String getOrgNo() {
        return orgNo;
    }

    public void setOrgNo(String orgNo) {
        this.orgNo = orgNo;
    }

    public String getChargedeviceNo() {
        return chargedeviceNo;
    }

    public void setChargedeviceNo(String chargedeviceNo) {
        this.chargedeviceNo = chargedeviceNo;
    }

    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public Integer getPlugCount() {
        return plugCount;
    }

    public void setPlugCount(Integer plugCount) {
        this.plugCount = plugCount;
    }

    public Long getChargedeviceId() {
        return chargedeviceId;
    }

    public void setChargedeviceId(Long chargedeviceId) {
        this.chargedeviceId = chargedeviceId;
    }

    public String getOpStatus() {
        return opStatus;
    }

    public void setOpStatus(String opStatus) {
        this.opStatus = opStatus;
    }

    public Date getFirstCommTime() {
        return firstCommTime;
    }

    public void setFirstCommTime(Date firstCommTime) {
        this.firstCommTime = firstCommTime;
    }

    public Date getLatestCommTime() {
        return latestCommTime;
    }

    public void setLatestCommTime(Date latestCommTime) {
        this.latestCommTime = latestCommTime;
    }

    public Date getFirstChargeFinishTime() {
        return firstChargeFinishTime;
    }

    public void setFirstChargeFinishTime(Date firstChargeFinishTime) {
        this.firstChargeFinishTime = firstChargeFinishTime;
    }

    public Integer getFirstChargePlugSn() {
        return firstChargePlugSn;
    }

    public void setFirstChargePlugSn(Integer firstChargePlugSn) {
        this.firstChargePlugSn = firstChargePlugSn;
    }

    public BigDecimal getFirstChargeTtlDur() {
        return firstChargeTtlDur;
    }

    public void setFirstChargeTtlDur(BigDecimal firstChargeTtlDur) {
        this.firstChargeTtlDur = firstChargeTtlDur;
    }

    public Date getLatestChargeFinishTime() {
        return latestChargeFinishTime;
    }

    public void setLatestChargeFinishTime(Date latestChargeFinishTime) {
        this.latestChargeFinishTime = latestChargeFinishTime;
    }

    public Integer getLatestChargePlugSn() {
        return latestChargePlugSn;
    }

    public void setLatestChargePlugSn(Integer latestChargePlugSn) {
        this.latestChargePlugSn = latestChargePlugSn;
    }

    public BigDecimal getLatestChargeTtlDur() {
        return latestChargeTtlDur;
    }

    public void setLatestChargeTtlDur(BigDecimal latestChargeTtlDur) {
        this.latestChargeTtlDur = latestChargeTtlDur;
    }

    public Date getCurrentDate() {
        return currentDate;
    }

    public void setCurrentDate(Date currentDate) {
        this.currentDate = currentDate;
    }

    public Integer getCurrDayCumCrgCnt() {
        return currDayCumCrgCnt;
    }

    public void setCurrDayCumCrgCnt(Integer currDayCumCrgCnt) {
        this.currDayCumCrgCnt = currDayCumCrgCnt;
    }

    public Integer getCurrMonthCumCrgCnt() {
        return currMonthCumCrgCnt;
    }

    public void setCurrMonthCumCrgCnt(Integer currMonthCumCrgCnt) {
        this.currMonthCumCrgCnt = currMonthCumCrgCnt;
    }

    public Integer getCurrYearCumCrgCnt() {
        return currYearCumCrgCnt;
    }

    public void setCurrYearCumCrgCnt(Integer currYearCumCrgCnt) {
        this.currYearCumCrgCnt = currYearCumCrgCnt;
    }

    public Integer getCumCrgCnt() {
        return cumCrgCnt;
    }

    public void setCumCrgCnt(Integer cumCrgCnt) {
        this.cumCrgCnt = cumCrgCnt;
    }

    public BigDecimal getCurPower() {
        return curPower;
    }

    public void setCurPower(BigDecimal curPower) {
        this.curPower = curPower;
    }

    public Date getCurPowerTime() {
        return curPowerTime;
    }

    public void setCurPowerTime(Date curPowerTime) {
        this.curPowerTime = curPowerTime;
    }

    @Override
    public boolean equals(Object o) {
        if(this == o) return true;
        if(o == null || getClass() != o.getClass()) return false;
        ChargeDeviceOps that = (ChargeDeviceOps) o;
        return Objects.equals(orgNo, that.orgNo) &&
                Objects.equals(chargedeviceNo, that.chargedeviceNo) &&
                Objects.equals(deviceId, that.deviceId) &&
                Objects.equals(plugCount, that.plugCount) &&
                Objects.equals(chargedeviceId, that.chargedeviceId) &&
                Objects.equals(opStatus, that.opStatus) &&
                Objects.equals(firstCommTime, that.firstCommTime) &&
                Objects.equals(latestCommTime, that.latestCommTime) &&
                Objects.equals(firstChargeFinishTime, that.firstChargeFinishTime) &&
                Objects.equals(firstChargePlugSn, that.firstChargePlugSn) &&
                Objects.equals(firstChargeTtlDur, that.firstChargeTtlDur) &&
                Objects.equals(latestChargeFinishTime, that.latestChargeFinishTime) &&
                Objects.equals(latestChargePlugSn, that.latestChargePlugSn) &&
                Objects.equals(latestChargeTtlDur, that.latestChargeTtlDur) &&
                Objects.equals(currentDate, that.currentDate) &&
                Objects.equals(currDayCumCrgCnt, that.currDayCumCrgCnt) &&
                Objects.equals(currMonthCumCrgCnt, that.currMonthCumCrgCnt) &&
                Objects.equals(currYearCumCrgCnt, that.currYearCumCrgCnt) &&
                Objects.equals(cumCrgCnt, that.cumCrgCnt) &&
                Objects.equals(curPower, that.curPower) &&
                Objects.equals(curPowerTime, that.curPowerTime);
    }

    @Override
    public int hashCode() {
        return Objects.hash(orgNo, chargedeviceNo, deviceId, plugCount, chargedeviceId, opStatus, firstCommTime, latestCommTime, firstChargeFinishTime, firstChargePlugSn, firstChargeTtlDur, latestChargeFinishTime, latestChargePlugSn, latestChargeTtlDur, currentDate, currDayCumCrgCnt, currMonthCumCrgCnt, currYearCumCrgCnt, cumCrgCnt, curPower, curPowerTime);
    }

    @Override
    public String toString() {
        return "ChargeDeviceOps{" +
                "orgNo='" + orgNo + '\'' +
                ", chargedeviceNo='" + chargedeviceNo + '\'' +
                ", deviceId='" + deviceId + '\'' +
                ", plugCount=" + plugCount +
                ", chargedeviceId=" + chargedeviceId +
                ", opStatus='" + opStatus + '\'' +
                ", firstCommTime=" + firstCommTime +
                ", latestCommTime=" + latestCommTime +
                ", firstChargeFinishTime=" + firstChargeFinishTime +
                ", firstChargePlugSn=" + firstChargePlugSn +
                ", firstChargeTtlDur=" + firstChargeTtlDur +
                ", latestChargeFinishTime=" + latestChargeFinishTime +
                ", latestChargePlugSn=" + latestChargePlugSn +
                ", latestChargeTtlDur=" + latestChargeTtlDur +
                ", currentDate=" + currentDate +
                ", currDayCumCrgCnt=" + currDayCumCrgCnt +
                ", currMonthCumCrgCnt=" + currMonthCumCrgCnt +
                ", currYearCumCrgCnt=" + currYearCumCrgCnt +
                ", cumCrgCnt=" + cumCrgCnt +
                ", curPower=" + curPower +
                ", curPowerTime=" + curPowerTime +
                '}';
    }

}
