package cn.yunrui.mqttclient.ebikesrv.mqttclient.entity;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.Objects;

/**
 * 充电设备属性
 *
 * @author Nick Zhang
 * @date 2019-03-26
 *
 */
public class ChargeDeviceProps implements Serializable {

    private String deviceId;                                // 设备通讯标识（MQTT规约中定义的deviceId）
    private String orgNo;                                   // 单位编号
    private String chargedeviceNo;                          // 充电设备编号（二维码编号）
    private ChargeDeviceProtocolEnum chargeDeviceProtocol;  // 设备通讯规约（包括设备通讯规约类型及设备通讯规约版本）
    private String factory;                                 // 生产厂家
    private String modelNo;                                 // 设备型号
    private Integer plugCount;                              // 插座个数
    private String opStatus;                                // 运行状态：1 - 在线；0 - 离线；
    private Date latestCommTime;                            // 最近通讯时间
    private String status;                                  // 设备状态：00 - 库存；02 - 已装（待运行）；03 - 运行；07 - 拆除；
    private Long chargedeviceId;                            // 充电设备标识
    private Date importTime;                                // 导入时间，状态为库存
    private Date installTime;                               // 装接时间，状态为已装
    private Date runTime;                                   // 运行时间，状态为运行
    private Date dismantleTime;                             // 拆除时间，状态为拆除
    private String mqttBrokerHostIp;                        // MQTT Broker主机IP地址
    private String mqttBrokerHostPort;                      // MQTT Broker主机端口
    private String serverSubTopic;                          // 服务订阅主题
    private Map<String, String> paramsMap;                  // 设备参数集合：<maxPlugPower> <maxDevicePower> <cardPassword> <factor>
    private Map<String, String> attachParamsMap;            // 设备附加参数集合：<floatChargeTime>
    private Long chargestationId;                           // 充电站标识
    private String billingSchemeId;                         // 计费方案标识
    private String billingSchemeType;                       // 计费方案类型：01 - 计时间；02 - 计电量；
    private Double billingUnitPrice1;                       // 计费单价1
    private Double billingUnitPrice2;                       // 计费单价2
    private Double billingUnitPrice3;                       // 计费单价3
    private Double minChargeMoney;                          // 最低消费金额，单位为元
    private String isReturn;                                // 是否退费：Y是 N否
    private Map<Integer, ChargePlugProps> plugPropsMap;     // 插座属性集合<plugSn[插座序号], plugProps[ChargePlugProps充电插座属性]>

    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getOrgNo() {
        return orgNo;
    }

    public void setOrgNo(String orgNo) {
        this.orgNo = orgNo;
    }

    public String getChargedeviceNo() {
        return chargedeviceNo;
    }

    public void setChargedeviceNo(String chargedeviceNo) {
        this.chargedeviceNo = chargedeviceNo;
    }

    public ChargeDeviceProtocolEnum getChargeDeviceProtocol() {
        return chargeDeviceProtocol;
    }

    public void setChargeDeviceProtocol(ChargeDeviceProtocolEnum chargeDeviceProtocol) {
        this.chargeDeviceProtocol = chargeDeviceProtocol;
    }

    public String getFactory() {
        return factory;
    }

    public void setFactory(String factory) {
        this.factory = factory;
    }

    public String getModelNo() {
        return modelNo;
    }

    public void setModelNo(String modelNo) {
        this.modelNo = modelNo;
    }

    public Integer getPlugCount() {
        return plugCount;
    }

    public void setPlugCount(Integer plugCount) {
        this.plugCount = plugCount;
    }

    public String getOpStatus() {
        return opStatus;
    }

    public void setOpStatus(String opStatus) {
        this.opStatus = opStatus;
    }

    public Date getLatestCommTime() {
        return latestCommTime;
    }

    public void setLatestCommTime(Date latestCommTime) {
        this.latestCommTime = latestCommTime;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Long getChargedeviceId() {
        return chargedeviceId;
    }

    public void setChargedeviceId(Long chargedeviceId) {
        this.chargedeviceId = chargedeviceId;
    }

    public Date getImportTime() {
        return importTime;
    }

    public void setImportTime(Date importTime) {
        this.importTime = importTime;
    }

    public Date getInstallTime() {
        return installTime;
    }

    public void setInstallTime(Date installTime) {
        this.installTime = installTime;
    }

    public Date getRunTime() {
        return runTime;
    }

    public void setRunTime(Date runTime) {
        this.runTime = runTime;
    }

    public Date getDismantleTime() {
        return dismantleTime;
    }

    public void setDismantleTime(Date dismantleTime) {
        this.dismantleTime = dismantleTime;
    }

    public String getMqttBrokerHostIp() {
        return mqttBrokerHostIp;
    }

    public void setMqttBrokerHostIp(String mqttBrokerHostIp) {
        this.mqttBrokerHostIp = mqttBrokerHostIp;
    }

    public String getMqttBrokerHostPort() {
        return mqttBrokerHostPort;
    }

    public void setMqttBrokerHostPort(String mqttBrokerHostPort) {
        this.mqttBrokerHostPort = mqttBrokerHostPort;
    }

    public String getServerSubTopic() {
        return serverSubTopic;
    }

    public void setServerSubTopic(String serverSubTopic) {
        this.serverSubTopic = serverSubTopic;
    }

    public Map<String, String> getParamsMap() {
        return paramsMap;
    }

    public void setParamsMap(Map<String, String> paramsMap) {
        this.paramsMap = paramsMap;
    }

    public Map<String, String> getAttachParamsMap() {
        return attachParamsMap;
    }

    public void setAttachParamsMap(Map<String, String> attachParamsMap) {
        this.attachParamsMap = attachParamsMap;
    }

    public Long getChargestationId() {
        return chargestationId;
    }

    public void setChargestationId(Long chargestationId) {
        this.chargestationId = chargestationId;
    }

    public String getBillingSchemeId() {
        return billingSchemeId;
    }

    public void setBillingSchemeId(String billingSchemeId) {
        this.billingSchemeId = billingSchemeId;
    }

    public String getBillingSchemeType() {
        return billingSchemeType;
    }

    public void setBillingSchemeType(String billingSchemeType) {
        this.billingSchemeType = billingSchemeType;
    }

    public Double getBillingUnitPrice1() {
        return billingUnitPrice1;
    }

    public void setBillingUnitPrice1(Double billingUnitPrice1) {
        this.billingUnitPrice1 = billingUnitPrice1;
    }

    public Double getBillingUnitPrice2() {
        return billingUnitPrice2;
    }

    public void setBillingUnitPrice2(Double billingUnitPrice2) {
        this.billingUnitPrice2 = billingUnitPrice2;
    }

    public Double getBillingUnitPrice3() {
        return billingUnitPrice3;
    }

    public void setBillingUnitPrice3(Double billingUnitPrice3) {
        this.billingUnitPrice3 = billingUnitPrice3;
    }

    public Double getMinChargeMoney() {
        return minChargeMoney;
    }

    public void setMinChargeMoney(Double minChargeMoney) {
        this.minChargeMoney = minChargeMoney;
    }

    public String getIsReturn() {
        return isReturn;
    }

    public void setIsReturn(String isReturn) {
        this.isReturn = isReturn;
    }

    public Map<Integer, ChargePlugProps> getPlugPropsMap() {
        return plugPropsMap;
    }

    public void setPlugPropsMap(Map<Integer, ChargePlugProps> plugPropsMap) {
        this.plugPropsMap = plugPropsMap;
    }

    @Override
    public boolean equals(Object o) {
        if(this == o) return true;
        if(o == null || getClass() != o.getClass()) return false;
        ChargeDeviceProps that = (ChargeDeviceProps) o;
        return Objects.equals(deviceId, that.deviceId) &&
                Objects.equals(orgNo, that.orgNo) &&
                Objects.equals(chargedeviceNo, that.chargedeviceNo) &&
                chargeDeviceProtocol == that.chargeDeviceProtocol &&
                Objects.equals(factory, that.factory) &&
                Objects.equals(modelNo, that.modelNo) &&
                Objects.equals(plugCount, that.plugCount) &&
                Objects.equals(opStatus, that.opStatus) &&
                Objects.equals(latestCommTime, that.latestCommTime) &&
                Objects.equals(status, that.status) &&
                Objects.equals(chargedeviceId, that.chargedeviceId) &&
                Objects.equals(importTime, that.importTime) &&
                Objects.equals(installTime, that.installTime) &&
                Objects.equals(runTime, that.runTime) &&
                Objects.equals(dismantleTime, that.dismantleTime) &&
                Objects.equals(mqttBrokerHostIp, that.mqttBrokerHostIp) &&
                Objects.equals(mqttBrokerHostPort, that.mqttBrokerHostPort) &&
                Objects.equals(serverSubTopic, that.serverSubTopic) &&
                Objects.equals(paramsMap, that.paramsMap) &&
                Objects.equals(attachParamsMap, that.attachParamsMap) &&
                Objects.equals(chargestationId, that.chargestationId) &&
                Objects.equals(billingSchemeId, that.billingSchemeId) &&
                Objects.equals(billingSchemeType, that.billingSchemeType) &&
                Objects.equals(billingUnitPrice1, that.billingUnitPrice1) &&
                Objects.equals(billingUnitPrice2, that.billingUnitPrice2) &&
                Objects.equals(billingUnitPrice3, that.billingUnitPrice3) &&
                Objects.equals(minChargeMoney, that.minChargeMoney) &&
                Objects.equals(isReturn, that.isReturn) &&
                Objects.equals(plugPropsMap, that.plugPropsMap);
    }

    @Override
    public int hashCode() {
        return Objects.hash(deviceId, orgNo, chargedeviceNo, chargeDeviceProtocol, factory, modelNo, plugCount, opStatus, latestCommTime, status, chargedeviceId, importTime, installTime, runTime, dismantleTime, mqttBrokerHostIp, mqttBrokerHostPort, serverSubTopic, paramsMap, attachParamsMap, chargestationId, billingSchemeId, billingSchemeType, billingUnitPrice1, billingUnitPrice2, billingUnitPrice3, minChargeMoney, isReturn, plugPropsMap);
    }

    @Override
    public String toString() {
        return "ChargeDeviceProps{" +
                "deviceId='" + deviceId + '\'' +
                ", orgNo='" + orgNo + '\'' +
                ", chargedeviceNo='" + chargedeviceNo + '\'' +
                ", chargeDeviceProtocol=" + chargeDeviceProtocol +
                ", factory='" + factory + '\'' +
                ", modelNo='" + modelNo + '\'' +
                ", plugCount=" + plugCount +
                ", opStatus='" + opStatus + '\'' +
                ", latestCommTime=" + latestCommTime +
                ", status='" + status + '\'' +
                ", chargedeviceId=" + chargedeviceId +
                ", importTime=" + importTime +
                ", installTime=" + installTime +
                ", runTime=" + runTime +
                ", dismantleTime=" + dismantleTime +
                ", mqttBrokerHostIp='" + mqttBrokerHostIp + '\'' +
                ", mqttBrokerHostPort='" + mqttBrokerHostPort + '\'' +
                ", serverSubTopic='" + serverSubTopic + '\'' +
                ", paramsMap=" + paramsMap +
                ", attachParamsMap=" + attachParamsMap +
                ", chargestationId=" + chargestationId +
                ", billingSchemeId='" + billingSchemeId + '\'' +
                ", billingSchemeType='" + billingSchemeType + '\'' +
                ", billingUnitPrice1=" + billingUnitPrice1 +
                ", billingUnitPrice2=" + billingUnitPrice2 +
                ", billingUnitPrice3=" + billingUnitPrice3 +
                ", minChargeMoney=" + minChargeMoney +
                ", isReturn='" + isReturn + '\'' +
                ", plugPropsMap=" + plugPropsMap +
                '}';
    }
}
