package cn.yunrui.mqttclient.ebikesrv.mqttclient.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;

/**
 * 充电插座属性
 */
public class ChargePlugProps implements Serializable {

    private String deviceId;                            // 设备通讯标识（MQTT规约中定义的deviceId）
    private String plugId;                              // 插座通讯标识（MQTT规约中定义的plugId）
    private Long chargeplugId;                          // 充电插座标识
    private Integer plugSn;                             // 插座序号
    private String opStatus;                            // 运行状态：0 - 空闲；1 - 正在使用；2 - 已被预订；8 – 正在检修；9 – 不可用（设备离线）；
    private Date opStatusTime;                          // 运行状态更新时间
    private Date firstChargeFinishTime;
    private BigDecimal firstChargeTtlDur;
    private Date latestChargeFinishTime;
    private BigDecimal latestChargeTtlDur;
    private Date currentDate;
    private Integer currDayCumCrgCnt;
    private Integer currMonthCumCrgCnt;
    private Integer currYearCumCrgCnt;
    private Integer cumCrgCnt;
    private BigDecimal curPower;
    private Date curPowerTime;
    private String status;                              // 插座状态：F - 空闲；U - 正在使用；R - 已被预订；

    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getPlugId() {
        return plugId;
    }

    public void setPlugId(String plugId) {
        this.plugId = plugId;
    }

    public Long getChargeplugId() {
        return chargeplugId;
    }

    public void setChargeplugId(Long chargeplugId) {
        this.chargeplugId = chargeplugId;
    }

    public Integer getPlugSn() {
        return plugSn;
    }

    public void setPlugSn(Integer plugSn) {
        this.plugSn = plugSn;
    }

    public String getOpStatus() {
        return opStatus;
    }

    public void setOpStatus(String opStatus) {
        this.opStatus = opStatus;
    }

    public Date getOpStatusTime() {
        return opStatusTime;
    }

    public void setOpStatusTime(Date opStatusTime) {
        this.opStatusTime = opStatusTime;
    }

    public Date getFirstChargeFinishTime() {
        return firstChargeFinishTime;
    }

    public void setFirstChargeFinishTime(Date firstChargeFinishTime) {
        this.firstChargeFinishTime = firstChargeFinishTime;
    }

    public BigDecimal getFirstChargeTtlDur() {
        return firstChargeTtlDur;
    }

    public void setFirstChargeTtlDur(BigDecimal firstChargeTtlDur) {
        this.firstChargeTtlDur = firstChargeTtlDur;
    }

    public Date getLatestChargeFinishTime() {
        return latestChargeFinishTime;
    }

    public void setLatestChargeFinishTime(Date latestChargeFinishTime) {
        this.latestChargeFinishTime = latestChargeFinishTime;
    }

    public BigDecimal getLatestChargeTtlDur() {
        return latestChargeTtlDur;
    }

    public void setLatestChargeTtlDur(BigDecimal latestChargeTtlDur) {
        this.latestChargeTtlDur = latestChargeTtlDur;
    }

    public Date getCurrentDate() {
        return currentDate;
    }

    public void setCurrentDate(Date currentDate) {
        this.currentDate = currentDate;
    }

    public Integer getCurrDayCumCrgCnt() {
        return currDayCumCrgCnt;
    }

    public void setCurrDayCumCrgCnt(Integer currDayCumCrgCnt) {
        this.currDayCumCrgCnt = currDayCumCrgCnt;
    }

    public Integer getCurrMonthCumCrgCnt() {
        return currMonthCumCrgCnt;
    }

    public void setCurrMonthCumCrgCnt(Integer currMonthCumCrgCnt) {
        this.currMonthCumCrgCnt = currMonthCumCrgCnt;
    }

    public Integer getCurrYearCumCrgCnt() {
        return currYearCumCrgCnt;
    }

    public void setCurrYearCumCrgCnt(Integer currYearCumCrgCnt) {
        this.currYearCumCrgCnt = currYearCumCrgCnt;
    }

    public Integer getCumCrgCnt() {
        return cumCrgCnt;
    }

    public void setCumCrgCnt(Integer cumCrgCnt) {
        this.cumCrgCnt = cumCrgCnt;
    }

    public BigDecimal getCurPower() {
        return curPower;
    }

    public void setCurPower(BigDecimal curPower) {
        this.curPower = curPower;
    }

    public Date getCurPowerTime() {
        return curPowerTime;
    }

    public void setCurPowerTime(Date curPowerTime) {
        this.curPowerTime = curPowerTime;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public boolean equals(Object o) {
        if(this == o) return true;
        if(o == null || getClass() != o.getClass()) return false;
        ChargePlugProps that = (ChargePlugProps) o;
        return Objects.equals(deviceId, that.deviceId) &&
                Objects.equals(plugId, that.plugId) &&
                Objects.equals(chargeplugId, that.chargeplugId) &&
                Objects.equals(plugSn, that.plugSn) &&
                Objects.equals(opStatus, that.opStatus) &&
                Objects.equals(opStatusTime, that.opStatusTime) &&
                Objects.equals(firstChargeFinishTime, that.firstChargeFinishTime) &&
                Objects.equals(firstChargeTtlDur, that.firstChargeTtlDur) &&
                Objects.equals(latestChargeFinishTime, that.latestChargeFinishTime) &&
                Objects.equals(latestChargeTtlDur, that.latestChargeTtlDur) &&
                Objects.equals(currentDate, that.currentDate) &&
                Objects.equals(currDayCumCrgCnt, that.currDayCumCrgCnt) &&
                Objects.equals(currMonthCumCrgCnt, that.currMonthCumCrgCnt) &&
                Objects.equals(currYearCumCrgCnt, that.currYearCumCrgCnt) &&
                Objects.equals(cumCrgCnt, that.cumCrgCnt) &&
                Objects.equals(curPower, that.curPower) &&
                Objects.equals(curPowerTime, that.curPowerTime) &&
                Objects.equals(status, that.status);
    }

    @Override
    public int hashCode() {
        return Objects.hash(deviceId, plugId, chargeplugId, plugSn, opStatus, opStatusTime, firstChargeFinishTime, firstChargeTtlDur, latestChargeFinishTime, latestChargeTtlDur, currentDate, currDayCumCrgCnt, currMonthCumCrgCnt, currYearCumCrgCnt, cumCrgCnt, curPower, curPowerTime, status);
    }

    @Override
    public String toString() {
        return "ChargePlugProps{" +
                "deviceId='" + deviceId + '\'' +
                ", plugId='" + plugId + '\'' +
                ", chargeplugId=" + chargeplugId +
                ", plugSn=" + plugSn +
                ", opStatus='" + opStatus + '\'' +
                ", opStatusTime=" + opStatusTime +
                ", firstChargeFinishTime=" + firstChargeFinishTime +
                ", firstChargeTtlDur=" + firstChargeTtlDur +
                ", latestChargeFinishTime=" + latestChargeFinishTime +
                ", latestChargeTtlDur=" + latestChargeTtlDur +
                ", currentDate=" + currentDate +
                ", currDayCumCrgCnt=" + currDayCumCrgCnt +
                ", currMonthCumCrgCnt=" + currMonthCumCrgCnt +
                ", currYearCumCrgCnt=" + currYearCumCrgCnt +
                ", cumCrgCnt=" + cumCrgCnt +
                ", curPower=" + curPower +
                ", curPowerTime=" + curPowerTime +
                ", status='" + status + '\'' +
                '}';
    }

}
