package cn.yunrui.mqttclient.ebikesrv.mqttclient.entity;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@Data
public class ChargeRecord implements Serializable {

    private String chargeRecordId;                      // 充电记录标识
    private String chargeUserId;                        // 充电用户标识
    private String chargeUserNo;                        // 充电用户编号
    private String chargeUserType;                      // 充电用户类型，10 - 微信用户；20 - 支付宝用户；90 - 投币用户；
    private String merchantNo;                          // 充电用户所属公众号，sy - 数元；yz - 原智；
    private String deviceId;                            // 设备通讯标识（MQTT规约中定义的deviceId）
    private String plugId;                              // 插座通讯标识（MQTT规约中定义的plugId）
    private String orgNo;                               // 单位编号
    private Long chargestationId;                       // 充电站标识
    private String chargestationName;                   // 充电站名称
    private String chargestationAddr;                   // 充电站地址
    private String chargedeviceNo;                      // 充电设备编号（二维码编号）
    private Integer plugSn;                             // 插座序号
    private Date chargeTime;                            // 充电时间
    private Double chargeMoney;                         // 充电金额
    private Double coinMoney;                           // 投币金额
    private String chargeTradeOrderId;                  // 充电交易订单ID
    private String enterUserType;                       // 入账账户类型
    private String enterUserId;                         // 入账账户标识
    private Double serviceRate;                         // 服务费率，单位：%
    private String schemeId;                            // 计费方案标识
    private String schemeType;                          // 计费方案类型
    private Double unitPrice1;                          // 计费单价1
    private Double unitPrice2;                          // 计费单价2
    private Double unitPrice3;                          // 计费单价3
    private Double unitPrice4;                          // 计费单价4
    private Double unitPrice5;                          // 计费单价5
    private Integer stepCount;                          // 功率阶梯数
    private Integer stepPower1;                         // 阶梯功率1，单位为W
    private Integer stepPower2;                         // 阶梯功率2，单位为W
    private Integer stepPower3;                         // 阶梯功率3，单位为W
    private Integer stepPower4;                         // 阶梯功率4，单位为W
    private Double minCharge;                           // 最低消费金额：单位为元
    private String isReturn;                            // 是否退费
    private Integer closingPeriod;                      // 计费结算周期，单位为分钟
    private String costSchemeId;                        // 电费成本方案标识
    private Double costUnitPrice;                       // 电费成本单价：单位为元/kWh
    private Integer chargeOpenFlag;                     // 充电开启标志
    private Date chargeOpenTime;                        // 充电开启时间
    private Integer firstUnitPriceFlag;                 // 初始计费单价标记
    private Double firstChargeAmount;                   // 初始充电量
    private Integer currUnitPriceFlag;                  // 当前计费单价标记
    private Double chargeAmount;                        // 充电量
    private Double usageAmount;                         // 使用量
    private Double surplusAmount;                       // 剩余量
    private Double usageElecCons;                       // 使用电量
    private Double remainElecCons;                      // 剩余充电电量
    private Double remainTime;                          // 剩余充电时间
    private Double maxPower;                            // 最大功率
    private Double minPower;                            // 最小功率
    private Double avgPower;                            // 平均功率
    private Double currPower;                           // 当前功率
    private Date updateTime;                            // 更新时间
    private Date chargeFinishTime;                      // 充电结束时间
    private String finishReason;                        // 充电结束原因
    private Double finishPower;                         // 充电结束功率：单位kW
    private String closingFlag;                         // 结算标记：Y 已结算 N 未结算 L 已锁定 H 处理中
    private Double closingMoney;                        // 结算金额
    private Date closingTime;                           // 结算时间
    private String returnFlag;                          // 退费标记：Y 已退费 N 未退费 D 无需退费 F 退费失败 L 已锁定 H 处理中 W 已处理，等待通知
    private Double returnMoney;                         // 退费金额
    private Date returnTime;                            // 退费时间
    private String returnDesc;                          // 退费说明
    private String returnTradeOrderId;                  // 退费交易订单ID
    private Date returnSuccessTime;                     // 退费成功时间
    private Double income;                              // 收入
    private Double cost;                                // 成本
    private Double profit;                              // 利润
    private Double serviceMoney;                        // 服务费
    private Double incomeExService;                     // 收入（除去服务费）
    private Double profitExService;                     // 利润（除去服务费）
    private String serviceFlag;                         // 服务费收取标记：S 收取成功 F 收取失败
    private Date serviceTime;                           // 服务费收取时间
    private String serviceDesc;                         // 服务费收取说明
    private String serviceTradeOrderId;                 // 服务费交易订单ID
    private Date serviceSuccessTime;                    // 服务费收取成功时间
    private String remark;                              // 备注
    private String isCsRefund;                          // 是否申请退款：Y 已申请 N 未申请
    private String csworkorderId;                       // 退款申请客服工单标识
    private String csrefundResult;                      // 退款申请处理结果：S 退款成功 F 退款失败 W 等待处理 L 已锁定 H 处理中 T 退款处理，等待通知
    private Double csrefundMoney;                       // 退款申请处理金额
    private Date csrefundTime;                          // 退款申请处理时间
    private String csrefundTradeOrderId;                // 退款申请交易订单ID
    private Double totalReturnMoney;                    // 总退款金额
    private String schemeDetails; // 计电量方案详情信息

}
