package cn.yunrui.mqttclient.ebikesrv.mqttclient.entity;

import java.io.Serializable;
import java.util.Objects;

/**
 * @author Nick Zhang
 * @date 2019-04-28
 */
public class CostInfo implements Serializable {

    private String orgNo;
    private String costSchemeId;
    private String costSchemeNo;
    private String costSchemeName;
    private Double costUnitPrice;

    public String getOrgNo() {
        return orgNo;
    }

    public void setOrgNo(String orgNo) {
        this.orgNo = orgNo;
    }

    public String getCostSchemeId() {
        return costSchemeId;
    }

    public void setCostSchemeId(String costSchemeId) {
        this.costSchemeId = costSchemeId;
    }

    public String getCostSchemeNo() {
        return costSchemeNo;
    }

    public void setCostSchemeNo(String costSchemeNo) {
        this.costSchemeNo = costSchemeNo;
    }

    public String getCostSchemeName() {
        return costSchemeName;
    }

    public void setCostSchemeName(String costSchemeName) {
        this.costSchemeName = costSchemeName;
    }

    public Double getCostUnitPrice() {
        return costUnitPrice;
    }

    public void setCostUnitPrice(Double costUnitPrice) {
        this.costUnitPrice = costUnitPrice;
    }

    @Override
    public String toString() {
        return "CostInfo{" +
                "orgNo='" + orgNo + '\'' +
                ", costSchemeId='" + costSchemeId + '\'' +
                ", costSchemeNo='" + costSchemeNo + '\'' +
                ", costSchemeName='" + costSchemeName + '\'' +
                ", costUnitPrice=" + costUnitPrice +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if(this == o) return true;
        if(o == null || getClass() != o.getClass()) return false;
        CostInfo costInfo = (CostInfo) o;
        return Objects.equals(orgNo, costInfo.orgNo) &&
                Objects.equals(costSchemeId, costInfo.costSchemeId) &&
                Objects.equals(costSchemeNo, costInfo.costSchemeNo) &&
                Objects.equals(costSchemeName, costInfo.costSchemeName) &&
                Objects.equals(costUnitPrice, costInfo.costUnitPrice);
    }

    @Override
    public int hashCode() {
        return Objects.hash(orgNo, costSchemeId, costSchemeNo, costSchemeName, costUnitPrice);
    }

}
