package cn.yunrui.mqttclient.ebikesrv.mqttclient.entity;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;

/**
 * MQTT消息日志
 */
public class MqttMsgLog implements Serializable {

    private Long logId;                 // 日志标识
    private String deviceId;            // 设备通讯标识（MQTT规约中定义的deviceId）
    private Date msgtime;               // 消息时间
    private byte[] payload;             // 消息内容
    private String type;                // 消息类型：start - 开始充电命令；stop - 结束充电命令；status - 设备状态；param - 设备参数；cardBalance - 卡片余额；cardCharge - 卡充电命令；attachParam - 设备附加参数；...
    private String topic;               // 消息主题
    private Integer qos;                // 消息Qos
    private String direction;           // 发送方向：up - 设备到服务器；down - 服务器到设备；
    private String action;              // 动作类型：request - 请求；response - 回应；
    private Long mqttId;                // MqttMessage对象MQTT ID
    private Boolean retained;
    private Boolean duplicate;

    public Long getLogId() {
        return logId;
    }

    public void setLogId(Long logId) {
        this.logId = logId;
    }

    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public Date getMsgtime() {
        return msgtime;
    }

    public void setMsgtime(Date msgtime) {
        this.msgtime = msgtime;
    }

    public byte[] getPayload() {
        return payload;
    }

    public void setPayload(byte[] payload) {
        this.payload = payload;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTopic() {
        return topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public Integer getQos() {
        return qos;
    }

    public void setQos(Integer qos) {
        this.qos = qos;
    }

    public String getDirection() {
        return direction;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    public String getAction() {
        return action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public Long getMqttId() {
        return mqttId;
    }

    public void setMqttId(Long mqttId) {
        this.mqttId = mqttId;
    }

    public Boolean getRetained() {
        return retained;
    }

    public void setRetained(Boolean retained) {
        this.retained = retained;
    }

    public Boolean getDuplicate() {
        return duplicate;
    }

    public void setDuplicate(Boolean duplicate) {
        this.duplicate = duplicate;
    }

    @Override
    public String toString() {
        return "MqttMsgLog{" +
                "logId=" + logId +
                ", deviceId='" + deviceId + '\'' +
                ", msgtime=" + msgtime +
                ", payload=" + Arrays.toString(payload) +
                ", type='" + type + '\'' +
                ", topic='" + topic + '\'' +
                ", qos=" + qos +
                ", direction='" + direction + '\'' +
                ", action='" + action + '\'' +
                ", mqttId=" + mqttId +
                ", retained=" + retained +
                ", duplicate=" + duplicate +
                '}';
    }

}
