package cn.yunrui.mqttclient.ebikesrv.mqttclient.entity;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

public class RefreshChargeRecordResult implements Serializable {

    private boolean resendParamFlag;
    private Map<String, Object> chargeRecordValueMap;

    public RefreshChargeRecordResult() {
    }

    public RefreshChargeRecordResult(boolean resendParamFlag, Map<String, Object> chargeRecordValueMap) {
        this.resendParamFlag = resendParamFlag;
        this.chargeRecordValueMap = chargeRecordValueMap;
    }

    public boolean isResendParamFlag() {
        return resendParamFlag;
    }

    public void setResendParamFlag(boolean resendParamFlag) {
        this.resendParamFlag = resendParamFlag;
    }

    public Map<String, Object> getChargeRecordValueMap() {
        return chargeRecordValueMap;
    }

    public void setChargeRecordValueMap(Map<String, Object> chargeRecordValueMap) {
        this.chargeRecordValueMap = chargeRecordValueMap;
    }

    @Override
    public String toString() {
        return "RefreshChargeRecordResult{" +
                "resendParamFlag=" + resendParamFlag +
                ", chargeRecordValueMap=" + chargeRecordValueMap +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if(this == o) return true;
        if(o == null || getClass() != o.getClass()) return false;
        RefreshChargeRecordResult result = (RefreshChargeRecordResult) o;
        return resendParamFlag == result.resendParamFlag &&
                Objects.equals(chargeRecordValueMap, result.chargeRecordValueMap);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resendParamFlag, chargeRecordValueMap);
    }

}
