package cn.yunrui.mqttclient.ebikesrv.mqttclient.entity;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

/**
 * 检测充电设备
 */
public class TestingChargeDevice implements Serializable {

    private String orgNo;                                   // 单位编号
    private String chargedeviceNo;                          // 充电设备编号（二维码编号）
    private String deviceId;                                // 设备通讯标识（MQTT规约中定义的deviceId）
    private ChargeDeviceProtocolEnum chargeDeviceProtocol;  // 设备通讯规约（包括设备通讯规约类型及设备通讯规约版本）
    private Integer plugCount;                              // 插座个数
    private String factory;                                 // 生产厂家
    private String modelNo;                                 // 设备型号
    private String status;                                  // 设备状态：10 - 检测；
    private String opStatus;                                // 运行状态：1 - 在线；0 - 离线；
    private String binder;
    private Date bindTime;
    private Integer testCount;
    private String latestTester;
    private Date latestTestTime;
    private String latestTestResult;
    private String latestTestFailCause;
    private Date importAssetTime;
    private String importAssetResult;
    private String importAssetFailCause;

    public String getOrgNo() {
        return orgNo;
    }

    public void setOrgNo(String orgNo) {
        this.orgNo = orgNo;
    }

    public String getChargedeviceNo() {
        return chargedeviceNo;
    }

    public void setChargedeviceNo(String chargedeviceNo) {
        this.chargedeviceNo = chargedeviceNo;
    }

    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public ChargeDeviceProtocolEnum getChargeDeviceProtocol() {
        return chargeDeviceProtocol;
    }

    public void setChargeDeviceProtocol(ChargeDeviceProtocolEnum chargeDeviceProtocol) {
        this.chargeDeviceProtocol = chargeDeviceProtocol;
    }

    public Integer getPlugCount() {
        return plugCount;
    }

    public void setPlugCount(Integer plugCount) {
        this.plugCount = plugCount;
    }

    public String getFactory() {
        return factory;
    }

    public void setFactory(String factory) {
        this.factory = factory;
    }

    public String getModelNo() {
        return modelNo;
    }

    public void setModelNo(String modelNo) {
        this.modelNo = modelNo;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getOpStatus() {
        return opStatus;
    }

    public void setOpStatus(String opStatus) {
        this.opStatus = opStatus;
    }

    public String getBinder() {
        return binder;
    }

    public void setBinder(String binder) {
        this.binder = binder;
    }

    public Date getBindTime() {
        return bindTime;
    }

    public void setBindTime(Date bindTime) {
        this.bindTime = bindTime;
    }

    public Integer getTestCount() {
        return testCount;
    }

    public void setTestCount(Integer testCount) {
        this.testCount = testCount;
    }

    public String getLatestTester() {
        return latestTester;
    }

    public void setLatestTester(String latestTester) {
        this.latestTester = latestTester;
    }

    public Date getLatestTestTime() {
        return latestTestTime;
    }

    public void setLatestTestTime(Date latestTestTime) {
        this.latestTestTime = latestTestTime;
    }

    public String getLatestTestResult() {
        return latestTestResult;
    }

    public void setLatestTestResult(String latestTestResult) {
        this.latestTestResult = latestTestResult;
    }

    public String getLatestTestFailCause() {
        return latestTestFailCause;
    }

    public void setLatestTestFailCause(String latestTestFailCause) {
        this.latestTestFailCause = latestTestFailCause;
    }

    public Date getImportAssetTime() {
        return importAssetTime;
    }

    public void setImportAssetTime(Date importAssetTime) {
        this.importAssetTime = importAssetTime;
    }

    public String getImportAssetResult() {
        return importAssetResult;
    }

    public void setImportAssetResult(String importAssetResult) {
        this.importAssetResult = importAssetResult;
    }

    public String getImportAssetFailCause() {
        return importAssetFailCause;
    }

    public void setImportAssetFailCause(String importAssetFailCause) {
        this.importAssetFailCause = importAssetFailCause;
    }

    @Override
    public String toString() {
        return "TestingChargeDevice{" +
                "orgNo='" + orgNo + '\'' +
                ", chargedeviceNo='" + chargedeviceNo + '\'' +
                ", deviceId='" + deviceId + '\'' +
                ", chargeDeviceProtocol=" + chargeDeviceProtocol +
                ", plugCount=" + plugCount +
                ", factory='" + factory + '\'' +
                ", modelNo='" + modelNo + '\'' +
                ", status='" + status + '\'' +
                ", opStatus='" + opStatus + '\'' +
                ", binder='" + binder + '\'' +
                ", bindTime=" + bindTime +
                ", testCount=" + testCount +
                ", latestTester='" + latestTester + '\'' +
                ", latestTestTime=" + latestTestTime +
                ", latestTestResult='" + latestTestResult + '\'' +
                ", latestTestFailCause='" + latestTestFailCause + '\'' +
                ", importAssetTime=" + importAssetTime +
                ", importAssetResult='" + importAssetResult + '\'' +
                ", importAssetFailCause='" + importAssetFailCause + '\'' +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if(this == o) return true;
        if(o == null || getClass() != o.getClass()) return false;
        TestingChargeDevice that = (TestingChargeDevice) o;
        return Objects.equals(orgNo, that.orgNo) &&
                Objects.equals(chargedeviceNo, that.chargedeviceNo) &&
                Objects.equals(deviceId, that.deviceId) &&
                chargeDeviceProtocol == that.chargeDeviceProtocol &&
                Objects.equals(plugCount, that.plugCount) &&
                Objects.equals(factory, that.factory) &&
                Objects.equals(modelNo, that.modelNo) &&
                Objects.equals(status, that.status) &&
                Objects.equals(opStatus, that.opStatus) &&
                Objects.equals(binder, that.binder) &&
                Objects.equals(bindTime, that.bindTime) &&
                Objects.equals(testCount, that.testCount) &&
                Objects.equals(latestTester, that.latestTester) &&
                Objects.equals(latestTestTime, that.latestTestTime) &&
                Objects.equals(latestTestResult, that.latestTestResult) &&
                Objects.equals(latestTestFailCause, that.latestTestFailCause) &&
                Objects.equals(importAssetTime, that.importAssetTime) &&
                Objects.equals(importAssetResult, that.importAssetResult) &&
                Objects.equals(importAssetFailCause, that.importAssetFailCause);
    }

    @Override
    public int hashCode() {
        return Objects.hash(orgNo, chargedeviceNo, deviceId, chargeDeviceProtocol, plugCount, factory, modelNo, status, opStatus, binder, bindTime, testCount, latestTester, latestTestTime, latestTestResult, latestTestFailCause, importAssetTime, importAssetResult, importAssetFailCause);
    }
}
