package cn.yunrui.mqttclient.ebikesrv.mqttclient.entity;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

/**
 * 检测充电插座
 */
public class TestingChargePlug implements Serializable {

    private String orgNo;                                   // 单位编号
    private String chargedeviceNo;                          // 充电设备编号（二维码编号）
    private Integer plugSn;                                 // 插座序号
    private String testStatus;
    private String testStatusDesc;
    private String tester;
    private Date startTestTime;
    private Date endTestTime;

    public String getOrgNo() {
        return orgNo;
    }

    public void setOrgNo(String orgNo) {
        this.orgNo = orgNo;
    }

    public String getChargedeviceNo() {
        return chargedeviceNo;
    }

    public void setChargedeviceNo(String chargedeviceNo) {
        this.chargedeviceNo = chargedeviceNo;
    }

    public Integer getPlugSn() {
        return plugSn;
    }

    public void setPlugSn(Integer plugSn) {
        this.plugSn = plugSn;
    }

    public String getTestStatus() {
        return testStatus;
    }

    public void setTestStatus(String testStatus) {
        this.testStatus = testStatus;
    }

    public String getTestStatusDesc() {
        return testStatusDesc;
    }

    public void setTestStatusDesc(String testStatusDesc) {
        this.testStatusDesc = testStatusDesc;
    }

    public String getTester() {
        return tester;
    }

    public void setTester(String tester) {
        this.tester = tester;
    }

    public Date getStartTestTime() {
        return startTestTime;
    }

    public void setStartTestTime(Date startTestTime) {
        this.startTestTime = startTestTime;
    }

    public Date getEndTestTime() {
        return endTestTime;
    }

    public void setEndTestTime(Date endTestTime) {
        this.endTestTime = endTestTime;
    }

    @Override
    public String toString() {
        return "TestingChargePlug{" +
                "orgNo='" + orgNo + '\'' +
                ", chargedeviceNo='" + chargedeviceNo + '\'' +
                ", plugSn=" + plugSn +
                ", testStatus='" + testStatus + '\'' +
                ", testStatusDesc='" + testStatusDesc + '\'' +
                ", tester='" + tester + '\'' +
                ", startTestTime=" + startTestTime +
                ", endTestTime=" + endTestTime +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if(this == o) return true;
        if(o == null || getClass() != o.getClass()) return false;
        TestingChargePlug that = (TestingChargePlug) o;
        return Objects.equals(orgNo, that.orgNo) &&
                Objects.equals(chargedeviceNo, that.chargedeviceNo) &&
                Objects.equals(plugSn, that.plugSn) &&
                Objects.equals(testStatus, that.testStatus) &&
                Objects.equals(testStatusDesc, that.testStatusDesc) &&
                Objects.equals(tester, that.tester) &&
                Objects.equals(startTestTime, that.startTestTime) &&
                Objects.equals(endTestTime, that.endTestTime);
    }

    @Override
    public int hashCode() {
        return Objects.hash(orgNo, chargedeviceNo, plugSn, testStatus, testStatusDesc, tester, startTestTime, endTestTime);
    }

}
