package cn.yunrui.mqttclient.ebikesrv.mqttclient.handler;

import cn.yunrui.mqttclient.ebikesrv.mqttclient.cache.ChargeDeviceCache;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.cache.ChargeRecordCache;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.cache.FitconnDebuggingCache;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.cache.OpsWorkOrderCache;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargeDeviceProps;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.MsgHandleResponse;
import cn.yunrui.mqttclient.ebikesrv.syncevent.publisher.ChargeOrderEventPublisher;
import org.eclipse.paho.client.mqttv3.MqttMessage;

/**
 *
 */
public interface MqttMessageHandler {

    void setChargeDeviceCache(ChargeDeviceCache chargeDeviceCache);

    void setChargeRecordCache(ChargeRecordCache chargeRecordCache);

    void setFitconnDebuggingCache(FitconnDebuggingCache fitconnDebuggingCache);

    void setOpsWorkOrderCache(OpsWorkOrderCache opsWorkOrderCache);

    void setChargeOrderEventPublisher(ChargeOrderEventPublisher chargeOrderEventPublisher);

    /**
     * 处理上行（设备到服务器）消息
     * @param chargeDeviceProps
     *              充电设备属性
     * @param mqttMessage
     *              MQTT消息
     * @return 消息处理回应
     */
    MsgHandleResponse handleUpMessage(ChargeDeviceProps chargeDeviceProps, MqttMessage mqttMessage);

}
