package cn.yunrui.mqttclient.ebikesrv.mqttclient.handler;

import cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.MqttMsgLogDao;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.handler.impl.*;
import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import org.eclipse.paho.client.mqttv3.MqttClient;

/**
 *
 */
public class MqttMessageHandlerFactory {

    public static MqttMessageHandler getInstance(String opType, MqttClient mqttClient, MqttMsgLogDao mqttMsgLogDao) {
        if(StringUtils.equals("mqtt", opType)) {
            return new MqttHandlerImpl(mqttClient, mqttMsgLogDao);
        }
        else if(StringUtils.equals("param", opType)) {
            return new ParamHandlerImpl(mqttClient, mqttMsgLogDao);
        }
        else if(StringUtils.equals("attachParam", opType)) {
            return new AttachParamHandlerImpl(mqttClient, mqttMsgLogDao);
        }
        else if(StringUtils.equals("status", opType)) {
            return new StatusHandlerImpl(mqttClient, mqttMsgLogDao);
        }
        else if(StringUtils.equals("start", opType)) {
            return new StartHandlerImpl(mqttClient, mqttMsgLogDao);
        }
        else if(StringUtils.equals("stop", opType)) {
            return new StopHandlerImpl(mqttClient, mqttMsgLogDao);
        }
        else if(StringUtils.equals("cardBalance", opType)) {
            return new CardBalanceHandlerImpl(mqttClient, mqttMsgLogDao);
        }
        else if(StringUtils.equals("cardCharge", opType)) {
            return new CardChargeHandlerImpl(mqttClient, mqttMsgLogDao);
        }
        else if(StringUtils.equals("cardCharge2", opType)) {
            return new CardCharge2HandlerImpl(mqttClient, mqttMsgLogDao);
        }
        else if(StringUtils.equals("coinCharge", opType)) {
            return new CoinChargeHandlerImpl(mqttClient, mqttMsgLogDao);
        }
        else if(StringUtils.equals("event", opType)) {
            return new EventHandlerImpl(mqttClient, mqttMsgLogDao);
        }
        else if(StringUtils.equals("preupgrade", opType)) {
            return new PreupgradeHandlerImpl(mqttClient, mqttMsgLogDao);
        }
        else if(StringUtils.equals("upgrade", opType)) {
            return new UpgradeHandlerImpl(mqttClient, mqttMsgLogDao);
        }
        else if(StringUtils.equals("synctime", opType)) {
            return new SynctimeHandlerImpl(mqttClient, mqttMsgLogDao);
        }
        else if(StringUtils.equals("version", opType)) {
            return new VersionHandlerImpl(mqttClient, mqttMsgLogDao);
        }
        else if(StringUtils.equals("mqttaddr", opType)) {
            return new MqttaddrHandlerImpl(mqttClient, mqttMsgLogDao);
        }
        else if(StringUtils.equals("trans", opType)) {
            return new TransHandlerImpl(mqttClient, mqttMsgLogDao);
        }
        else if(StringUtils.equals("voice", opType)) {
            return new VoiceHandlerImpl(mqttClient, mqttMsgLogDao);
        }
        else if(StringUtils.equals("controlAdlamp", opType)) {
            return new ControlAdlampHandlerImpl(mqttClient, mqttMsgLogDao);
        }
        return null;
    }

}
