package cn.yunrui.mqttclient.ebikesrv.mqttclient.handler.impl;

import cn.yunrui.mqttclient.ebikesrv.common.utils.*;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.MqttMsgLogDao;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.BillingInfo;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargeDeviceProps;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.CostInfo;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.MsgHandleResponse;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.handler.MqttMessageHandler;
import com.ebikepay.openservices.entity.OrderTypeEnum;
import com.ebikepay.openservices.entity.PayTypeEnum;
import com.ebikepay.openservices.request.InnerAccountCreateRequest;
import com.ebikepay.openservices.request.InnerAccountLoadRequest;
import com.ebikepay.openservices.request.TradeOrderCreateRequest;
import com.ebikepay.openservices.request.TradeOrderPayRequest;
import com.ebikepay.openservices.response.InnerAccountCreateResponse;
import com.ebikepay.openservices.response.InnerAccountLoadResponse;
import com.ebikepay.openservices.response.TradeOrderCreateResponse;
import com.ebikepay.openservices.response.TradeOrderPayResponse;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttMessage;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * 刷卡充电请求
 * 充电桩设备到主站：
 * <deviceId>#cardCharge#<plugId>#<cardId>
 * 主站到充电桩设备:
 * cardCharge#<cardId>#<returnCode>[#<plugId>#<limit>#<limitTime>]
 * 说明：
 * <cardId>表示充电卡号；
 * <returnCode>为0表示卡充电成功，<result>为负数表示卡充电失败，-1表示无效的设备插座 -2表示插座已经在被其他人使用，-3表示该插座已被其他人预订，-4表示卡余额不足，-5表示服务器异常，-6无效的卡(卡号不存在或该卡不属于当前设备)；
 * 当<returnCode>返回0时，需要附加#<plugId>#<limit>#<limitTime>表示开始充电的信息，设备在接收到后直接开始充电
 * <limit>表示设备限制的最高充电量，单位为Wh；
 * <limitTime>表示设备限制的最大充电时间，单位为分钟；
 *
 * @author Nick Zhang
 * @date 2020-03-23
 *
 */
public class CardChargeHandlerImpl extends MqttMessageHandlerImpl implements MqttMessageHandler {

    public CardChargeHandlerImpl(MqttClient mqttClient, MqttMsgLogDao mqttMsgLogDao) {
        super("cardCharge", mqttClient, mqttMsgLogDao, true);
    }

    @Override
    public MsgHandleResponse handleUpMessage(ChargeDeviceProps chargeDeviceProps, MqttMessage mqttMessage) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start handleUpMessage >>>>>> ");
        }

        MsgHandleResponse res = new MsgHandleResponse();
        res.setStatus(-1);
        res.setMsg("处理上行（设备到服务器）消息失败 <<< 刷卡充电请求 ");

        if(chargeDeviceProps != null && StringUtils.isNotBlank(chargeDeviceProps.getDeviceId())) {
            String deviceId = chargeDeviceProps.getDeviceId();
            String rcvdMsg = new String(mqttMessage.getPayload());
            String[] rcvdMsgArray = rcvdMsg.split("#");
            String plugId = null;
            String cardId = null;
            if(rcvdMsgArray.length >= 4) {
                plugId = rcvdMsgArray[2];
                cardId = rcvdMsgArray[3];
            }

            res.setStatus(0);
            res.setMsg("处理上行（设备到服务器）消息成功 <<< 刷卡充电请求 ");

            if(needRespond && res.getStatus() == 0) {
                res = handleDownMessage(chargeDeviceProps, deviceId, plugId, cardId);
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" <<<<<<< end handleUpMessage <<<<<<< ");
        }
        return res;
    }

    private MsgHandleResponse handleDownMessage(ChargeDeviceProps chargeDeviceProps, String deviceId, String plugId, String cardId) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start handleDownMessage >>>>>> ");
            logger.debug(" chargeDeviceProps    : " + JsonConvertUtils.convertToString(chargeDeviceProps));
            logger.debug(" deviceId             : " + deviceId);
            logger.debug(" plugId               : " + plugId);
            logger.debug(" cardId               : " + cardId);
        }
        MsgHandleResponse res = new MsgHandleResponse();
        res.setStatus(-1);
        res.setMsg("处理下行（服务器到设备）消息失败 >>> 刷卡充电请求");
        if(StringUtils.isNotBlank(cardId)) {
            String cardStatus = chargeRecordCache.getStatusByCardId(cardId);
            Integer cardType = chargeRecordCache.getCardTypeByCardId(cardId);
            String orgNo = chargeRecordCache.getOrgNoByCustCardId(cardId);
            if(StringUtils.equals("1", cardStatus)) {
                // 卡已绑定
                // 查询卡余额
                InnerAccountLoadRequest innerAccountLoadRequest = new InnerAccountLoadRequest();
                innerAccountLoadRequest.setUserId(cardId);
                innerAccountLoadRequest.setUserType("bike_card");
                InnerAccountLoadResponse innerAccountLoadResponse = chargeRecordCache.loadInnerAccount(innerAccountLoadRequest);
                if(innerAccountLoadResponse != null && innerAccountLoadResponse.isSuccess()) {
                    if(logger.isDebugEnabled()) {
                        logger.debug(" InnerAccount         : " + JsonConvertUtils.convertToString(innerAccountLoadResponse.getInnerAccount()));
                    }

                    // 根据充电卡获取充电用户标识
                    String chargeUserId = chargeRecordCache.getChargeUserIdByCardId(cardId);
                    // 获取计费方案信息
                    BillingInfo bi = chargeDeviceCache.getBillingInfoByDeviceId(deviceId, chargeUserId, cardId);
                    // 获取成本方案
                    CostInfo ci = chargeDeviceCache.getCostInfoByDeviceId(deviceId);
                    // 获取服务费率
                    Double serviceRate = chargeDeviceCache.getServiceRateByDeviceId(deviceId);
                    if(logger.isDebugEnabled()) {
                        logger.debug(" chargeUserId         : " + chargeUserId);
                        logger.debug(" cardStatus           : " + cardStatus);
                        logger.debug(" cardType             : " + cardType);
                        logger.debug(" BillingInfo          : " + JsonConvertUtils.convertToString(bi));
                        logger.debug(" CostInfo             : " + JsonConvertUtils.convertToString(ci));
                        logger.debug(" serviceRate          : " + serviceRate);
                    }

                    // 运营商定制充电卡
                    int custCardCount = 0;
                    if(cardType != null && cardType == 2) {
                        custCardCount = chargeDeviceCache.getCountByDeviceIdAndCardId(deviceId, cardId);
                    }

                    if(cardType != null && cardType == 2 && custCardCount <= 0) {
                        // 卡无效
                        String voiceId = "6";
                        String msg2Device = "voice" + "#" + voiceId;
                        response2device(deviceId, msg2Device, "voice");
                    }
                    else {
                        if(bi != null) {
                            // 计费方案类型
                            String billingSchemeType = bi.getSchemeType();
                            // 充电金额
                            Double chargeMoney;
                            if(StringUtils.equals(billingSchemeType, "03")) {
                                // 计次（按时间）
                                chargeMoney = bi.getUnitPrice1();
                            }
                            else {
                                // 计时间或计电量
                                chargeMoney = 1.0D;
                                if(bi.getMinCharge() != null && bi.getMinCharge().compareTo(0.0D) > 0) {
                                    chargeMoney = bi.getMinCharge();
                                }
                                else if(bi.getUnitPrice1() != null && bi.getUnitPrice1().compareTo(0.0D) == 0) {
                                    // 免费充电
                                    chargeMoney = 0.0D;
                                }
                            }
                            // 充电卡余额
                            Double accountBalance = innerAccountLoadResponse.getInnerAccount().getAccountBalance();
                            if(logger.isDebugEnabled()) {
                                logger.debug(" [　计费类型]       : " + billingSchemeType);
                                logger.debug(" [　充电金额]       : " + chargeMoney);
                                logger.debug(" [充电卡余额]       : " + accountBalance);
                            }

                            if(accountBalance >= chargeMoney) {
                                Map<String, Object> chargeRecordMap = chargeRecordCache.getChargeRecordMap(deviceId, plugId);
                                if(logger.isDebugEnabled()) {
                                    logger.debug(" 1.1. ");
                                    logger.debug(" deviceId         : " + deviceId);
                                    logger.debug(" plugId           : " + plugId);
                                    logger.debug(" chargeRecordMap  : " + JsonConvertUtils.convertToString(chargeRecordMap));
                                }
                                // 充电类型：0 - 不充电；1 - 新开插座充电；2 - 在原有充电插座上续充（同一张充电卡）；3 - 该充电桩插座已满，请选择附近其他充电桩；9 - 该插座被占用，请选择其它插座充电
                                int chargeType;
                                if(MapUtils.isNotEmpty(chargeRecordMap)) {
                                    // 插座正在充电
                                    // 计次（按时间）
                                    if(StringUtils.equals(billingSchemeType, "03")) {
                                        chargeType = 9;
                                    }
                                    else {
                                        // 判断是否同一张充电卡，是否需要续充：当原来的充电方案不为按次，且当前充电方案也不会按次，则需要续充
                                        if(StringUtils.notEquals((String) chargeRecordMap.get("schemeType"), "03") && StringUtils.equals((String) chargeRecordMap.get("card_id"), cardId)) {
                                            chargeType = 2;
                                        }
                                        else {
                                            chargeType = 9;
                                        }
                                    }
                                }
                                else {
                                    chargeType = 1;
                                }
                                if(logger.isDebugEnabled()) {
                                    logger.debug(" chargeType       : " + chargeType);
                                    logger.debug(" deviceId         : " + deviceId);
                                    logger.debug(" plugId           : " + plugId);
                                }

                                // 1 - 新开插座充电；
                                if(chargeType == 1) {
                                    if(logger.isDebugEnabled()) {
                                        logger.debug(" old chargeRecordMap      : " + JsonConvertUtils.convertToString(chargeRecordMap));
                                    }
                                    // 该插座无当前充电记录，则判断是否在装接调试
                                    if(fitconnDebuggingCache.checkIsDebugging(deviceId, plugId)) {
                                        // 该插座正在装接调试，则结束装接调试
                                        // 结束装接调试日志记录
                                        Map<String, Object> valueMap = new HashMap<>();
                                        valueMap.put("debugFinishTime", new Date());
                                        fitconnDebuggingCache.finishFitconnDebuggingLog(deviceId, plugId, valueMap);
                                        // 充电设备状态更新
                                        // 插座状态置为 0 - 空闲
                                        chargeDeviceCache.updatePlugStatus(deviceId, plugId, "0");
                                    }
                                    String chargeplugNo = chargeDeviceProps.getChargedeviceNo() + String.format("%02d", Integer.parseInt(plugId));
                                    Date chargeTime = new Date();
                                    String chargeRecordId = getNewChargeRecordId(chargeplugNo, chargeTime);
                                    chargeRecordMap = getChargeRecordMapByCard(bi, chargeMoney);
                                    if(logger.isDebugEnabled()) {
                                        logger.debug(" getChargeRecordMapByCard : " + JsonConvertUtils.convertToString(chargeRecordMap));
                                    }
                                    if(chargeMoney.compareTo(0.0D) > 0) {
                                        // 刷卡支付交易订单
                                        TradeOrderCreateRequest tradeOrderCreateRequest = new TradeOrderCreateRequest();
                                        if(cardType != null && cardType == 2) {
                                            InnerAccountLoadRequest loadEbikeOrgCustCardAccountRequest = new InnerAccountLoadRequest();
                                            loadEbikeOrgCustCardAccountRequest.setUserId(orgNo);
                                            loadEbikeOrgCustCardAccountRequest.setUserType("ebike_org_cust_card");
                                            InnerAccountLoadResponse loadEbikeOrgCustCardAccountResponse = chargeRecordCache.loadInnerAccount(loadEbikeOrgCustCardAccountRequest);
                                            if(!(loadEbikeOrgCustCardAccountResponse != null && loadEbikeOrgCustCardAccountResponse.isSuccess())) {
                                                InnerAccountCreateRequest ebikeOrgCustCardAccountCreateRequest = new InnerAccountCreateRequest();
                                                ebikeOrgCustCardAccountCreateRequest.setUserId(orgNo);
                                                ebikeOrgCustCardAccountCreateRequest.setUserType("ebike_org_cust_card");
                                                ebikeOrgCustCardAccountCreateRequest.setUserName(orgNo);
                                                InnerAccountCreateResponse ebikeOrgCustCardAccountCreateResponse = chargeRecordCache.createInnerAccount(ebikeOrgCustCardAccountCreateRequest);
                                            }
                                            tradeOrderCreateRequest.setUserId(orgNo);
                                            tradeOrderCreateRequest.setUserType("ebike_org_cust_card");
                                        }
                                        else {
                                            tradeOrderCreateRequest.setUserId("10000000");
                                            tradeOrderCreateRequest.setUserType("ebike_transit");
                                        }
                                        tradeOrderCreateRequest.setCounterUserId(cardId);
                                        tradeOrderCreateRequest.setCounterUserType("bike_card");
                                        tradeOrderCreateRequest.setOrderMoney(chargeMoney);
                                        tradeOrderCreateRequest.setOrderType(OrderTypeEnum.TRADE.getCode());
                                        tradeOrderCreateRequest.setBusinessModule("ebike-card-charge");
                                        tradeOrderCreateRequest.setBusinessId(chargeRecordId);
                                        tradeOrderCreateRequest.setOrderRemark("充电卡[" + cardId + "]充电，充电金额：" + chargeMoney + "元");
                                        TradeOrderCreateResponse tradeOrderCreateResponse = chargeRecordCache.createTradeOrder(tradeOrderCreateRequest);
                                        if(tradeOrderCreateResponse != null && tradeOrderCreateResponse.isSuccess()) {
                                            TradeOrderPayRequest tradeOrderPayRequest = new TradeOrderPayRequest();
                                            tradeOrderPayRequest.setOrderId(tradeOrderCreateResponse.getTradeOrder().getOrderId());
                                            tradeOrderPayRequest.setPayMoney(chargeMoney);
                                            tradeOrderPayRequest.setPayType(PayTypeEnum.INNERACCT.getCode());
                                            TradeOrderPayResponse tradeOrderPayResponse = chargeRecordCache.payTradeOrder(tradeOrderPayRequest);
                                            if(tradeOrderPayResponse != null && tradeOrderPayResponse.isSuccess()) {
                                                if(chargeRecordMap != null) {
                                                    chargeRecordMap.put("chargeRecordId", chargeRecordId);
                                                    chargeRecordMap.put("chargeTime", chargeTime);
                                                    chargeRecordMap.put("chargeplugId", chargeDeviceProps.getPlugPropsMap().get(Integer.parseInt(plugId)).getChargeplugId());
                                                    chargeRecordMap.put("chargedeviceId", chargeDeviceProps.getChargedeviceId());
                                                    chargeRecordMap.put("chargestationId", chargeDeviceProps.getChargestationId());
                                                    chargeRecordMap.put("chargeUserId", chargeUserId);
                                                    chargeRecordMap.put("chargeTradeOrderId", tradeOrderPayResponse.getTradeOrder().getOrderId());
                                                    if(cardType != null && cardType == 2) {
                                                        chargeRecordMap.put("enterUserType", "ebike_org_cust_card");
                                                        chargeRecordMap.put("enterUserId", orgNo);
                                                    }
                                                    else {
                                                        chargeRecordMap.put("enterUserType", "ebike_transit");
                                                        chargeRecordMap.put("enterUserId", "10000000");
                                                    }
                                                    chargeRecordMap.put("serviceRate", serviceRate);
                                                    if(ObjectUtils.isNotNull(ci)) {
                                                        chargeRecordMap.put("costSchemeId", ci.getCostSchemeId());
                                                        chargeRecordMap.put("costUnitPrice", ci.getCostUnitPrice());
                                                    }
                                                    Double remainElecCons = (Double) chargeRecordMap.get("remainElecCons");
                                                    Double remainTime = (Double) chargeRecordMap.get("remainTime");
                                                    String msg2Device = "cardCharge" + "#" + cardId + "#0" + "#" + plugId + "#" + Math.round(remainElecCons * 1000.0D) + "#" + Math.round(remainTime);
                                                    int result = 0;
                                                    // 运营商定制充电卡
                                                    if(cardType != null && cardType == 2) {
                                                        result = chargeRecordCache.insertChargeRecordByCustCard(chargeRecordMap, chargeplugNo, cardId);
                                                    }
                                                    else {
                                                        result = chargeRecordCache.insertChargeRecordByCard(chargeRecordMap, chargeplugNo, cardId);
                                                    }
                                                    if(result > 0) {
                                                        // 下发开始充电命令
                                                        boolean r = response2device(deviceId, msg2Device, "cardCharge");
                                                        if(logger.isInfoEnabled()) {
                                                            logger.info("刷卡充电请求下发开始充电命令" + (r ? "成功" : "失败"));
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                        else {
                                            String msg2Device = "cardCharge" + "#" + cardId + "#-5";
                                            // 下发开始充电命令
                                            boolean r = response2device(deviceId, msg2Device, "cardCharge");
                                            if(logger.isInfoEnabled()) {
                                                logger.info("刷卡充电请求下发开始充电命令" + (r ? "成功" : "失败"));
                                            }
                                        }
                                    }
                                    else {
                                        // 免费充电
                                        if(chargeRecordMap != null) {
                                            chargeRecordMap.put("chargeRecordId", chargeRecordId);
                                            chargeRecordMap.put("chargeTime", chargeTime);
                                            chargeRecordMap.put("chargeplugId", chargeDeviceProps.getPlugPropsMap().get(Integer.parseInt(plugId)).getChargeplugId());
                                            chargeRecordMap.put("chargedeviceId", chargeDeviceProps.getChargedeviceId());
                                            chargeRecordMap.put("chargestationId", chargeDeviceProps.getChargestationId());
                                            chargeRecordMap.put("chargeUserId", chargeUserId);
                                            chargeRecordMap.put("chargeTradeOrderId", null);
                                            chargeRecordMap.put("enterUserType", null);
                                            chargeRecordMap.put("enterUserId", null);
                                            chargeRecordMap.put("serviceRate", null);
                                            if(ObjectUtils.isNotNull(ci)) {
                                                chargeRecordMap.put("costSchemeId", ci.getCostSchemeId());
                                                chargeRecordMap.put("costUnitPrice", ci.getCostUnitPrice());
                                            }
                                            Double remainElecCons = (Double) chargeRecordMap.get("remainElecCons");
                                            Double remainTime = (Double) chargeRecordMap.get("remainTime");
                                            String msg2Device = "cardCharge" + "#" + cardId + "#0" + "#" + plugId + "#" + Math.round(remainElecCons * 1000.0D) + "#" + Math.round(remainTime);

                                            int result = 0;
                                            // 运营商定制充电卡
                                            if(cardType != null && cardType == 2) {
                                                result = chargeRecordCache.insertChargeRecordByCustCard(chargeRecordMap, chargeplugNo, cardId);
                                            }
                                            else {
                                                result = chargeRecordCache.insertChargeRecordByCard(chargeRecordMap, chargeplugNo, cardId);
                                            }
                                            if(result > 0) {
                                                // 下发开始充电命令
                                                boolean r = response2device(deviceId, msg2Device, "cardCharge");
                                                if(logger.isInfoEnabled()) {
                                                    logger.info("刷卡充电请求下发开始充电命令" + (r ? "成功" : "失败"));
                                                }
                                            }
                                        }
                                    }
                                }
                                // 2 - 在原有充电插座上续充（同一张充电卡）；
                                else if(chargeType == 2) {
                                    if(logger.isDebugEnabled()) {
                                        logger.debug(" old chargeRecordMap      : " + JsonConvertUtils.convertToString(chargeRecordMap));
                                    }
                                    Map<String, Object> newChargeRecordMap = getChargeRecordMapByCard(bi, chargeMoney);
                                    if(logger.isDebugEnabled()) {
                                        logger.debug(" new add chargeRecordMap      : " + JsonConvertUtils.convertToString(newChargeRecordMap));
                                    }
                                    // TODO 2 - 在原有充电插座上续充（同一张充电卡）；
                                }
                                // 9 - 该插座被占用，请选择其它插座充电
                                else {
                                    String voiceId = "9";
                                    String msg2Device = "voice" + "#" + voiceId;
                                    response2device(deviceId, msg2Device, "voice");
                                }
                            }
                            else {
                                // 该卡余额不足，请充值。
                                String voiceId = "7";
                                String msg2Device = "voice" + "#" + voiceId;
                                response2device(deviceId, msg2Device, "voice");
                            }
                        }
                        else {
                            // 卡无效
                            String voiceId = "6";
                            String msg2Device = "voice" + "#" + voiceId;
                            response2device(deviceId, msg2Device, "voice");
                        }
                    }
                }
                else {
                    // 该卡余额不足，请充值。
                    String voiceId = "7";
                    String msg2Device = "voice" + "#" + voiceId;
                    response2device(deviceId, msg2Device, "voice");
                }
            }
            else if(StringUtils.equals("2", cardStatus)) {
                // 卡未绑定（已解绑）
                String voiceId = "1";
                String msg2Device = "voice" + "#" + voiceId;
                response2device(deviceId, msg2Device, "voice");
            }
            else if(StringUtils.equals("0", cardStatus)) {
                // 卡未绑定（初始化）
                String voiceId = "1";
                String msg2Device = "voice" + "#" + voiceId;
                response2device(deviceId, msg2Device, "voice");
            }
            else {
                // 卡无效
                String voiceId = "6";
                String msg2Device = "voice" + "#" + voiceId;
                response2device(deviceId, msg2Device, "voice");
            }
        }
        else {
            // 卡无效
            String voiceId = "6";
            String msg2Device = "voice" + "#" + voiceId;
            response2device(deviceId, msg2Device, "voice");
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" <<<<<<< end handleDownMessage <<<<<<< ");
        }
        return res;
    }

}
