package cn.yunrui.mqttclient.ebikesrv.mqttclient.handler.impl;

import cn.yunrui.mqttclient.ebikesrv.common.utils.JsonConvertUtils;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.MqttMsgLogDao;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.BillingInfo;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargeDeviceProps;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargeDeviceProtocolEnum;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.MsgHandleResponse;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.handler.MqttMessageHandler;
import cn.yunrui.mqttclient.ebikesrv.common.utils.MapUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttMessage;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * 投币充电请求
 *
 * @author Nick Zhang
 * @date 2019-03-26
 *
 */
public class CoinChargeHandlerImpl extends MqttMessageHandlerImpl implements MqttMessageHandler {

    public CoinChargeHandlerImpl(MqttClient mqttClient, MqttMsgLogDao mqttMsgLogDao) {
        super("coinCharge", mqttClient, mqttMsgLogDao, true);
    }

    @Override
    public MsgHandleResponse handleUpMessage(ChargeDeviceProps chargeDeviceProps, MqttMessage mqttMessage) {
        // 设备到服务器：<deviceId>#coinCharge#<plugId>#<money>
        // <money>单位为分（研江）/ 单位为元（超翔）
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start handleUpMessage >>>>>> ");
        }

        MsgHandleResponse res = new MsgHandleResponse();
        res.setStatus(-1);
        res.setMsg("处理上行（设备到服务器）消息失败 <<< 投币充电请求");

        if(chargeDeviceProps != null && StringUtils.isNotBlank(chargeDeviceProps.getDeviceId())) {
            String deviceId = chargeDeviceProps.getDeviceId();
            String rcvdMsg = new String(mqttMessage.getPayload());
            String[] rcvdMsgArray = rcvdMsg.split("#");
            String plugId = null;
            String smoney = null;
            Date currTime = new Date();
            if(rcvdMsgArray.length >= 4) {
                plugId = rcvdMsgArray[2];
                smoney = rcvdMsgArray[3];
            }
            Double money = 0.0D;
            if(smoney !=null) {
                try {
                    money = Double.parseDouble(smoney);
                }
                catch(NumberFormatException _nfe) {
                    logger.error(_nfe.getMessage(), _nfe.fillInStackTrace());
                }
            }

            res.setStatus(0);
            res.setMsg("处理上行（设备到服务器）消息成功 <<< 投币充电请求");

            if(needRespond && res.getStatus() == 0) {
                res = handleDownMessage(chargeDeviceProps, plugId, money);
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" <<<<<<< end handleUpMessage <<<<<<< ");
        }
        return res;
    }

    private MsgHandleResponse handleDownMessage(ChargeDeviceProps chargeDeviceProps, String plugId, Double money) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start handleDownMessage >>>>>> ");
            logger.debug(" chargeDeviceProps    : " + JsonConvertUtils.convertToString(chargeDeviceProps));
            logger.debug(" plugId               : " + plugId);
            logger.debug(" money                : " + money);
        }
        MsgHandleResponse res = new MsgHandleResponse();
        res.setStatus(-1);
        res.setMsg("处理下行（服务器到设备）消息失败 >>> 投币充电请求");
        if(chargeDeviceProps != null && StringUtils.isNotBlank(chargeDeviceProps.getDeviceId()) && StringUtils.isNotBlank(plugId)) {
            String deviceId = chargeDeviceProps.getDeviceId();
            Map<String, Object> chargeRecordMap = chargeRecordCache.getChargeRecordMap(deviceId, plugId);
            if(logger.isDebugEnabled()) {
                logger.debug(" chargeRecordMap      : " + JsonConvertUtils.convertToString(chargeRecordMap));
            }
            if(MapUtils.isNotEmpty(chargeRecordMap)) {
                // 该插座有当前充电记录，则下发投币命令失败
                res.setStatus(-2);
                res.setMsg("处理下行（服务器到设备）消息失败 >>> 投币充电请求，充电插座正在充电");
            }
            else {
                // 该插座无当前充电记录，则判断是否在装接调试
                if(fitconnDebuggingCache.checkIsDebugging(deviceId, plugId)) {
                    // 该插座正在装接调试，则结束装接调试
                    // 结束装接调试日志记录
                    Map<String, Object> valueMap = new HashMap<>();
                    valueMap.put("debugFinishTime", new Date());
                    fitconnDebuggingCache.finishFitconnDebuggingLog(deviceId, plugId, valueMap);
                    // 充电设备状态更新
                    // 插座状态置为 0 - 空闲
                    chargeDeviceCache.updatePlugStatus(deviceId, plugId, "0");
                }
                /*Double remainElecCons = 9.000D;
                Double remainTime = 180.0D;
                if(bi != null && StringUtils.equals("01", bi.getSchemeType()) && bi.getUnitPrice1() != null) {
                    if(bi.getUnitPrice1() > 0) {
                        remainTime = bi.getUnitPrice1() * 60.0D;
                    }
                    else {
                        remainTime = IntegerUtils.defaultIfNull(bi.getMaxChargeTime(), MAX_CHARGE_TIME_FOR_FREE) * 1.0D;
                    }
                }*/
                if(chargeDeviceProps.getChargeDeviceProtocol().equals(ChargeDeviceProtocolEnum.MQTT_YJM2M_201804)) {
                    // 单位分转换为元
                    money = money / 100.0D;
                }
                BillingInfo bi = chargeDeviceCache.getDefaultBillingInfoByDeviceId(deviceId);
                chargeRecordMap = getChargeRecordMapByCoinsin(bi, money);
                if(logger.isDebugEnabled()) {
                    logger.debug(" BillingInfo          : " + JsonConvertUtils.convertToString(bi));
                    logger.debug(" chargeRecordMap      : " + JsonConvertUtils.convertToString(chargeRecordMap));
                }
                String chargeplugNo = chargeDeviceProps.getChargedeviceNo() + String.format("%02d", Integer.parseInt(plugId));
                // 投币用户
                String chargeUserId = "000000-ebike-coinsin-charge-user";
                Date chargeTime = new Date();
                if(chargeRecordMap != null) {
                    chargeRecordMap.put("chargeRecordId", getNewChargeRecordId(chargeplugNo, chargeTime));
                    chargeRecordMap.put("chargeTime", chargeTime);
                    ///chargeRecordMap.put("chargeplugId", chargeplugId);
                    ///chargeRecordMap.put("chargedeviceId", chargedeviceId);
                    ///chargeRecordMap.put("chargestationId", chargestationId);
                    chargeRecordMap.put("chargeUserId", chargeUserId);
                    Double remainElecCons = (Double) chargeRecordMap.get("remainElecCons");
                    Double remainTime = (Double) chargeRecordMap.get("remainTime");
                    String msg2Device = "coinCharge" + "#" + plugId + "#" + Math.round(remainElecCons * 1000.0D) + "#" + Math.round(remainTime);
                    int result = chargeRecordCache.insertChargeRecordByCoinsin(chargeRecordMap, chargeplugNo);
                    if(result > 0) {
                        // 下发开始充电命令
                        boolean r = response2device(deviceId, msg2Device, "coinCharge");
                        if(logger.isInfoEnabled()) {
                            logger.info("投币下发开始充电命令" + (r ? "成功" : "失败"));
                        }
                    }
                }

                res.setStatus(0);
                res.setMsg("处理下行（设备到服务器）消息成功 >>> 投币充电请求");
            }
        }
        if(logger.isDebugEnabled()) {
            logger.debug(" <<<<<<< end handleDownMessage <<<<<<< ");
        }
        return res;
    }

}
