package cn.yunrui.mqttclient.ebikesrv.mqttclient.handler.impl;

import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.MqttMsgLogDao;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargeDeviceProps;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.MsgHandleResponse;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.handler.MqttMessageHandler;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttMessage;

/**
 * 控制广告灯（一托二设备）
 *
 * 主站到充电桩设备：
 * controlAdlamp#<controlAction>
 * 充电桩设备到主站：
 * <deviceId>#controlAdlamp#<result>#<adlampStatus>
 * 说明：
 * <controlAction>表示控制动作，1表示打开，0表示关闭；
 * <result>为0表示控制广告灯成功，<result>为负数表示控制广告灯失败，-1表示广告灯模块已损坏；
 * <adlampStatus>为当前广告灯状态，1为打开，0为关闭，-1为广告灯模块已损坏；
 *
 * @author Nick Zhang
 * @date 2019-04-10
 *
 */
public class ControlAdlampHandlerImpl extends MqttMessageHandlerImpl implements MqttMessageHandler {

    public ControlAdlampHandlerImpl(MqttClient mqttClient, MqttMsgLogDao mqttMsgLogDao) {
        super("controlAdlamp", mqttClient, mqttMsgLogDao, false);
    }

    @Override
    public MsgHandleResponse handleUpMessage(ChargeDeviceProps chargeDeviceProps, MqttMessage mqttMessage) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start handleUpMessage >>>>>> ");
        }

        MsgHandleResponse res = new MsgHandleResponse();
        res.setStatus(-1);
        res.setMsg("处理上行（设备到服务器）消息失败 <<< 控制广告灯（一托二设备）");

        if(chargeDeviceProps != null && StringUtils.isNotBlank(chargeDeviceProps.getDeviceId())) {
            res.setStatus(0);
            res.setMsg("处理上行（设备到服务器）消息成功 <<< 控制广告灯（一托二设备）");

            if(needRespond && res.getStatus() == 0) {
                res = handleDownMessage(chargeDeviceProps);
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" <<<<<<< end handleUpMessage <<<<<<< ");
        }
        return res;
    }

    @Override
    public MsgHandleResponse handleDownMessage(ChargeDeviceProps chargeDeviceProps) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start handleDownMessage >>>>>> ");
        }
        MsgHandleResponse res = new MsgHandleResponse();
        res.setStatus(0);
        res.setMsg("处理下行（服务器到设备）消息成功 >>> 控制广告灯（一托二设备）");
        if(logger.isDebugEnabled()) {
            logger.debug(" <<<<<<< end handleDownMessage <<<<<<< ");
        }
        return res;
    }

}
