package cn.yunrui.mqttclient.ebikesrv.mqttclient.handler.impl;

import cn.yunrui.mqttclient.ebikesrv.common.utils.*;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.MqttMsgLogDao;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargeDeviceProps;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargePlugProps;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.MsgHandleResponse;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.OpsWorkOrder;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.handler.MqttMessageHandler;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttMessage;

import java.util.Arrays;
import java.util.Date;
import java.util.List;

/**
 * 告警事件
 *
 * @author Nick Zhang
 * @date 2019-03-26
 *
 */
public class EventHandlerImpl extends MqttMessageHandlerImpl implements MqttMessageHandler {

    public EventHandlerImpl(MqttClient mqttClient, MqttMsgLogDao mqttMsgLogDao) {
        super("event", mqttClient, mqttMsgLogDao, false);
    }

    @Override
    public MsgHandleResponse handleUpMessage(ChargeDeviceProps chargeDeviceProps, MqttMessage mqttMessage) {
        // 设备到服务器：<deviceId>#event#<plugId>#<eventCode>
        // <plugId>为0时，表示是充电桩设备的告警事件，如<plugId>大于0时，表示是该插座序号的告警事件；
        // <eventCode>为告警事件编码，0001表示停电告警，为充电桩设备告警事件；
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start handleUpMessage >>>>>> ");
        }

        MsgHandleResponse res = new MsgHandleResponse();
        res.setStatus(-1);
        res.setMsg("处理上行（设备到服务器）消息失败 <<< 告警事件报文");

        if(chargeDeviceProps != null && StringUtils.isNotBlank(chargeDeviceProps.getDeviceId())) {
            String deviceId = chargeDeviceProps.getDeviceId();
            String rcvdMsg = new String(mqttMessage.getPayload());
            String[] rcvdMsgArray = rcvdMsg.split("#");
            String plugId = null;
            // 告警事件编码，0001表示停电告警，为充电桩设备告警事件
            String eventCode = null;
            String eventValue = null;
            Date currTime = new Date();
            if(rcvdMsgArray.length >= 4) {
                plugId = rcvdMsgArray[2];
                eventCode = rcvdMsgArray[3];
                if(rcvdMsgArray.length >= 5) {
                    eventValue = rcvdMsgArray[4];
                }
            }

            if(logger.isDebugEnabled()) {
                logger.debug("deviceId      : " + deviceId);
                logger.debug("plugId        : " + plugId);
                logger.debug("eventCode     : " + eventCode);
                logger.debug("eventValue    : " + eventValue);
                logger.debug("currTime      : " + DateFormatUtils.format(currTime, "yyyy-MM-dd HH:mm:ss.SSS"));
            }

            //
            Integer plugSn = 0;
            Integer eventNo = 0;
            if(NumberUtils.isParsable(plugId) && NumberUtils.isParsable(eventCode)) {
                plugSn = Integer.parseInt(plugId);
                eventNo = Integer.parseInt(eventCode);
            }

            if(eventNo == 1 && plugSn == 0) {
                // 设备停电事件上报时，置设备在线状态为离线
                if(StringUtils.isNotBlank(chargeDeviceProps.getDeviceId()) && chargeDeviceProps.getPlugCount() != null && chargeDeviceProps.getPlugCount() > 0) {
                    String[] plugStatus = new String[chargeDeviceProps.getPlugCount()];
                    Arrays.fill(plugStatus, "9");
                    //
                    ChargeDeviceProps cdp = chargeDeviceCache.get(chargeDeviceProps.getDeviceId());
                    if(cdp != null && MapUtils.isNotEmpty(cdp.getPlugPropsMap())) {
                        for(int i = 0; i < cdp.getPlugPropsMap().size(); i++) {
                            ChargePlugProps cpp = cdp.getPlugPropsMap().get(i + 1);
                            if(cpp != null && StringUtils.isNotBlank(cpp.getOpStatus())) {
                                if(StringUtils.equals("1", cpp.getOpStatus())) {
                                    // 1 - 正在使用
                                    plugStatus[i] = "1";
                                }
                                else if(StringUtils.equals("2", cpp.getOpStatus())) {
                                    // 2 - 已被预订
                                    plugStatus[i] = "2";
                                }
                                else if(StringUtils.equals("8", cpp.getOpStatus())) {
                                    // 8 - 正在检修
                                    plugStatus[i] = "8";
                                }
                            }
                        }
                    }
                    chargeDeviceCache.updateOpStatus(chargeDeviceProps.getDeviceId(), "0", plugStatus);
                }
                // 获取未复归设备停电告警
                // 102 - 设备停电
                List<OpsWorkOrder> opsWorkOrderList = opsWorkOrderCache.getOpsWorkOrderList(deviceId, String.valueOf(plugSn), "102", "N");
                if(CollectionUtils.sizeIsNotEmptyIgnoreNull(opsWorkOrderList)) {
                    int index = 1;
                    for(OpsWorkOrder opsWorkOrder : opsWorkOrderList) {
                        if(index > 1) {
                            opsWorkOrder.setIsRecovery("Y");
                            opsWorkOrder.setRecoveryTime(new Date());
                            opsWorkOrderCache.recoveryOpsWorkOrder(opsWorkOrder);
                        }
                        index++;
                    }
                }
                else {
                    OpsWorkOrder opsWorkOrder = new OpsWorkOrder();
                    // 102 - 设备停电
                    opsWorkOrder.setOpsworkorderId(WorkOrderIdUtils.getNewOpsWorkOrderId(chargeDeviceProps.getChargedeviceNo(), "102"));
                    opsWorkOrder.setOpsworkorderType("102");
                    // 10 - 未处理
                    opsWorkOrder.setOpsworkorderStatus("10");
                    opsWorkOrder.setOpsObjectType("EBikeChargeDevice");
                    opsWorkOrder.setOpsObjectId(chargeDeviceProps.getChargedeviceId());
                    opsWorkOrder.setOpsworkorderDesc("设备停电");
                    opsWorkOrderCache.createOpsWorkOrder(opsWorkOrder);
                }
            }

            res.setStatus(0);
            res.setMsg("处理上行（设备到服务器）消息成功 <<< 告警事件报文");

            if(needRespond && res.getStatus() == 0) {
                res = handleDownMessage(chargeDeviceProps);
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" <<<<<<< end handleUpMessage <<<<<<< ");
        }
        return res;
    }

    @Override
    protected MsgHandleResponse handleDownMessage(ChargeDeviceProps chargeDeviceProps) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start handleDownMessage >>>>>> ");
        }
        MsgHandleResponse res = new MsgHandleResponse();
        res.setStatus(0);
        res.setMsg("处理下行（服务器到设备）消息成功 >>> 告警事件报文");
        if(logger.isDebugEnabled()) {
            logger.debug(" <<<<<<< end handleDownMessage <<<<<<< ");
        }
        return res;
    }

}
