package cn.yunrui.mqttclient.ebikesrv.mqttclient.handler.impl;

import cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.MqttMsgLogDao;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargeDeviceProps;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.MsgHandleResponse;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.handler.MqttMessageHandler;
import cn.yunrui.mqttclient.ebikesrv.common.utils.JsonConvertUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.ObjectUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttMessage;

/**
 * MQTT地址端口请求
 *
 * @author Nick Zhang
 * @date 2019-03-26
 *
 */
public class MqttHandlerImpl extends MqttMessageHandlerImpl implements MqttMessageHandler {

    public MqttHandlerImpl(MqttClient mqttClient, MqttMsgLogDao mqttMsgLogDao) {
        super("mqtt", mqttClient, mqttMsgLogDao, true);
    }

    @Override
    public MsgHandleResponse handleUpMessage(ChargeDeviceProps chargeDeviceProps, MqttMessage mqttMessage) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start handleUpMessage >>>>>> ");
        }

        MsgHandleResponse res = new MsgHandleResponse();
        res.setStatus(-1);
        res.setMsg("处理上行（设备到服务器）消息失败 <<< MQTT地址端口请求");

        if(logger.isDebugEnabled()) {
            logger.debug(" ChargeDeviceProps : " + JsonConvertUtils.convertToString(chargeDeviceProps));
        }
        if(chargeDeviceProps != null && StringUtils.isNotBlank(chargeDeviceProps.getDeviceId())) {
            res.setStatus(0);
            res.setMsg("处理上行（设备到服务器）消息成功 <<< MQTT地址端口请求");

            // 设备上电时，重新加载缓存
            chargeDeviceProps = chargeDeviceCache.reload(chargeDeviceProps.getDeviceId());

            if(needRespond && res.getStatus() == 0) {
                res = handleDownMessage(chargeDeviceProps);
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" <<<<<<< end handleUpMessage <<<<<<< ");
        }
        return res;
    }

    @Override
    protected MsgHandleResponse handleDownMessage(ChargeDeviceProps chargeDeviceProps) {
        // 服务器到设备：mqtt#<ip>#<port>#<topic> or mqtt#ERROR
        // <ip>
        // <port>
        // <topic>
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start handleDownMessage >>>>>> ");
        }
        MsgHandleResponse res = new MsgHandleResponse();
        res.setStatus(-1);
        res.setMsg("处理下行（服务器到设备）消息失败 >>> MQTT地址端口请求");
        String ip = "116.62.193.121";
        String port = "61613";
        String topic = "001";
        if(ObjectUtils.isNotNull(chargeDeviceProps) && StringUtils.isNotBlank(chargeDeviceProps.getDeviceId())) {
            if(StringUtils.isNotBlank(chargeDeviceProps.getMqttBrokerHostIp())) {
                ip = chargeDeviceProps.getMqttBrokerHostIp().trim();
            }
            if(StringUtils.isNotBlank(chargeDeviceProps.getMqttBrokerHostPort())) {
                port = chargeDeviceProps.getMqttBrokerHostPort().trim();
            }
            if(StringUtils.isNotBlank(chargeDeviceProps.getServerSubTopic())) {
                topic = chargeDeviceProps.getServerSubTopic().trim();
            }
            String msg2Device = opType + "#" + ip + "#" + port + "#" + topic;
            boolean bp = response2device(chargeDeviceProps.getDeviceId(), msg2Device, opType);
            if(bp) {
                res.setStatus(0);
                res.setMsg("处理下行（服务器到设备）消息成功 >>> MQTT地址端口请求");
            }
        }
        else {
            String msg2Device = opType + "#ERROR";
            boolean bp = response2device(chargeDeviceProps.getDeviceId(), msg2Device, opType);
            if(bp) {
                res.setStatus(0);
                res.setMsg("处理下行（服务器到设备）消息成功 >>> MQTT地址端口请求");
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" <<<<<<< end handleDownMessage <<<<<<< ");
        }
        return res;
    }

}
