package cn.yunrui.mqttclient.ebikesrv.mqttclient.handler.impl;

import cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.MqttMsgLogDao;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargeDeviceProps;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.MsgHandleResponse;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.handler.MqttMessageHandler;
import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttMessage;

/**
 * 设置通讯参数
 *
 * @author Nick Zhang
 * @date 2019-03-26
 *
 *
 */
public class MqttaddrHandlerImpl extends MqttMessageHandlerImpl implements MqttMessageHandler {

    public MqttaddrHandlerImpl(MqttClient mqttClient, MqttMsgLogDao mqttMsgLogDao) {
        super("mqttaddr", mqttClient, mqttMsgLogDao, false);
    }

    @Override
    public MsgHandleResponse handleUpMessage(ChargeDeviceProps chargeDeviceProps, MqttMessage mqttMessage) {
        // 设备到服务器：<deviceId>#mqttaddr#<result>#<initip>#<initport>#<inittopic>
        // <initip>为初始交互时MQTT服务器IP；
        // <initport>为初始交互时MQTT服务器端口；
        // <inittopic>为初始使用充电桩设备到主站publish的Topic；

        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start handleUpMessage >>>>>> ");
        }

        MsgHandleResponse res = new MsgHandleResponse();
        res.setStatus(-1);
        res.setMsg("处理上行（设备到服务器）消息失败 <<< 设置通讯参数");

        if(chargeDeviceProps != null && StringUtils.isNotBlank(chargeDeviceProps.getDeviceId())) {
            String deviceId = chargeDeviceProps.getDeviceId();

            res.setStatus(0);
            res.setMsg("处理上行（设备到服务器）消息成功 <<< 设置通讯参数");

            if(needRespond && res.getStatus() == 0) {
                res = handleDownMessage(chargeDeviceProps);
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" <<<<<<< end handleUpMessage <<<<<<< ");
        }
        return res;
    }

    @Override
    public MsgHandleResponse handleDownMessage(ChargeDeviceProps chargeDeviceProps) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start handleDownMessage >>>>>> ");
        }
        MsgHandleResponse res = new MsgHandleResponse();
        res.setStatus(0);
        res.setMsg("处理下行（服务器到设备）消息成功 >>> 设置通讯参数");
        if(logger.isDebugEnabled()) {
            logger.debug(" <<<<<<< end handleDownMessage <<<<<<< ");
        }
        return res;
    }

}
