package cn.yunrui.mqttclient.ebikesrv.mqttclient.handler.impl;

import cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.MqttMsgLogDao;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargeDeviceProps;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.MsgHandleResponse;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.handler.MqttMessageHandler;
import cn.yunrui.mqttclient.ebikesrv.common.utils.JsonConvertUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.ObjectUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttMessage;

/**
 * 设备参数查询请求
 *
 * @author Nick Zhang
 * @date 2019-03-26
 *
 */
public class ParamHandlerImpl extends MqttMessageHandlerImpl implements MqttMessageHandler {

    public ParamHandlerImpl(MqttClient mqttClient, MqttMsgLogDao mqttMsgLogDao) {
        super("param", mqttClient, mqttMsgLogDao, true);
    }

    @Override
    public MsgHandleResponse handleUpMessage(ChargeDeviceProps chargeDeviceProps, MqttMessage mqttMessage) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start handleUpMessage >>>>>> ");
            logger.debug(" chargeDeviceProps : " + JsonConvertUtils.convertToString(chargeDeviceProps));
        }

        MsgHandleResponse res = new MsgHandleResponse();
        res.setStatus(-1);
        res.setMsg("处理上行（设备到服务器）消息失败 <<< 设备参数查询请求");

        if(chargeDeviceProps != null && StringUtils.isNotBlank(chargeDeviceProps.getDeviceId())) {
            res.setStatus(0);
            res.setMsg("处理上行（设备到服务器）消息成功 <<< 设备参数查询请求");

            // 设备上电时，重新加载缓存
            chargeDeviceProps = chargeDeviceCache.reload(chargeDeviceProps.getDeviceId());

            if(needRespond && res.getStatus() == 0) {
                res = handleDownMessage(chargeDeviceProps);
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" <<<<<<< end handleUpMessage <<<<<<< ");
        }
        return res;
    }

    @Override
    protected MsgHandleResponse handleDownMessage(ChargeDeviceProps chargeDeviceProps) {
        // 服务器到设备[MQTT_YJM2M_201710]：param#<maxPlugPower>#<maxDevicePower>#<cardPassword>#<factor>#<remain1>#<remain2>#<remain3>#…
        // 服务器到设备[MQTT_YJM2M_201712] / [MQTT_YJM2M_201801] / [MQTT_YJM2M_201804]：param#<maxPlugPower>#<maxDevicePower>#<cardPassword>#<factor>#<remain1>,<time1>#<remain2>,<time2>#<remain3>,<time3>#…
        // 服务器到设备[MQTT_EBIKE_201804]：param#<maxPlugPower>#<maxDevicePower>#<factor>#<remain1>,<time1>#<remain2>,<time2>#<remain3>,<time3>#…
        // <maxPlugPower>
        // <maxDevicePower>
        // <cardPassword>
        // <factor>表示设备中电表的校准系数，1000表示单位校准系数
        // <remain1>
        // <time1>
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start handleDownMessage >>>>>> ");
        }

        MsgHandleResponse res = new MsgHandleResponse();
        res.setStatus(-1);
        res.setMsg("处理下行（服务器到设备）消息失败 >>> 设备参数查询请求");
        if(ObjectUtils.isNotNull(chargeDeviceProps) && StringUtils.isNotBlank(chargeDeviceProps.getDeviceId())) {
            boolean bp = response2device(chargeDeviceProps.getDeviceId(), makeupParamDownMsg(chargeDeviceProps), opType);
            if(bp) {
                res.setStatus(0);
                res.setMsg("处理下行（服务器到设备）消息成功 >>> 设备参数查询请求");
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" <<<<<<< end handleDownMessage <<<<<<< ");
        }
        return res;
    }

}
