package cn.yunrui.mqttclient.ebikesrv.mqttclient.handler.impl;

import cn.yunrui.mqttclient.ebikesrv.common.utils.JsonConvertUtils;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.constant.ChargeOpenFlag;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.MqttMsgLogDao;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargeDeviceProps;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.MsgHandleResponse;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.handler.MqttMessageHandler;
import cn.yunrui.mqttclient.ebikesrv.common.utils.MapUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.ObjectUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import com.google.common.collect.Maps;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttMessage;

import java.util.*;

/**
 * 开始充电命令
 *
 * @author Nick Zhang
 * @date 2019-03-26
 *
 */
public class StartHandlerImpl extends MqttMessageHandlerImpl implements MqttMessageHandler {

    public StartHandlerImpl(MqttClient mqttClient, MqttMsgLogDao mqttMsgLogDao) {
        super("start", mqttClient, mqttMsgLogDao, false);
    }

    @Override
    public MsgHandleResponse handleUpMessage(ChargeDeviceProps chargeDeviceProps, MqttMessage mqttMessage) {
        // 设备到服务器：<deviceId>#start#<plugId>#<result>
        // <result>为0表示开启充电成功，<result>为负数表示开启充电失败，-1表示设备总体已经超过最大功率，-2表示被投币操作占用
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start handleUpMessage >>>>>> ");
        }

        MsgHandleResponse res = new MsgHandleResponse();
        res.setStatus(-1);
        res.setMsg("处理上行（设备到服务器）消息失败 <<< 开始充电命令");

        if(chargeDeviceProps != null && StringUtils.isNotBlank(chargeDeviceProps.getDeviceId())) {
            String deviceId = chargeDeviceProps.getDeviceId();
            String rcvdMsg = new String(mqttMessage.getPayload());
            String[] rcvdMsgArray = rcvdMsg.split("#");
            String plugId = null;
            // 为0表示开启充电成功；为负数表示开启充电失败，-1表示设备总体已经超过最大功率，-99表示等待返回超时
            String result = null;
            if(rcvdMsgArray.length >= 4) {
                plugId = rcvdMsgArray[2];
                result = rcvdMsgArray[3];
            }

            if(StringUtils.isNotBlank(plugId)) {
                Map<String, Object> chargeRecordMap = chargeRecordCache.getChargeRecordMap(deviceId, plugId);
                if(logger.isDebugEnabled()) {
                    logger.debug(" deviceId             : " + deviceId);
                    logger.debug(" plugId               : " + plugId);
                    logger.debug(" result               : " + result);
                    logger.debug(" chargeRecordMap      : " + JsonConvertUtils.convertToString(chargeRecordMap));
                }
                // 该插座有当前充电记录
                if(MapUtils.isNotEmpty(chargeRecordMap)) {
                    Integer chargeOpenFlag = (Integer) ObjectUtils.defaultIfNull(chargeRecordMap.get("chargeOpenFlag"), ChargeOpenFlag.FLAG_SUCCESS);
                    // 充电开启等待中
                    if(chargeOpenFlag == ChargeOpenFlag.FLAG_WAITING) {
                        if(StringUtils.equals("0", result)) {
                            // 开启充电成功
                            // 判断是否是一拖二设备刷卡，并进行语音提示
                            if(StringUtils.equals(chargeDeviceProps.getFactory(), "gaea") && StringUtils.equals(chargeDeviceProps.getModelNo(), "002")) {
                                String schemeType = (String) chargeRecordMap.get("schemeType");
                                if(StringUtils.equals(schemeType, "03")) {
                                    // 计次
                                    String voiceId = "3";
                                    String msg2Device = "voice" + "#" + voiceId;
                                    response2device(deviceId, msg2Device, "voice");
                                }
                                else if(StringUtils.equals(schemeType, "01")) {
                                    // 计时间
                                    String voiceId = "4";
                                    String msg2Device = "voice" + "#" + voiceId + "#" + ((Double) chargeRecordMap.get("chargeAmount")).intValue();
                                    response2device(deviceId, msg2Device, "voice");
                                }
                            }
                            else if(StringUtils.equals(chargeDeviceProps.getFactory(), "gaea") && StringUtils.equals(chargeDeviceProps.getModelNo(), "003")) {
                                String schemeType = (String) chargeRecordMap.get("schemeType");
                                if(StringUtils.equals(schemeType, "03")) {
                                    // 计次
                                    String voiceId = "10";
                                    String msg2Device = "voice" + "#" + voiceId + "#" + plugId;
                                    response2device(deviceId, msg2Device, "voice");
                                }
                                else if(StringUtils.equals(schemeType, "01")) {
                                    // 计时间
                                    String voiceId = "11";
                                    String msg2Device = "voice" + "#" + voiceId + "#" + plugId + "#" + ((Double) chargeRecordMap.get("chargeAmount")).intValue();
                                    response2device(deviceId, msg2Device, "voice");
                                }
                            }
                            // 当前充电记录更新
                            Map<String, Object> valueMap = Maps.newHashMap();
                            valueMap.put("chargeOpenFlag", Integer.valueOf(result));
                            valueMap.put("chargeOpenTime", new Date());
                            chargeRecordCache.updateChargeRecord(deviceId, plugId, valueMap);
                            chargeOrderEventPublisher.publishEvent("open", chargeRecordCache.getBeChargingRecord((String) chargeRecordMap.get("chargeRecordId")));
                        }
                        else {
                            // 开启充电失败，-1表示设备总体已经超过最大功率，-99表示等待返回超时，...
                            // 当前充电记录更新
                            Map<String, Object> valueMap = Maps.newHashMap();
                            valueMap.put("chargeOpenFlag", Integer.valueOf(result));
                            valueMap.put("chargeOpenTime", new Date());
                            chargeRecordCache.updateChargeRecord(deviceId, plugId, valueMap);
                            // 结束充电记录
                            Map<String, Object> finishValueMap = new HashMap<>();
                            finishValueMap.put("finishReason", result);
                            chargeRecordCache.finishChargeRecord(deviceId, plugId, finishValueMap);
                            // 充电设备状态更新
                            if(StringUtils.equals("1", chargeDeviceProps.getOpStatus())) {
                                // 当设备状态为在线时，插座状态置为 0 - 空闲
                                chargeDeviceCache.updatePlugStatus(deviceId, plugId, "0");
                            }
                            else {
                                // 当设备状态为离线时，插座状态置为 9 - 不可用（设备离线）
                                chargeDeviceCache.updatePlugStatus(deviceId, plugId, "9");
                            }
                            chargeOrderEventPublisher.publishEvent("finish", chargeRecordCache.getHistroyChargeRecord((String) chargeRecordMap.get("chargeRecordId")));
                        }
                    }
                }
                else {
                    // 该插座无当前充电记录，则判断是否在装接调试
                    if(fitconnDebuggingCache.checkIsDebugging(deviceId, plugId)) {
                        if(StringUtils.equals("0", result)) {
                            // 装接调试 - 开启充电成功
                            // 更新装接调试日志记录
                            Map<String, Object> valueMap = new HashMap<>();
                            valueMap.put("debugOpenTime", new Date());
                            fitconnDebuggingCache.updateFitconnDebuggingLog(deviceId, plugId, valueMap);
                        }
                        else {
                            // 装接调试 - 开启充电失败
                            // 结束装接调试日志记录
                            Map<String, Object> valueMap = new HashMap<>();
                            valueMap.put("debugOpenTime", new Date());
                            valueMap.put("debugFinishTime", new Date());
                            fitconnDebuggingCache.finishFitconnDebuggingLog(deviceId, plugId, valueMap);
                            // 充电设备状态更新
                            if(StringUtils.equals("1", chargeDeviceProps.getOpStatus())) {
                                // 当设备状态为在线时，插座状态置为 0 - 空闲
                                chargeDeviceCache.updatePlugStatus(deviceId, plugId, "0");
                            }
                            else {
                                // 当设备状态为离线时，插座状态置为 9 - 不可用（设备离线）
                                chargeDeviceCache.updatePlugStatus(deviceId, plugId, "9");
                            }
                        }
                    }
                }
            }

            res.setStatus(0);
            res.setMsg("处理上行（设备到服务器）消息成功 <<< 开始充电命令");

            if(needRespond && res.getStatus() == 0) {
                res = handleDownMessage(chargeDeviceProps);
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" <<<<<<< end handleUpMessage <<<<<<< ");
        }
        return res;
    }

    @Override
    public MsgHandleResponse handleDownMessage(ChargeDeviceProps chargeDeviceProps) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start handleDownMessage >>>>>> ");
        }
        MsgHandleResponse res = new MsgHandleResponse();
        res.setStatus(0);
        res.setMsg("处理下行（服务器到设备）消息成功 >>> 开始充电命令");
        if(logger.isDebugEnabled()) {
            logger.debug(" <<<<<<< end handleDownMessage <<<<<<< ");
        }
        return res;
    }

}
