package cn.yunrui.mqttclient.ebikesrv.mqttclient.handler.impl;

import cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.MqttMsgLogDao;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargeDeviceProps;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.MsgHandleResponse;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.handler.MqttMessageHandler;
import cn.yunrui.mqttclient.ebikesrv.common.utils.ObjectUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttMessage;

/**
 * 时间同步请求
 *
 * @author Nick Zhang
 * @date 2019-03-26
 *
 */
public class SynctimeHandlerImpl extends MqttMessageHandlerImpl implements MqttMessageHandler {

    public SynctimeHandlerImpl(MqttClient mqttClient, MqttMsgLogDao mqttMsgLogDao) {
        super("synctime", mqttClient, mqttMsgLogDao, true);
    }

    @Override
    public MsgHandleResponse handleUpMessage(ChargeDeviceProps chargeDeviceProps, MqttMessage mqttMessage) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start handleUpMessage >>>>>> ");
        }

        MsgHandleResponse res = new MsgHandleResponse();
        res.setStatus(-1);
        res.setMsg("处理上行（设备到服务器）消息失败 <<< 时间同步请求");

        if(chargeDeviceProps != null && StringUtils.isNotBlank(chargeDeviceProps.getDeviceId())) {
            res.setStatus(0);
            res.setMsg("处理上行（设备到服务器）消息成功 <<< 时间同步请求");

            if(needRespond && res.getStatus() == 0) {
                res = handleDownMessage(chargeDeviceProps);
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" <<<<<<< end handleUpMessage <<<<<<< ");
        }
        return res;
    }

    @Override
    protected MsgHandleResponse handleDownMessage(ChargeDeviceProps chargeDeviceProps) {
        // 服务器到设备：synctime#<time>
        // <time>为从1970年1月1日0点0分0秒开始计算的秒数；
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start handleDownMessage >>>>>> ");
        }

        MsgHandleResponse res = new MsgHandleResponse();
        res.setStatus(-1);
        res.setMsg("处理下行（服务器到设备）消息失败 >>> 时间同步请求");
        if(ObjectUtils.isNotNull(chargeDeviceProps) && StringUtils.isNotBlank(chargeDeviceProps.getDeviceId())) {
            boolean bp = response2device(chargeDeviceProps.getDeviceId(), makeupSynctimeDownMsg(chargeDeviceProps), opType);
            if(bp) {
                res.setStatus(0);
                res.setMsg("处理下行（服务器到设备）消息成功 >>> 设备附加参数查询请求");
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" <<<<<<< end handleDownMessage <<<<<<< ");
        }
        return res;
    }

}
