package cn.yunrui.mqttclient.ebikesrv.mqttclient.handler.impl;

import cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.MqttMsgLogDao;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargeDeviceProps;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.MsgHandleResponse;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.handler.MqttMessageHandler;
import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttMessage;

/**
 * 透明转发请求
 *
 * 主站到充电桩设备：
 * scan485#<baudrate>#<parity>#<letterlength>#letter
 * 充电桩设备到主站：
 * <deviceId>#scan485#<answerlength>#answer
 * 说明：
 * <baudrate>表示RS485口波特率，2400、4800、9600、19200
 * <parity>表示奇偶校验位：0-无 1-奇 2-偶
 * <letterlength>表示下行报文长度
 * <letter>表示RS485下行报文内容，HEX流
 * <answerlength>表示返回报文长度 0--超时无报文返回
 * <answer>表示RS485返回报文内容，HEX流
 * 缺省的超时时间为2秒
 *
 * @author Nick Zhang
 * @date 2019-03-26
 *
 */
public class TransHandlerImpl extends MqttMessageHandlerImpl implements MqttMessageHandler {

    public TransHandlerImpl(MqttClient mqttClient, MqttMsgLogDao mqttMsgLogDao) {
        super("trans", mqttClient, mqttMsgLogDao, false);
    }

    @Override
    public MsgHandleResponse handleUpMessage(ChargeDeviceProps chargeDeviceProps, MqttMessage mqttMessage) {
        // 设备到服务器：<deviceId>#trans#<result>#<transcontent>
        // <transcontent>为透明转发内容；
        // <result>为0表示返回成功，<result>为负数表示返回失败
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start handleUpMessage >>>>>> ");
        }

        MsgHandleResponse res = new MsgHandleResponse();
        res.setStatus(-1);
        res.setMsg("处理上行（设备到服务器）消息失败 <<< 透明转发请求");

        if(chargeDeviceProps != null && StringUtils.isNotBlank(chargeDeviceProps.getDeviceId())) {
            String deviceId = chargeDeviceProps.getDeviceId();

            res.setStatus(0);
            res.setMsg("处理上行（设备到服务器）消息成功 <<< 透明转发请求");

            if(needRespond && res.getStatus() == 0) {
                res = handleDownMessage(chargeDeviceProps);
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" <<<<<<< end handleUpMessage <<<<<<< ");
        }
        return res;
    }

    @Override
    public MsgHandleResponse handleDownMessage(ChargeDeviceProps chargeDeviceProps) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start handleDownMessage >>>>>> ");
        }
        MsgHandleResponse res = new MsgHandleResponse();
        res.setStatus(0);
        res.setMsg("处理下行（服务器到设备）消息成功 >>> 透明转发请求");
        if(logger.isDebugEnabled()) {
            logger.debug(" <<<<<<< end handleDownMessage <<<<<<< ");
        }
        return res;
    }

}
