package cn.yunrui.mqttclient.ebikesrv.mqttclient.handler.impl;

import cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.MqttMsgLogDao;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargeDeviceProps;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.MsgHandleResponse;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.handler.MqttMessageHandler;
import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttMessage;

/**
 * 远程升级
 * 主站到充电桩设备：
 * upgrade#<index>#<content>
 * 充电桩设备到主站：
 * <deviceId>#upgrade#<index>#<result>
 * 说明：
 * <index>表示升级程序序号，从1开始；
 * <content>表示升级程序内容；
 * <result>为0表示该升级程序处理成功，为负表示不成功，需要重传；
 *
 * 2018-08-27添加
 * <content>内容说明
 * 报文类型1：下载程序
 * 数据项	符号	字节长度	说明
 * 报文类型	TYPE	1	0xB（下载程序）
 * 报文长度	LEN	2	4+N(低字节在前,高字节在后)
 * 程序地址	ADR	4	写入程序的地址(低字节在前,高字节在后)
 * 程序代码	CODE	N	待写入的程序代码，一次不超过512字节
 * 报文类型2：启动升级
 * 数据项	符号	字节长度	说明
 * 报文类型	TYPE	1	0xC（启动升级）
 * 报文长度	LEN	2	4(低字节在前,高字节在后)
 * 程序校验和	CHKSUM	4	所有代码按字节取反后相加的算术和(低字节在前,高字节在后)
 *
 * @author Nick Zhang
 * @date 2019-03-26
 *
 */
public class UpgradeHandlerImpl extends MqttMessageHandlerImpl implements MqttMessageHandler {

    public UpgradeHandlerImpl(MqttClient mqttClient, MqttMsgLogDao mqttMsgLogDao) {
        super("upgrade", mqttClient, mqttMsgLogDao, false);
    }

    @Override
    public MsgHandleResponse handleUpMessage(ChargeDeviceProps chargeDeviceProps, MqttMessage mqttMessage) {
        // 设备到服务器：<deviceId>#upgrade#<index>#<result>
        // <result>为0表示该升级程序处理成功，为负表示不成功，需要重传；
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start handleUpMessage >>>>>> ");
        }

        MsgHandleResponse res = new MsgHandleResponse();
        res.setStatus(-1);
        res.setMsg("处理上行（设备到服务器）消息失败 <<< 开始远程升级");

        if(chargeDeviceProps != null && StringUtils.isNotBlank(chargeDeviceProps.getDeviceId())) {
            String deviceId = chargeDeviceProps.getDeviceId();

            res.setStatus(0);
            res.setMsg("处理上行（设备到服务器）消息成功 <<< 开始远程升级");

            if(needRespond && res.getStatus() == 0) {
                res = handleDownMessage(chargeDeviceProps);
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" <<<<<<< end handleUpMessage <<<<<<< ");
        }
        return res;
    }

    @Override
    public MsgHandleResponse handleDownMessage(ChargeDeviceProps chargeDeviceProps) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start handleDownMessage >>>>>> ");
        }
        MsgHandleResponse res = new MsgHandleResponse();
        res.setStatus(0);
        res.setMsg("处理下行（服务器到设备）消息成功 >>> 开始远程升级");
        if(logger.isDebugEnabled()) {
            logger.debug(" <<<<<<< end handleDownMessage <<<<<<< ");
        }
        return res;
    }

}
