package cn.yunrui.mqttclient.ebikesrv.mqttclient.handler.impl;

import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.MqttMsgLogDao;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargeDeviceProps;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.MsgHandleResponse;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.handler.MqttMessageHandler;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttMessage;

/**
 * 语音播报（一托二设备）
 *
 * 主站到充电桩设备：
 * voice#<voiceId>#<voiceParam_1>…#<voiceParam_n>
 * 充电桩设备到主站：
 * <deviceId>#voice#<voiceId>#<result>
 * 说明：
 * <voiceId>为语音模板，详见下表
 * <voiceParam_1>…#<voiceParam_n>为所需带的参数项，详见下表备注
 * <result>为0表示语音播报成功，<result>为负数表示语音播报失败，-1表示语音模块已损坏；
 *
 * voiceId	语音内容	                                        备注	            适用场景
 * 1	    该卡未绑定，请在微信小程序绑定充电卡后再刷卡。		                    刷卡充电
 * 2	    该充电桩插座已满，请选择附近其他充电桩。		                        刷卡充电
 * 3	    请插入闪烁指示灯指向的插座，开始充电，充满为止。		                刷卡充电 / 扫码充电
 * 4	    请插入闪烁指示灯指向的插座，开始充电，充电时间xxx分钟。	需要带1个参数	    刷卡充电 / 扫码充电
 * 5	    在原插座增加xxx分钟充电时间，剩余yyy分钟充电时间。	    需要带2个参数	    刷卡充电 / 扫码充电
 * 6	    该卡无效。		                                                刷卡充电
 * 7	    该卡余额不足，请充值。		                                        刷卡充电
 *
 * @author Nick Zhang
 * @date 2019-03-26
 *
 */
public class VoiceHandlerImpl extends MqttMessageHandlerImpl implements MqttMessageHandler {

    public VoiceHandlerImpl(MqttClient mqttClient, MqttMsgLogDao mqttMsgLogDao) {
        super("voice", mqttClient, mqttMsgLogDao, false);
    }

    @Override
    public MsgHandleResponse handleUpMessage(ChargeDeviceProps chargeDeviceProps, MqttMessage mqttMessage) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start handleUpMessage >>>>>> ");
        }

        MsgHandleResponse res = new MsgHandleResponse();
        res.setStatus(-1);
        res.setMsg("处理上行（设备到服务器）消息失败 <<< 语音播报（一托二设备）");

        if(chargeDeviceProps != null && StringUtils.isNotBlank(chargeDeviceProps.getDeviceId())) {
            res.setStatus(0);
            res.setMsg("处理上行（设备到服务器）消息成功 <<< 语音播报（一托二设备）");

            if(needRespond && res.getStatus() == 0) {
                res = handleDownMessage(chargeDeviceProps);
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" <<<<<<< end handleUpMessage <<<<<<< ");
        }
        return res;
    }

    @Override
    public MsgHandleResponse handleDownMessage(ChargeDeviceProps chargeDeviceProps) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start handleDownMessage >>>>>> ");
        }
        MsgHandleResponse res = new MsgHandleResponse();
        res.setStatus(0);
        res.setMsg("处理下行（服务器到设备）消息成功 >>> 语音播报（一托二设备）");
        if(logger.isDebugEnabled()) {
            logger.debug(" <<<<<<< end handleDownMessage <<<<<<< ");
        }
        return res;
    }

}
