package cn.yunrui.mqttclient.ebikesrv.mqttclient.service;

import java.io.Serializable;

/**
 *
 */
public interface EBikeChargeProfile extends Serializable {

    /**
     * 获取MQTT Broker主机Ip地址
     * @return MQTT Broker主机Ip地址
     */
    String getBrokerHostIp();

    /**
     * 获取MQTT Broker主机端口
     * @return MQTT Broker主机端口
     */
    String getBrokerHostPort();

    /**
     * 获取MQTT Broker用户名
     * @return MQTT Broker用户名
     */
    String getBrokerUsername();

    /**
     * 获取MQTT Broker密码
     * @return MQTT Broker密码
     */
    String getBrokerPassword();

    /**
     * 获取服务Client ID
     * @return 服务Client ID
     */
    String getServerClientId();

    /**
     * 获取服务订阅主题
     * @return 服务订阅主题
     */
    String getServerSubTopic();

}
