package cn.yunrui.mqttclient.ebikesrv.mqttclient.service;

/**
 * 电动自行车充电主服务（MQTT消息处理）
 */
public interface EBikeChargeService {

    /**
     * 通过发布消息至设备
     * @param deviceId
     *              设备通讯标识（MQTT规约中定义的deviceId）
     * @param payload
     *              消息内容
     * @param type
     *              消息类型：start - 开始充电命令；stop - 结束充电命令；status - 设备状态；param - 设备参数；cardBalance - 卡片余额；cardCharge - 卡充电命令；attachParam - 设备附加参数；
     * @return 发送标志 true 表示发送成功；false 标识发送失败
     */
    boolean publish2device(String deviceId, byte[] payload, String type);

    /**
     * 通过发布消息至设备
     * @param deviceId
     *              设备通讯标识（MQTT规约中定义的deviceId）
     * @param message
     *              消息内容
     * @param type
     *              消息类型：start - 开始充电命令；stop - 结束充电命令；status - 设备状态；param - 设备参数；cardBalance - 卡片余额；cardCharge - 卡充电命令；attachParam - 设备附加参数；
     * @return 发送标志 true 表示发送成功；false 标识发送失败
     */
    boolean publish2device(String deviceId, String message, String type);

    /**
     * 结束充电订单
     * @param deviceId
     *              设备通讯标识（MQTT规约中定义的deviceId）
     * @param plugId
     *              插座通讯标识（MQTT规约中定义的plugId）
     * @param openFlag
     *              开启标记
     * @param reason
     *              结束原因
     */
    void finishChargeRecord(String deviceId, String plugId, int openFlag, int reason);

    /**
     * 结束装接调试
     * @param deviceId
     *              设备通讯标识（MQTT规约中定义的deviceId）
     * @param plugId
     *              插座通讯标识（MQTT规约中定义的plugId）
     */
    void finishFitconnDebugging(String deviceId, String plugId);

}
