package cn.yunrui.mqttclient.ebikesrv.syncevent.publisher;

import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargeRecord;

import java.util.Map;

public interface ChargeOrderEventPublisher {

    /**
     * 发布事件消息
     * @param eventContent
     *              事件内容
     *                  [type]              : 事件类型：open - 充电开启；finish - 充电结束；return - 退款；
     *                  [chargeRecordId]    : 充电记录标识
     *                  [chargeUserId]      : 充电用户标识
     *                  [chargeUserNo]      : 充电用户编号：如为“微信用户“，则充电用户名为微信标识；
     *                  [chargeUserType]    : 充电用户类型：10 – 微信用户；
     *                  [chargeplugNo]      : 充电插座编号
     *                  [chargedeviceNo]    : 充电设备编号
     *                  [plugSn]            : 插座序号
     *                  [chargestationName] : 充电站名称
     *                  [chargestationAddr] : 充电站地址
     *                  [chargeTime]        : 充电时间
     *                  [chargeMoney]       : 充电金额
     *                  [chargeOpenTime]    : 充电开启时间
     *                  [chargeFinishTime]  : 充电结束时间
     *                  [chargeDuration]    : 充电时长，单位：分钟
     *                  [finishReason]      : 结束原因
     *                  [finishReasonDesc]  : 结束原因描述
     *                  [returnMoney]       : 退费金额
     *                  [returnTime]        : 退费时间
     *                  [returnDesc]        : 退费描述
     */
    void publishEvent(Map<String, Object> eventContent);

    /**
     * 发布事件消息（原智）
     * @param eventContent
     *              事件内容
     *                  [type]              : 事件类型：open - 充电开启；finish - 充电结束；return - 退款；
     *                  [chargeRecordId]    : 充电记录标识
     *                  [chargeUserId]      : 充电用户标识
     *                  [chargeUserNo]      : 充电用户编号：如为“微信用户“，则充电用户名为微信标识；
     *                  [chargeUserType]    : 充电用户类型：10 – 微信用户；
     *                  [chargeplugNo]      : 充电插座编号
     *                  [chargedeviceNo]    : 充电设备编号
     *                  [plugSn]            : 插座序号
     *                  [chargestationName] : 充电站名称
     *                  [chargestationAddr] : 充电站地址
     *                  [chargeTime]        : 充电时间
     *                  [chargeMoney]       : 充电金额
     *                  [chargeOpenTime]    : 充电开启时间
     *                  [chargeFinishTime]  : 充电结束时间
     *                  [chargeDuration]    : 充电时长，单位：分钟
     *                  [finishReason]      : 结束原因
     *                  [finishReasonDesc]  : 结束原因描述
     *                  [returnMoney]       : 退费金额
     *                  [returnTime]        : 退费时间
     *                  [returnDesc]        : 退费描述
     */
    void publishEventYz(Map<String, Object> eventContent);

    /**
     *
     * @param type
     *              事件类型：open - 充电开启；finish - 充电结束；return - 退款；
     * @param chargeRecord
     *              充电记录
     */
    void publishEvent(String type, ChargeRecord chargeRecord);

}
