package cn.yunrui.mqttclient.ebikesrv.syncevent.publisher.impl;

import cn.cc.cisp.message.Event;
import cn.cc.cisp.message.SyncEventType;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargeRecord;
import cn.yunrui.mqttclient.ebikesrv.common.utils.DateFormatUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.JsonConvertUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import cn.yunrui.mqttclient.ebikesrv.syncevent.publisher.ChargeOrderEventPublisher;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.Map;

/**
 *
 */
public class ChargeOrderEventPublisherImpl implements ChargeOrderEventPublisher {

    private final static String TOPIC = "SyncEventTopic";
    private final static String EVENT_TYPE = "CHARGERECORD_EVENT";                  // 数元公众号
    private final static String EVENT_TYPE_YZ = "CHARGERECORD_EVENT_YZ";            // 原智公众号
    private final static String PATTERN_DATETIME = "yyyy-MM-dd HH:mm:ss";

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Resource(name = "redisTemplate")
    private RedisTemplate redisTemplate;

    @Override
    public void publishEvent(Map<String, Object> eventContent) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start publishEvent >>>>>> ");
            logger.debug(" eventContent     : " + JsonConvertUtils.convertToString(eventContent));
        }
        redisTemplate.convertAndSend(TOPIC, new Event(SyncEventType.valueOfKey(EVENT_TYPE), JSONObject.fromObject(eventContent)));
    }

    @Override
    public void publishEventYz(Map<String, Object> eventContent) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start publishEventYz >>>>>> ");
            logger.debug(" eventContent     : " + JsonConvertUtils.convertToString(eventContent));
        }
        redisTemplate.convertAndSend(TOPIC, new Event(SyncEventType.valueOfKey(EVENT_TYPE_YZ), JSONObject.fromObject(eventContent)));
    }

    @Override
    public void publishEvent(String type, ChargeRecord chargeRecord) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start publishEvent >>>>>> ");
            logger.debug(" type             : " + type);
            logger.debug(" chargeRecord     : " + JsonConvertUtils.convertToString(chargeRecord));
        }
        if(chargeRecord != null) {
            publishEventYz(buildEventContent(type, chargeRecord));
        }
    }

    private Map<String, Object> buildEventContent(String type, ChargeRecord chargeRecord) {
        Map<String, Object> eventContent = new HashMap<>();
        eventContent.put("type", type);
        eventContent.put("chargeRecordId", chargeRecord.getChargeRecordId());
        eventContent.put("chargeUserId", chargeRecord.getChargeUserId());
        eventContent.put("chargeUserNo", chargeRecord.getChargeUserNo());
        eventContent.put("chargeUserType", chargeRecord.getChargeUserType());
        eventContent.put("chargeplugNo", chargeRecord.getChargedeviceNo() + String.format("%02d", chargeRecord.getPlugSn()));
        eventContent.put("chargedeviceNo", chargeRecord.getChargedeviceNo());
        eventContent.put("plugSn", chargeRecord.getPlugSn());
        eventContent.put("chargestationName", chargeRecord.getChargestationName());
        eventContent.put("chargestationAddr", chargeRecord.getChargestationAddr());
        eventContent.put("chargeTime", DateFormatUtils.format(chargeRecord.getChargeTime(), PATTERN_DATETIME));
        eventContent.put("chargeMoney", chargeRecord.getChargeMoney());
        if(chargeRecord.getChargeOpenTime() != null) {
            eventContent.put("chargeOpenTime", DateFormatUtils.format(chargeRecord.getChargeOpenTime(), PATTERN_DATETIME));
        }
        else {
            if(StringUtils.equals(type, "finish")) {
                eventContent.put("chargeOpenTime", DateFormatUtils.format(chargeRecord.getChargeFinishTime(), PATTERN_DATETIME));
            }
        }
        if(StringUtils.equals(type, "finish") || StringUtils.equals(type, "return")) {
            eventContent.put("chargeDuration", Math.round((chargeRecord.getChargeFinishTime().getTime() - chargeRecord.getChargeOpenTime().getTime()) / 60000.0D));
            eventContent.put("chargeFinishTime", DateFormatUtils.format(chargeRecord.getChargeFinishTime(), PATTERN_DATETIME));
            eventContent.put("finishReason", chargeRecord.getFinishReason());
            if(StringUtils.equals(chargeRecord.getFinishReason(), "0")) {
                eventContent.put("finishReasonDesc", "电量用完");
            }
            else if(StringUtils.equals(chargeRecord.getFinishReason(), "1")) {
                eventContent.put("finishReasonDesc", "浮充时间完成");
            }
            else if(StringUtils.equals(chargeRecord.getFinishReason(), "2")) {
                eventContent.put("finishReasonDesc", "插头拔掉或充电充满");
            }
            else if(StringUtils.equals(chargeRecord.getFinishReason(), "3")) {
                eventContent.put("finishReasonDesc", "功率超限");
            }
            else if(StringUtils.equals(chargeRecord.getFinishReason(), "4")) {
                eventContent.put("finishReasonDesc", "计时时间到");
            }
            else if(StringUtils.equals(chargeRecord.getFinishReason(), "5")) {
                eventContent.put("finishReasonDesc", "插座端子失电");
            }
            else if(StringUtils.equals(chargeRecord.getFinishReason(), "-1")) {
                eventContent.put("finishReasonDesc", "设备总体功率超限");
            }
            else if(StringUtils.equals(chargeRecord.getFinishReason(), "-2")) {
                eventContent.put("finishReasonDesc", "插座投币占用");
            }
            else if(StringUtils.equals(chargeRecord.getFinishReason(), "-97")) {
                eventContent.put("finishReasonDesc", "电量用完或计时时间到");
            }
            else if(StringUtils.equals(chargeRecord.getFinishReason(), "-98")) {
                eventContent.put("finishReasonDesc", "充电结束超时");
            }
            else if(StringUtils.equals(chargeRecord.getFinishReason(), "-99")) {
                eventContent.put("finishReasonDesc", "充电开启超时");
            }
        }
        if(StringUtils.equals(type, "return")) {
            eventContent.put("returnMoney", chargeRecord.getReturnMoney());
            eventContent.put("returnTime", DateFormatUtils.format(chargeRecord.getReturnTime(), PATTERN_DATETIME));
            eventContent.put("returnDesc", chargeRecord.getReturnDesc());
        }
        return eventContent;
    }

}
