package cn.yunrui.mqttclient.ebikesrv.tablestore;

import com.alicloud.openservices.tablestore.AsyncClient;
import com.alicloud.openservices.tablestore.SyncClient;
import com.alicloud.openservices.tablestore.model.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableStoreTemplate implements TableStoreOperations {

    private final Logger logger = LoggerFactory.getLogger(getClass());
    private final SyncClient syncClient;                                // 同步
    private final AsyncClient asyncClient;                              // 异步
    private final TableStoreSource tablestoreSource;

    public TableStoreTemplate(TableStoreSource tablestoreSource) {
        this.syncClient = new SyncClient(tablestoreSource.getEndPoint(), tablestoreSource.getAccessKeyId(), tablestoreSource.getAccessKeySecret(), tablestoreSource.getInstanceName(), tablestoreSource.getClientConfiguration());
        this.asyncClient = new AsyncClient(tablestoreSource.getEndPoint(), tablestoreSource.getAccessKeyId(), tablestoreSource.getAccessKeySecret(), tablestoreSource.getInstanceName(), tablestoreSource.getClientConfiguration());
        this.tablestoreSource = tablestoreSource;
    }

    public SyncClient getSyncClient() {
        return syncClient;
    }

    public AsyncClient getAsyncClient() {
        return asyncClient;
    }

    public TableStoreSource getTablestoreSource() {
        return tablestoreSource;
    }

    @Override
    public PutRowResponse putRowSync(PutRowRequest putRowRequest) {
        return this.syncClient.putRow(putRowRequest);
    }

    @Override
    public GetRowResponse getRowSync(GetRowRequest getRowRequest) {
        return this.syncClient.getRow(getRowRequest);
    }

    @Override
    public UpdateRowResponse updateRowSync(UpdateRowRequest updateRowRequest) {
        return this.syncClient.updateRow(updateRowRequest);
    }

    @Override
    public DeleteRowResponse deleteRowSync(DeleteRowRequest deleteRowRequest) {
        return this.syncClient.deleteRow(deleteRowRequest);
    }

    @Override
    public BatchGetRowResponse batchGetRowSync(BatchGetRowRequest batchGetRowRequest) {
        return this.syncClient.batchGetRow(batchGetRowRequest);
    }

    @Override
    public BatchWriteRowResponse batchWriteRowSync(BatchWriteRowRequest batchWriteRowRequest) {
        return this.syncClient.batchWriteRow(batchWriteRowRequest);
    }

    @Override
    public GetRangeResponse getRangeSync(GetRangeRequest getRangeRequest) {
        return this.syncClient.getRange(getRangeRequest);
    }

}
