/*
 * Decompiled with CFR 0.152.
 */
package cn.yunrui.mqttclient.ebikesrv.common.utils;

import java.text.ParseException;
import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils
extends org.apache.commons.lang3.time.DateUtils {
    private static final Logger logger = LoggerFactory.getLogger(DateUtils.class);
    public static final String[] PATTERNS_DATE = new String[]{"yyyy-MM-dd", "yyyy/MM/dd", "yyyyMMdd"};
    public static final String[] PATTERNS_MONTH = new String[]{"yyyy-MM", "yyyy/MM", "yyyyMM"};
    public static final String[] PATTERNS_YEAR = new String[]{"yyyy"};
    public static final String PATTERN_DATE = "yyyyMMdd";
    public static final String PATTERN_MONTH = "yyyyMM";
    public static final String PATTERN_YEAR = "yyyy";

    public static boolean isToday(String date) {
        try {
            return DateUtils.isSameDay((Date)DateUtils.parseDate((String)date, (String[])PATTERNS_DATE), (Date)new Date());
        }
        catch (ParseException _pe) {
            logger.error(_pe.getMessage(), _pe.fillInStackTrace());
            return false;
        }
    }

    public static Date getYesterday() {
        return DateUtils.addDays(new Date(), -1);
    }

    public static String convertToString(Date date, String pattern) {
        return new DateTime((Object)date).toString(pattern);
    }

    public static Date convertFromString(String str, String pattern) {
        Date date = null;
        try {
            date = DateTime.parse((String)str, (DateTimeFormatter)DateTimeFormat.forPattern((String)pattern)).toDate();
        }
        catch (Exception _e) {
            date = null;
        }
        return date;
    }

    public static Date convertFromString(String str, String[] patterns) {
        if (patterns != null) {
            for (String pattern : patterns) {
                Date date = DateUtils.convertFromString(str, pattern);
                if (date == null) continue;
                return date;
            }
        }
        return null;
    }

    public static Date addYears(Date date, int years) {
        return new DateTime((Object)date).plusYears(years).toDate();
    }

    public static Date addMonths(Date date, int months) {
        return new DateTime((Object)date).plusMonths(months).toDate();
    }

    public static Date addWeeks(Date date, int weeks) {
        return new DateTime((Object)date).plusWeeks(weeks).toDate();
    }

    public static Date addDays(Date date, int days) {
        return new DateTime((Object)date).plusDays(days).toDate();
    }

    public static Date addHours(Date date, int hours) {
        return new DateTime((Object)date).plusHours(hours).toDate();
    }

    public static Date addMinutes(Date date, int minutes) {
        return new DateTime((Object)date).plusMinutes(minutes).toDate();
    }

    public static Date addSeconds(Date date, int seconds) {
        return new DateTime((Object)date).plusSeconds(seconds).toDate();
    }

    public static Date addMillis(Date date, int millis) {
        return new DateTime((Object)date).plusMillis(millis).toDate();
    }

    public static boolean isSameYear(Date d1, Date d2) {
        return d1 != null && d2 != null && DateUtils.convertToString(d1, PATTERN_YEAR).equals(DateUtils.convertToString(d2, PATTERN_YEAR));
    }

    public static boolean isSameMonth(Date d1, Date d2) {
        return d1 != null && d2 != null && DateUtils.convertToString(d1, PATTERN_MONTH).equals(DateUtils.convertToString(d2, PATTERN_MONTH));
    }

    public static boolean isSameDate(Date d1, Date d2) {
        return d1 != null && d2 != null && DateUtils.convertToString(d1, PATTERN_DATE).equals(DateUtils.convertToString(d2, PATTERN_DATE));
    }
}

