/*
 * Decompiled with CFR 0.152.
 */
package cn.yunrui.mqttclient.ebikesrv.common.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonConvertUtils {
    private static final Logger logger = LoggerFactory.getLogger(JsonConvertUtils.class);

    public static String convertToString(Object object) {
        if (object == null) {
            return null;
        }
        try {
            return new ObjectMapper().writeValueAsString(object);
        }
        catch (JsonProcessingException _jpe) {
            logger.error(_jpe.getMessage(), _jpe.fillInStackTrace());
            return null;
        }
    }

    public static <T> T convertFromString(Class<T> valueType, String content) {
        if (valueType == null || content == null) {
            return null;
        }
        try {
            return (T)new ObjectMapper().readValue(content, valueType);
        }
        catch (IOException _ioe) {
            logger.error(_ioe.getMessage(), _ioe.fillInStackTrace());
            return null;
        }
    }
}

