/*
 * Decompiled with CFR 0.152.
 */
package cn.yunrui.mqttclient.ebikesrv.handletask;

import cn.yunrui.mqttclient.ebikesrv.common.utils.CollectionUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.JsonConvertUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.MapUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.WorkOrderIdUtils;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.cache.ChargeDeviceCache;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.cache.OpsWorkOrderCache;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargeDeviceOps;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargeDeviceProps;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargePlugProps;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.OpsWorkOrder;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChargeDeviceOfflineHandleTask {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ConcurrentLinkedQueue<ChargeDeviceOps> linkedQueue = new ConcurrentLinkedQueue();
    private static final int INTERVAL_WAIT = 60;
    private Thread chargeDeviceOfflineTimeoutScanThread;
    private Thread chargeDeviceOfflineTimeoutHandleThread;
    @Resource(name="chargeDeviceCache")
    private ChargeDeviceCache chargeDeviceCache;
    @Resource(name="opsWorkOrderCache")
    private OpsWorkOrderCache opsWorkOrderCache;

    @PostConstruct
    public void init() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start init ChargeDeviceOfflineHandleTask >>>>>> ");
        }
        this.chargeDeviceOfflineTimeoutScanThread = new ChargeDeviceOfflineTimeoutScanThread();
        this.chargeDeviceOfflineTimeoutScanThread.setDaemon(true);
        this.chargeDeviceOfflineTimeoutScanThread.start();
        this.chargeDeviceOfflineTimeoutHandleThread = new ChargeDeviceOfflineTimeoutHandleThread();
        this.chargeDeviceOfflineTimeoutHandleThread.setDaemon(true);
        this.chargeDeviceOfflineTimeoutHandleThread.start();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" <<<<<<< end init ChargeDeviceOfflineHandleTask <<<<<<< ");
        }
    }

    @PreDestroy
    public void destroy() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start destroy ChargeDeviceOfflineHandleTask >>>>>> ");
        }
        if (this.chargeDeviceOfflineTimeoutScanThread != null) {
            try {
                this.chargeDeviceOfflineTimeoutScanThread.join();
            }
            catch (InterruptedException _ie) {
                this.logger.error(_ie.getMessage(), _ie.fillInStackTrace());
            }
        }
        if (this.chargeDeviceOfflineTimeoutHandleThread != null) {
            try {
                this.chargeDeviceOfflineTimeoutHandleThread.join();
            }
            catch (InterruptedException _ie) {
                this.logger.error(_ie.getMessage(), _ie.fillInStackTrace());
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" <<<<<<< end destroy ChargeDeviceOfflineHandleTask <<<<<<< ");
        }
    }

    private List<ChargeDeviceOps> getTimeoutChargeDeviceOpsList() {
        List<ChargeDeviceOps> cdoList = this.chargeDeviceCache.getTimeoutChargeDeviceOpsList();
        if (CollectionUtils.sizeIsNotEmptyIgnoreNull(cdoList)) {
            this.chargeDeviceCache.lockTimeoutChargeDeviceOpsList(cdoList);
        }
        return cdoList;
    }

    private class ChargeDeviceOfflineTimeoutHandleThread
    extends Thread {
        private ChargeDeviceOfflineTimeoutHandleThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                block4: while (true) {
                    ChargeDeviceOps chargeDeviceOps;
                    if ((chargeDeviceOps = (ChargeDeviceOps)ChargeDeviceOfflineHandleTask.this.linkedQueue.poll()) == null) {
                        ConcurrentLinkedQueue concurrentLinkedQueue = ChargeDeviceOfflineHandleTask.this.linkedQueue;
                        synchronized (concurrentLinkedQueue) {
                            ChargeDeviceOfflineHandleTask.this.linkedQueue.wait(100L);
                            continue;
                        }
                    }
                    if (ChargeDeviceOfflineHandleTask.this.logger.isInfoEnabled()) {
                        ChargeDeviceOfflineHandleTask.this.logger.info(" charge device offline timeout handle : " + JsonConvertUtils.convertToString(chargeDeviceOps));
                    }
                    if (!StringUtils.isNotBlank((CharSequence)chargeDeviceOps.getDeviceId()) || chargeDeviceOps.getPlugCount() == null || chargeDeviceOps.getPlugCount() <= 0) continue;
                    Object[] plugStatus = new String[chargeDeviceOps.getPlugCount().intValue()];
                    Arrays.fill(plugStatus, "9");
                    ChargeDeviceProps cdp = ChargeDeviceOfflineHandleTask.this.chargeDeviceCache.get(chargeDeviceOps.getDeviceId());
                    if (cdp != null && MapUtils.isNotEmpty(cdp.getPlugPropsMap())) {
                        for (int i = 0; i < cdp.getPlugPropsMap().size(); ++i) {
                            ChargePlugProps cpp = cdp.getPlugPropsMap().get(i + 1);
                            if (cpp == null || !StringUtils.isNotBlank((CharSequence)cpp.getOpStatus())) continue;
                            if (StringUtils.equals((CharSequence)"1", (CharSequence)cpp.getOpStatus())) {
                                plugStatus[i] = "1";
                                continue;
                            }
                            if (StringUtils.equals((CharSequence)"2", (CharSequence)cpp.getOpStatus())) {
                                plugStatus[i] = "2";
                                continue;
                            }
                            if (!StringUtils.equals((CharSequence)"8", (CharSequence)cpp.getOpStatus())) continue;
                            plugStatus[i] = "8";
                        }
                    }
                    ChargeDeviceOfflineHandleTask.this.chargeDeviceCache.updateOpStatus(chargeDeviceOps.getDeviceId(), "0", (String[])plugStatus);
                    Integer plugSn = 0;
                    List<OpsWorkOrder> opsWorkOrderList102 = ChargeDeviceOfflineHandleTask.this.opsWorkOrderCache.getOpsWorkOrderList(chargeDeviceOps.getDeviceId(), String.valueOf(plugSn), "102", "N");
                    if (!CollectionUtils.sizeIsEmptyIgnoreNull(opsWorkOrderList102)) continue;
                    List<OpsWorkOrder> opsWorkOrderList101 = ChargeDeviceOfflineHandleTask.this.opsWorkOrderCache.getOpsWorkOrderList(chargeDeviceOps.getDeviceId(), String.valueOf(plugSn), "101", "N");
                    if (CollectionUtils.sizeIsNotEmptyIgnoreNull(opsWorkOrderList101)) {
                        int index = 1;
                        Iterator<OpsWorkOrder> iterator = opsWorkOrderList101.iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block4;
                            OpsWorkOrder opsWorkOrder = iterator.next();
                            if (index > 1) {
                                opsWorkOrder.setRecoveryTime(new Date());
                                opsWorkOrder.setIsRecovery("Y");
                                ChargeDeviceOfflineHandleTask.this.opsWorkOrderCache.recoveryOpsWorkOrder(opsWorkOrder);
                            }
                            ++index;
                        }
                    }
                    OpsWorkOrder opsWorkOrder = new OpsWorkOrder();
                    opsWorkOrder.setOpsworkorderId(WorkOrderIdUtils.getNewOpsWorkOrderId(chargeDeviceOps.getChargedeviceNo(), "101"));
                    opsWorkOrder.setOpsworkorderType("101");
                    opsWorkOrder.setOpsworkorderStatus("10");
                    opsWorkOrder.setOpsObjectType("EBikeChargeDevice");
                    opsWorkOrder.setOpsObjectId(chargeDeviceOps.getChargedeviceId());
                    opsWorkOrder.setOpsworkorderDesc("\u8bbe\u5907\u79bb\u7ebf");
                    ChargeDeviceOfflineHandleTask.this.opsWorkOrderCache.createOpsWorkOrder(opsWorkOrder);
                }
            }
            catch (InterruptedException ie) {
                ChargeDeviceOfflineHandleTask.this.logger.error(ie.getMessage(), ie.fillInStackTrace());
                return;
            }
        }
    }

    private class ChargeDeviceOfflineTimeoutScanThread
    extends Thread {
        private ChargeDeviceOfflineTimeoutScanThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    List list;
                    while (CollectionUtils.sizeIsEmptyIgnoreNull(list = ChargeDeviceOfflineHandleTask.this.getTimeoutChargeDeviceOpsList())) {
                        TimeUnit.SECONDS.sleep(60L);
                    }
                    ConcurrentLinkedQueue concurrentLinkedQueue = ChargeDeviceOfflineHandleTask.this.linkedQueue;
                    synchronized (concurrentLinkedQueue) {
                        for (ChargeDeviceOps chargeDeviceOps : list) {
                            if (ChargeDeviceOfflineHandleTask.this.logger.isInfoEnabled()) {
                                ChargeDeviceOfflineHandleTask.this.logger.info(" charge device offline timeout scan   : " + JsonConvertUtils.convertToString(chargeDeviceOps));
                            }
                            ChargeDeviceOfflineHandleTask.this.linkedQueue.offer(chargeDeviceOps);
                        }
                        ChargeDeviceOfflineHandleTask.this.linkedQueue.notifyAll();
                    }
                }
                catch (InterruptedException ie) {
                    ChargeDeviceOfflineHandleTask.this.logger.error(ie.getMessage(), ie.fillInStackTrace());
                    return;
                }
            }
        }
    }
}

