/*
 * Decompiled with CFR 0.152.
 */
package cn.yunrui.mqttclient.ebikesrv.handletask;

import cn.yunrui.mqttclient.ebikesrv.common.utils.CollectionUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.DoubleUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.IntegerUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.JsonConvertUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.ObjectUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.ChargeRecordDao;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.ChargeRecordIncomeDetailDao;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.CsshDistschemeDao;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargeRecord;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargeRecordIncomeDetailInfo;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.CsshDistSchemeInfo;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.SchemeDetail;
import cn.yunrui.mqttclient.ebikesrv.syncevent.publisher.ChargeOrderEventPublisher;
import com.ebikepay.openservices.entity.OrderTypeEnum;
import com.ebikepay.openservices.entity.PayResultEnum;
import com.ebikepay.openservices.entity.PayTypeEnum;
import com.ebikepay.openservices.entity.RefundResultEnum;
import com.ebikepay.openservices.entity.ResponseResultEnum;
import com.ebikepay.openservices.entity.TradeOrderDo;
import com.ebikepay.openservices.entity.TradeOrderRefundDo;
import com.ebikepay.openservices.request.TradeOrderCreateRequest;
import com.ebikepay.openservices.request.TradeOrderPayRequest;
import com.ebikepay.openservices.request.TradeOrderRefundRequest;
import com.ebikepay.openservices.response.TradeOrderCreateResponse;
import com.ebikepay.openservices.response.TradeOrderPayResponse;
import com.ebikepay.openservices.response.TradeOrderRefundResponse;
import com.ebikepay.openservices.service.TradeOrderService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChargeRecordClosingHandleTask {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final long CHARGDURTIME_THRVAL1 = 600000L;
    private static final long CHARGDURTIME_THRVAL2 = 1800000L;
    private static final String EB_TRANSIT_USERTYPE = "ebike_transit";
    private static final String EB_TRANSIT_USERID = "10000000";
    private static final String EB_SERVICE_USERTYPE = "ebike_service";
    private static final String EB_SERVICE_USERID = "10000000";
    private static final int INTERVAL_WAIT = 1;
    private final ConcurrentLinkedQueue<ChargeRecord> closingLinkedQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<ChargeRecord> returnLinkedQueue = new ConcurrentLinkedQueue();
    private Thread closingHandleChargeRecordScanThread;
    private Thread closingChargeRecordHandleThread;
    private Thread returnHandleChargeRecordScanThread;
    private Thread returnChargeRecordHandleThread;
    @Resource(name="tradeOrderService")
    private TradeOrderService tradeOrderService;
    @Resource(name="chargeRecordDao")
    private ChargeRecordDao chargeRecordDao;
    @Resource(name="chargeRecordIncomeDetailDao")
    private ChargeRecordIncomeDetailDao chargeRecordIncomeDetailDao;
    @Resource(name="csshDistschemeDao")
    private CsshDistschemeDao csshDistschemeDao;
    @Resource(name="chargeOrderEventPublisher")
    private ChargeOrderEventPublisher chargeOrderEventPublisher;

    @PostConstruct
    public void init() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start init ChargeRecordClosingHandleTask >>>>>> ");
        }
        this.closingHandleChargeRecordScanThread = new ClosingHandleChargeRecordScanThread();
        this.closingHandleChargeRecordScanThread.setDaemon(true);
        this.closingHandleChargeRecordScanThread.start();
        this.closingChargeRecordHandleThread = new ClosingChargeRecordHandleThread();
        this.closingChargeRecordHandleThread.setDaemon(true);
        this.closingChargeRecordHandleThread.start();
        this.returnHandleChargeRecordScanThread = new ReturnHandleChargeRecordScanThread();
        this.returnHandleChargeRecordScanThread.setDaemon(true);
        this.returnHandleChargeRecordScanThread.start();
        this.returnChargeRecordHandleThread = new ReturnChargeRecordHandleThread();
        this.returnChargeRecordHandleThread.setDaemon(true);
        this.returnChargeRecordHandleThread.start();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" <<<<<<< end init ChargeRecordClosingHandleTask <<<<<<< ");
        }
    }

    @PreDestroy
    public void destroy() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start destroy ChargeRecordClosingHandleTask >>>>>> ");
        }
        if (this.closingHandleChargeRecordScanThread != null) {
            try {
                this.closingHandleChargeRecordScanThread.join();
            }
            catch (InterruptedException _ie) {
                this.logger.error(_ie.getMessage(), _ie.fillInStackTrace());
            }
        }
        if (this.closingChargeRecordHandleThread != null) {
            try {
                this.closingChargeRecordHandleThread.join();
            }
            catch (InterruptedException _ie) {
                this.logger.error(_ie.getMessage(), _ie.fillInStackTrace());
            }
        }
        if (this.returnHandleChargeRecordScanThread != null) {
            try {
                this.returnHandleChargeRecordScanThread.join();
            }
            catch (InterruptedException _ie) {
                this.logger.error(_ie.getMessage(), _ie.fillInStackTrace());
            }
        }
        if (this.returnChargeRecordHandleThread != null) {
            try {
                this.returnChargeRecordHandleThread.join();
            }
            catch (InterruptedException _ie) {
                this.logger.error(_ie.getMessage(), _ie.fillInStackTrace());
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" <<<<<<< end destroy ChargeRecordClosingHandleTask <<<<<<< ");
        }
    }

    private List<ChargeRecord> lockTobeClosingChargeRecordList() throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>>>>> start lockTobeClosingChargeRecordList >>>>>>>>>> ");
        }
        List<ChargeRecord> crList = this.chargeRecordDao.getNotClosingChargeRecordList();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" crList size : " + (crList != null ? crList.size() : 0));
            this.logger.debug(" crList      : " + JsonConvertUtils.convertToString(crList));
        }
        if (CollectionUtils.sizeIsNotEmptyIgnoreNull(crList)) {
            this.chargeRecordDao.lockNotClosingChargeRecordList(crList);
        }
        return crList;
    }

    private List<ChargeRecord> lockTobeReturnChargeRecordList() throws Exception {
        List<ChargeRecord> crList = this.chargeRecordDao.getNotReturnChargeRecordList();
        if (CollectionUtils.sizeIsNotEmptyIgnoreNull(crList)) {
            this.chargeRecordDao.lockNotReturnChargeRecordList(crList);
        }
        return crList;
    }

    private boolean isFullReturn(ChargeRecord chargeRecord) {
        boolean isFullReturn = false;
        if (ObjectUtils.isNotNull(chargeRecord)) {
            String finishReason = chargeRecord.getFinishReason();
            if (chargeRecord.getChargeOpenFlag() == 0) {
                Date chargeOpenTime = chargeRecord.getChargeOpenTime();
                Date chargeFinishTime = chargeRecord.getChargeFinishTime();
                Double maxPower = chargeRecord.getMaxPower();
                if (StringUtils.equals((CharSequence)"2", (CharSequence)finishReason)) {
                    if (chargeOpenTime != null && chargeFinishTime != null && DoubleUtils.defaultIfNull(maxPower, 0.0).compareTo(0.005) <= 0 && chargeFinishTime.getTime() - chargeOpenTime.getTime() < 600000L) {
                        isFullReturn = true;
                    }
                } else if (StringUtils.equals((CharSequence)"3", (CharSequence)finishReason) || StringUtils.equals((CharSequence)"5", (CharSequence)finishReason)) {
                    if (StringUtils.equals((CharSequence)chargeRecord.getSchemeType(), (CharSequence)"03")) {
                        isFullReturn = true;
                    } else if (chargeOpenTime != null && chargeFinishTime != null && chargeFinishTime.getTime() - chargeOpenTime.getTime() < 600000L) {
                        isFullReturn = true;
                    }
                } else if (StringUtils.equals((CharSequence)"-97", (CharSequence)finishReason) && chargeOpenTime != null && chargeFinishTime != null && DoubleUtils.defaultIfNull(maxPower, 0.0).compareTo(0.005) <= 0 && chargeFinishTime.getTime() - chargeOpenTime.getTime() < 1800000L) {
                    isFullReturn = true;
                }
            } else {
                isFullReturn = true;
            }
        }
        return isFullReturn;
    }

    private String getFullReturnDesc(ChargeRecord chargeRecord) {
        String returnDesc = "";
        if (ObjectUtils.isNotNull(chargeRecord)) {
            String finishReason = chargeRecord.getFinishReason();
            if (chargeRecord.getChargeOpenFlag() == 0) {
                Date chargeOpenTime = chargeRecord.getChargeOpenTime();
                Date chargeFinishTime = chargeRecord.getChargeFinishTime();
                Double maxPower = chargeRecord.getMaxPower();
                if (StringUtils.equals((CharSequence)"2", (CharSequence)finishReason)) {
                    if (chargeOpenTime != null && chargeFinishTime != null && DoubleUtils.defaultIfNull(maxPower, 0.0).compareTo(0.005) <= 0 && chargeFinishTime.getTime() - chargeOpenTime.getTime() < 600000L) {
                        returnDesc = "\u7531\u4e8e\u8be5\u5145\u7535\u63d2\u5ea7\u672a\u53ca\u65f6\u63d2\u5165\u5145\u7535\u5668\u5bfc\u81f4\u672c\u6b21\u5145\u7535\u7ed3\u675f\uff0c\u672c\u6b21\u5145\u7535\u5168\u989d\u9000\u8d39\u3002";
                    }
                } else if (StringUtils.equals((CharSequence)"3", (CharSequence)finishReason)) {
                    if (StringUtils.equals((CharSequence)chargeRecord.getSchemeType(), (CharSequence)"03")) {
                        returnDesc = "\u7531\u4e8e\u8be5\u5145\u7535\u63d2\u5ea7\u529f\u7387\u8d85\u9650\u5bfc\u81f4\u672c\u6b21\u5145\u7535\u7ed3\u675f\uff0c\u672c\u6b21\u5145\u7535\u5168\u989d\u9000\u8d39\u3002";
                    } else if (chargeOpenTime != null && chargeFinishTime != null && chargeFinishTime.getTime() - chargeOpenTime.getTime() < 600000L) {
                        returnDesc = "\u7531\u4e8e\u8be5\u5145\u7535\u63d2\u5ea7\u529f\u7387\u8d85\u9650\u5bfc\u81f4\u672c\u6b21\u5145\u7535\u7ed3\u675f\uff0c\u672c\u6b21\u5145\u7535\u5168\u989d\u9000\u8d39\u3002";
                    }
                } else if (StringUtils.equals((CharSequence)"5", (CharSequence)finishReason)) {
                    if (StringUtils.equals((CharSequence)chargeRecord.getSchemeType(), (CharSequence)"03")) {
                        returnDesc = "\u7531\u4e8e\u8be5\u5145\u7535\u63d2\u5ea7\u7aef\u5b50\u5931\u7535\u5bfc\u81f4\u672c\u6b21\u5145\u7535\u7ed3\u675f\uff0c\u672c\u6b21\u5145\u7535\u5168\u989d\u9000\u8d39\u3002";
                    } else if (chargeOpenTime != null && chargeFinishTime != null && chargeFinishTime.getTime() - chargeOpenTime.getTime() < 600000L) {
                        returnDesc = "\u7531\u4e8e\u8be5\u5145\u7535\u63d2\u5ea7\u7aef\u5b50\u5931\u7535\u5bfc\u81f4\u672c\u6b21\u5145\u7535\u7ed3\u675f\uff0c\u672c\u6b21\u5145\u7535\u5168\u989d\u9000\u8d39\u3002";
                    }
                } else if (StringUtils.equals((CharSequence)"-97", (CharSequence)finishReason) && chargeOpenTime != null && chargeFinishTime != null && DoubleUtils.defaultIfNull(maxPower, 0.0).compareTo(0.005) <= 0 && chargeFinishTime.getTime() - chargeOpenTime.getTime() < 1800000L) {
                    returnDesc = "\u7531\u4e8e\u8be5\u5145\u7535\u63d2\u5ea7\u672a\u53ca\u65f6\u63d2\u5165\u5145\u7535\u5668\u5bfc\u81f4\u672c\u6b21\u5145\u7535\u7ed3\u675f\uff0c\u672c\u6b21\u5145\u7535\u5168\u989d\u9000\u8d39\u3002";
                }
            } else {
                returnDesc = StringUtils.equals((CharSequence)finishReason, (CharSequence)"-1") ? "\u7531\u4e8e\u8bbe\u5907\u529f\u7387\u8d85\u9650\u5bfc\u81f4\u672c\u6b21\u5145\u7535\u5931\u8d25\uff0c\u672c\u6b21\u5145\u7535\u5168\u989d\u9000\u8d39\u3002" : "\u7531\u4e8e\u901a\u8baf\u539f\u56e0\u5bfc\u81f4\u672c\u6b21\u5145\u7535\u5931\u8d25\uff0c\u672c\u6b21\u5145\u7535\u5168\u989d\u9000\u8d39\u3002";
            }
        }
        return returnDesc;
    }

    private boolean checkToClosingChargeRecord(ChargeRecord chargeRecord) {
        return StringUtils.equals((CharSequence)"L", (CharSequence)this.chargeRecordDao.getClosingFlag(chargeRecord.getChargeRecordId(), true));
    }

    public static void main(String[] args) {
        BigDecimal up = new BigDecimal("0.655");
        up = up.add(new BigDecimal("0.2")).add(new BigDecimal("0.2"));
        System.out.println(up);
        double closingMoney = new BigDecimal(0.039).multiply(up).setScale(2, 4).doubleValue();
        System.out.println(closingMoney);
    }

    private boolean closingChargeRecordHandle(ChargeRecord chargeRecord) throws Exception {
        boolean result = false;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>>>>> start closingChargeRecordHandle >>>>>>>>>> ");
            this.logger.debug(" ChargeRecord : " + JsonConvertUtils.convertToString(chargeRecord));
        }
        if (this.checkToClosingChargeRecord(chargeRecord)) {
            Integer chargeOpenFlag = IntegerUtils.defaultIfNull(chargeRecord.getChargeOpenFlag(), 0);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("chargeOpenFlag : " + chargeOpenFlag);
            }
            String schemeType = chargeRecord.getSchemeType();
            Integer currUnitPriceFlag = IntegerUtils.defaultIfNull(chargeRecord.getCurrUnitPriceFlag(), 1);
            if (currUnitPriceFlag < 1 || currUnitPriceFlag > 5) {
                currUnitPriceFlag = 1;
            }
            Double unitPrice1 = DoubleUtils.defaultIfNegValue(chargeRecord.getUnitPrice1(), 0.0, 0.0);
            Double unitPrice2 = DoubleUtils.defaultIfNegValue(chargeRecord.getUnitPrice2(), 0.0, 0.0);
            Double unitPrice3 = DoubleUtils.defaultIfNegValue(chargeRecord.getUnitPrice3(), 0.0, 0.0);
            Double unitPrice4 = DoubleUtils.defaultIfNegValue(chargeRecord.getUnitPrice4(), 0.0, 0.0);
            Double unitPrice5 = DoubleUtils.defaultIfNegValue(chargeRecord.getUnitPrice5(), 0.0, 0.0);
            Double chargeAmount = DoubleUtils.defaultIfNegValue(chargeRecord.getChargeAmount(), 0.0, 0.0);
            Double usageAmount = DoubleUtils.defaultIfNegValue(chargeRecord.getUsageAmount(), 0.0, 0.0);
            Double closingMoney = 0.0;
            if (!this.isFullReturn(chargeRecord)) {
                if (StringUtils.equals((CharSequence)"02", (CharSequence)schemeType)) {
                    if (unitPrice1.compareTo(0.0) > 0) {
                        SchemeDetail sd = JsonConvertUtils.convertFromString(SchemeDetail.class, chargeRecord.getSchemeDetails());
                        BigDecimal up = new BigDecimal(unitPrice1.toString());
                        if (sd != null) {
                            up = up.add(new BigDecimal(sd.getCharge_service_fee())).add(new BigDecimal(sd.getElec_loss_fee()));
                        }
                        closingMoney = new BigDecimal(usageAmount).multiply(up).setScale(2, 4).doubleValue();
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug(" usageAmount          : " + usageAmount);
                            this.logger.debug(" unitPrice            : " + unitPrice1);
                            this.logger.debug(" closingMoney         : " + closingMoney);
                        }
                    }
                } else if (StringUtils.equals((CharSequence)"03", (CharSequence)schemeType)) {
                    closingMoney = new BigDecimal(chargeAmount).setScale(2, 4).doubleValue();
                } else if (StringUtils.equals((CharSequence)"05", (CharSequence)schemeType)) {
                    if (unitPrice1.compareTo(0.0) > 0) {
                        SchemeDetail sd = JsonConvertUtils.convertFromString(SchemeDetail.class, chargeRecord.getSchemeDetails());
                        BigDecimal up = new BigDecimal(unitPrice1.toString());
                        up = sd != null && sd.getCharge_service_fee() != null ? up.add(new BigDecimal(sd.getCharge_service_fee())) : up.add(new BigDecimal(unitPrice2.toString()));
                        closingMoney = new BigDecimal(usageAmount).multiply(up).setScale(2, 4).doubleValue();
                    }
                } else {
                    Integer closingPeriod = IntegerUtils.defaultIfNegValue(chargeRecord.getClosingPeriod(), 0, 0);
                    Double unitPrice = 0.0;
                    if (currUnitPriceFlag == 1) {
                        unitPrice = unitPrice1;
                    } else if (currUnitPriceFlag == 2) {
                        unitPrice = unitPrice2;
                    } else if (currUnitPriceFlag == 3) {
                        unitPrice = unitPrice3;
                    } else if (currUnitPriceFlag == 4) {
                        unitPrice = unitPrice4;
                    } else if (currUnitPriceFlag == 5) {
                        unitPrice = unitPrice5;
                    }
                    if (unitPrice.compareTo(0.0) > 0) {
                        if (closingPeriod > 0) {
                            Double closingAmount;
                            int closingPeriodCount = usageAmount.intValue() / closingPeriod;
                            int mod = usageAmount.intValue() % closingPeriod;
                            if (mod > 0) {
                                ++closingPeriodCount;
                            }
                            closingAmount = (closingAmount = Double.valueOf((double)(closingPeriodCount * closingPeriod) * 1.0)) < chargeAmount ? closingAmount : chargeAmount;
                            closingMoney = new BigDecimal(closingAmount).divide(new BigDecimal(unitPrice * 60.0), 2, 4).doubleValue();
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug(" mod                      : " + mod);
                                this.logger.debug(" closingPeriodCount       : " + closingPeriodCount);
                                this.logger.debug(" closingPeriod            : " + closingPeriod);
                                this.logger.debug(" closingAmount            : " + closingAmount);
                            }
                        } else {
                            closingMoney = new BigDecimal(usageAmount).divide(new BigDecimal(unitPrice * 60.0), 2, 4).doubleValue();
                        }
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug(" usageAmount          : " + usageAmount);
                            this.logger.debug(" unitPrice            : " + unitPrice);
                            this.logger.debug(" unitPrice * 60.0D    : " + new BigDecimal(unitPrice * 60.0).doubleValue());
                            this.logger.debug(" closingMoney         : " + closingMoney);
                        }
                    }
                }
            }
            chargeRecord.setClosingFlag("Y");
            chargeRecord.setClosingMoney(closingMoney);
            chargeRecord.setClosingTime(new Date());
            this.chargeRecordDao.finshClosingChargeRecord(chargeRecord);
            result = true;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" <<<<<<<<<<< end closingChargeRecordHandle <<<<<<<<<<< ");
        }
        return result;
    }

    private boolean checkToReturnChargeRecord(ChargeRecord chargeRecord) {
        return StringUtils.equals((CharSequence)"L", (CharSequence)this.chargeRecordDao.getReturnFlag(chargeRecord.getChargeRecordId(), true));
    }

    private boolean returnChargeRecordHandle(ChargeRecord chargeRecord) throws Exception {
        boolean result = false;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>>>>> start returnChargeRecordHandle >>>>>>>>>> ");
            this.logger.debug(" ChargeRecord         : " + JsonConvertUtils.convertToString(chargeRecord));
        }
        if (this.checkToReturnChargeRecord(chargeRecord)) {
            boolean needReturn = false;
            if (this.isFullReturn(chargeRecord)) {
                needReturn = true;
            } else if (StringUtils.notEquals("-98", chargeRecord.getFinishReason()) && StringUtils.equals((CharSequence)"Y", (CharSequence)chargeRecord.getIsReturn())) {
                needReturn = true;
            }
            String enterUserType = chargeRecord.getEnterUserType();
            String enterUserId = chargeRecord.getEnterUserId();
            Double chargeMoney = DoubleUtils.defaultIfNegValue(chargeRecord.getChargeMoney(), 0.0, 0.0);
            Double closingMoney = DoubleUtils.defaultIfNegValue(chargeRecord.getClosingMoney(), 0.0, 0.0);
            Double serviceRate = DoubleUtils.defaultIfNegValue(chargeRecord.getServiceRate(), 0.0, 0.0);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("enterUserType : " + enterUserType);
                this.logger.debug("enterUserId   : " + enterUserId);
                this.logger.debug("chargeMoney   : " + chargeMoney);
                this.logger.debug("closingMoney  : " + closingMoney);
                this.logger.debug("serviceRate   : " + serviceRate);
            }
            Double returnMoney = 0.0;
            if (needReturn) {
                if (chargeMoney > closingMoney) {
                    returnMoney = new BigDecimal(chargeMoney - closingMoney).setScale(2, 4).doubleValue();
                    chargeRecord.setReturnFlag("F");
                    chargeRecord.setReturnMoney(returnMoney);
                    chargeRecord.setTotalReturnMoney(returnMoney);
                    chargeRecord.setReturnTime(new Date());
                    chargeRecord.setReturnDesc("\u9000\u8d39\u5931\u8d25");
                    TradeOrderRefundRequest tradeOrderRefundRequest = new TradeOrderRefundRequest();
                    tradeOrderRefundRequest.setOrderId(chargeRecord.getChargeTradeOrderId());
                    tradeOrderRefundRequest.setRefundNo(UUID.randomUUID().toString().replaceAll("-", "").toLowerCase());
                    tradeOrderRefundRequest.setRefundMoney(returnMoney);
                    TradeOrderRefundResponse tradeOrderRefundResponse = this.tradeOrderService.refundTradeOrder(tradeOrderRefundRequest);
                    if (tradeOrderRefundResponse != null && ResponseResultEnum.SUCCESS.getResult().equals(tradeOrderRefundResponse.getResult())) {
                        TradeOrderRefundDo tradeOrderRefund = tradeOrderRefundResponse.getTradeOrderRefund();
                        if (RefundResultEnum.REFUND_NOTIFY_WAITING.getResult().equals(tradeOrderRefund.getRefundResult())) {
                            chargeRecord.setReturnFlag("W");
                            chargeRecord.setReturnDesc(this.isFullReturn(chargeRecord) ? this.getFullReturnDesc(chargeRecord) : "\u8be5\u5145\u7535\u7ad9\u652f\u6301\u672a\u6d88\u8d39\u91d1\u989d\u7684\u9000\u8d39\u3002");
                            chargeRecord.setReturnTradeOrderId(tradeOrderRefund.getRefundNo());
                        } else if (RefundResultEnum.REFUND_SUCCESS.getResult().equals(tradeOrderRefund.getRefundResult())) {
                            chargeRecord.setReturnFlag("Y");
                            chargeRecord.setReturnDesc(this.isFullReturn(chargeRecord) ? this.getFullReturnDesc(chargeRecord) : "\u8be5\u5145\u7535\u7ad9\u652f\u6301\u672a\u6d88\u8d39\u91d1\u989d\u7684\u9000\u8d39\u3002");
                            chargeRecord.setReturnTradeOrderId(tradeOrderRefund.getRefundNo());
                            chargeRecord.setReturnSuccessTime(new Date());
                        } else if (RefundResultEnum.REFUND_FAILURE.getResult().equals(tradeOrderRefund.getRefundResult())) {
                            chargeRecord.setReturnFlag("F");
                            chargeRecord.setReturnDesc(this.isFullReturn(chargeRecord) ? this.getFullReturnDesc(chargeRecord) : "\u8be5\u5145\u7535\u7ad9\u652f\u6301\u672a\u6d88\u8d39\u91d1\u989d\u7684\u9000\u8d39\u3002");
                            chargeRecord.setReturnTradeOrderId(tradeOrderRefund.getRefundNo());
                        }
                    } else if (tradeOrderRefundResponse != null && ResponseResultEnum.FAILURE.getResult().equals(tradeOrderRefundResponse.getResult())) {
                        chargeRecord.setReturnFlag("F");
                        chargeRecord.setReturnDesc((this.isFullReturn(chargeRecord) ? this.getFullReturnDesc(chargeRecord) : "\u8be5\u5145\u7535\u7ad9\u652f\u6301\u672a\u6d88\u8d39\u91d1\u989d\u7684\u9000\u8d39\u3002") + "\uff08" + tradeOrderRefundResponse.getFailureCode() + ":" + tradeOrderRefundResponse.getFailureMsg() + "\uff09");
                    }
                } else {
                    chargeRecord.setReturnFlag("D");
                    chargeRecord.setReturnMoney(returnMoney);
                    chargeRecord.setReturnTime(new Date());
                    chargeRecord.setReturnDesc("\u65e0\u9700\u9000\u8d39" + (chargeMoney.compareTo(0.0) > 0 ? " : \u5145\u7535\u91d1\u989d\u5c0f\u4e8e\u7b49\u4e8e\u7ed3\u7b97\u91d1\u989d" : " : \u514d\u8d39\u5145\u7535"));
                }
            } else {
                chargeRecord.setReturnFlag("D");
                chargeRecord.setReturnMoney(returnMoney);
                chargeRecord.setReturnTime(new Date());
                chargeRecord.setReturnDesc("\u65e0\u9700\u9000\u8d39" + (StringUtils.equals((CharSequence)"N", (CharSequence)chargeRecord.getIsReturn()) ? " : \u8ba1\u8d39\u65b9\u6848\u4e3a\u4e0d\u9000\u8d39" : ""));
            }
            Double usageElecCons = DoubleUtils.defaultIfNegValue(chargeRecord.getUsageElecCons(), 0.0, 0.0);
            Double costUnitPrice = DoubleUtils.defaultIfNegValue(chargeRecord.getCostUnitPrice(), 0.0, 0.0);
            Double income = new BigDecimal(chargeMoney - returnMoney).setScale(2, 4).doubleValue();
            Double cost = new BigDecimal(usageElecCons * costUnitPrice).setScale(2, 4).doubleValue();
            Double profit = new BigDecimal(income - cost).setScale(2, 4).doubleValue();
            if (serviceRate.compareTo(100.0) > 0) {
                serviceRate = 100.0;
            }
            Double serviceMoney = new BigDecimal(income * serviceRate / 100.0).setScale(2, 4).doubleValue();
            Double incomeExService = new BigDecimal(income - serviceMoney).setScale(2, 4).doubleValue();
            Double profitExService = new BigDecimal(profit - serviceMoney).setScale(2, 4).doubleValue();
            chargeRecord.setIncome(income);
            chargeRecord.setCost(cost);
            chargeRecord.setProfit(profit);
            chargeRecord.setServiceMoney(serviceMoney);
            chargeRecord.setIncomeExService(incomeExService);
            chargeRecord.setProfitExService(profitExService);
            if (serviceMoney.compareTo(0.0) > 0 && StringUtils.equals((CharSequence)EB_TRANSIT_USERTYPE, (CharSequence)enterUserType) && StringUtils.equals((CharSequence)"10000000", (CharSequence)enterUserId)) {
                chargeRecord.setServiceTime(new Date());
                TradeOrderCreateRequest tradeOrderCreateRequest = new TradeOrderCreateRequest();
                tradeOrderCreateRequest.setUserId("10000000");
                tradeOrderCreateRequest.setUserType(EB_SERVICE_USERTYPE);
                tradeOrderCreateRequest.setCounterUserId("10000000");
                tradeOrderCreateRequest.setCounterUserType(EB_TRANSIT_USERTYPE);
                tradeOrderCreateRequest.setOrderMoney(serviceMoney);
                tradeOrderCreateRequest.setOrderType(OrderTypeEnum.TRADE.getCode());
                tradeOrderCreateRequest.setBusinessModule(EB_SERVICE_USERTYPE);
                tradeOrderCreateRequest.setBusinessId(chargeRecord.getChargeRecordId());
                tradeOrderCreateRequest.setOrderRemark("\u7535\u52a8\u81ea\u884c\u8f66\u5145\u7535\u670d\u52a1\u8d39");
                TradeOrderCreateResponse tradeOrderCreateResponse = this.tradeOrderService.createTradeOrder(tradeOrderCreateRequest);
                if (tradeOrderCreateResponse != null && ResponseResultEnum.SUCCESS.getResult().equals(tradeOrderCreateResponse.getResult())) {
                    TradeOrderDo tradeOrder = tradeOrderCreateResponse.getTradeOrder();
                    String serviceTradeOrderId = tradeOrder.getOrderId();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(" [ \u751f\u6210\u670d\u52a1\u8d39\u4ea4\u6613\u8ba2\u5355ID ] : " + serviceTradeOrderId);
                    }
                    TradeOrderPayRequest tradeOrderPayRequest = new TradeOrderPayRequest();
                    tradeOrderPayRequest.setOrderId(serviceTradeOrderId);
                    tradeOrderPayRequest.setPayMoney(tradeOrder.getOrderMoney());
                    tradeOrderPayRequest.setPayType(PayTypeEnum.INNERACCT.getCode());
                    TradeOrderPayResponse tradeOrderPayResponse = this.tradeOrderService.payTradeOrder(tradeOrderPayRequest);
                    if (ResponseResultEnum.SUCCESS.getResult().equals(tradeOrderPayResponse.getResult()) && PayResultEnum.PAY_SUCCESS.getResult().equals(tradeOrderPayResponse.getTradeOrderPay().getPayResult())) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug(" [ \u7535\u52a8\u81ea\u884c\u8f66\u5145\u7535\u670d\u52a1\u8d39\u6536\u53d6\u6210\u529f ] : " + serviceTradeOrderId);
                        }
                        chargeRecord.setServiceFlag("S");
                        chargeRecord.setServiceDesc("\u7535\u52a8\u81ea\u884c\u8f66\u5145\u7535\u670d\u52a1\u8d39\u6536\u53d6\u6210\u529f");
                        chargeRecord.setServiceTradeOrderId(serviceTradeOrderId);
                        chargeRecord.setServiceSuccessTime(new Date());
                    } else {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug(" [ \u7535\u52a8\u81ea\u884c\u8f66\u5145\u7535\u670d\u52a1\u8d39\u6536\u53d6\u5931\u8d25 ] : " + serviceTradeOrderId);
                        }
                        chargeRecord.setServiceFlag("F");
                        chargeRecord.setServiceDesc("\u7535\u52a8\u81ea\u884c\u8f66\u5145\u7535\u670d\u52a1\u8d39\u6536\u53d6\u5931\u8d25");
                        chargeRecord.setServiceTradeOrderId(serviceTradeOrderId);
                    }
                } else if (tradeOrderCreateResponse != null && ResponseResultEnum.FAILURE.getResult().equals(tradeOrderCreateResponse.getResult())) {
                    chargeRecord.setServiceFlag("F");
                    chargeRecord.setServiceDesc("\u7535\u52a8\u81ea\u884c\u8f66\u5145\u7535\u670d\u52a1\u8d39\u6536\u53d6\u5931\u8d25 : \u672a\u77e5\u539f\u56e0\uff08" + tradeOrderCreateResponse.getFailureCode() + ":" + tradeOrderCreateResponse.getFailureMsg() + "\uff09");
                }
            } else {
                chargeRecord.setServiceFlag("N");
                chargeRecord.setServiceDesc("\u65e0\u670d\u52a1\u8d39");
            }
            if (incomeExService.compareTo(0.0) > 0 && StringUtils.equals((CharSequence)EB_TRANSIT_USERTYPE, (CharSequence)enterUserType) && StringUtils.equals((CharSequence)"10000000", (CharSequence)enterUserId)) {
                Double orgoprIncomeRatio = 100.0;
                Double allocatedIncomeRatio = 0.0;
                ArrayList<ChargeRecordIncomeDetailInfo> cridInfoList = new ArrayList<ChargeRecordIncomeDetailInfo>();
                List<CsshDistSchemeInfo> cdsInfoList = this.csshDistschemeDao.getCsshDistSchemeInfoList(chargeRecord.getChargestationId());
                int distIndex = 0;
                if (CollectionUtils.sizeIsNotEmptyIgnoreNull(cdsInfoList)) {
                    for (CsshDistSchemeInfo cdsInfo : cdsInfoList) {
                        Double distRatio;
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug(" CsshDistSchemeInfo : " + JsonConvertUtils.convertToString(cdsInfo));
                        }
                        if ((distRatio = DoubleUtils.defaultIfNegValue(cdsInfo.getIncomeRatio(), 0.0, 0.0)) + allocatedIncomeRatio > 100.0) {
                            distRatio = 100.0 - allocatedIncomeRatio;
                        }
                        Double distMoney = new BigDecimal(incomeExService * distRatio / 100.0).setScale(2, 4).doubleValue();
                        allocatedIncomeRatio = distRatio + allocatedIncomeRatio;
                        ChargeRecordIncomeDetailInfo cridInfo = new ChargeRecordIncomeDetailInfo();
                        cridInfo.setChargeRecordId(chargeRecord.getChargeRecordId());
                        cridInfo.setDistSn(++distIndex);
                        cridInfo.setDistUserType("platform_org");
                        cridInfo.setDistUserId(cdsInfo.getStakeholderOrgNo());
                        cridInfo.setDistRatio(distRatio);
                        cridInfo.setDistMoney(distMoney);
                        cridInfo.setDistTime(new Date());
                        TradeOrderCreateRequest tradeOrderCreateRequest = new TradeOrderCreateRequest();
                        tradeOrderCreateRequest.setUserId(cridInfo.getDistUserId());
                        tradeOrderCreateRequest.setUserType(cridInfo.getDistUserType());
                        tradeOrderCreateRequest.setCounterUserId("10000000");
                        tradeOrderCreateRequest.setCounterUserType(EB_TRANSIT_USERTYPE);
                        tradeOrderCreateRequest.setOrderMoney(cridInfo.getDistMoney());
                        tradeOrderCreateRequest.setOrderType(OrderTypeEnum.TRADE.getCode());
                        tradeOrderCreateRequest.setBusinessModule("ebike_distincome");
                        tradeOrderCreateRequest.setBusinessId(chargeRecord.getChargeRecordId() + "_2_" + cridInfo.getDistSn() + ":" + cdsInfo.getStakeholderOrgNo());
                        tradeOrderCreateRequest.setOrderRemark("\u7535\u52a8\u81ea\u884c\u8f66\u5145\u7535\u6536\u5165\u5206\u914d\uff08\u5229\u76ca\u76f8\u5173\u65b9\uff09");
                        TradeOrderCreateResponse tradeOrderCreateResponse = this.tradeOrderService.createTradeOrder(tradeOrderCreateRequest);
                        if (tradeOrderCreateResponse != null && ResponseResultEnum.SUCCESS.getResult().equals(tradeOrderCreateResponse.getResult())) {
                            TradeOrderDo tradeOrder = tradeOrderCreateResponse.getTradeOrder();
                            String distTradeOrderId = tradeOrder.getOrderId();
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug(" [ \u751f\u6210\u6536\u5165\u5206\u914d\u4ea4\u6613\u8ba2\u5355ID ] : " + distTradeOrderId);
                            }
                            TradeOrderPayRequest tradeOrderPayRequest = new TradeOrderPayRequest();
                            tradeOrderPayRequest.setOrderId(distTradeOrderId);
                            tradeOrderPayRequest.setPayMoney(tradeOrder.getOrderMoney());
                            tradeOrderPayRequest.setPayType(PayTypeEnum.INNERACCT.getCode());
                            TradeOrderPayResponse tradeOrderPayResponse = this.tradeOrderService.payTradeOrder(tradeOrderPayRequest);
                            if (ResponseResultEnum.SUCCESS.getResult().equals(tradeOrderPayResponse.getResult()) && PayResultEnum.PAY_SUCCESS.getResult().equals(tradeOrderPayResponse.getTradeOrderPay().getPayResult())) {
                                if (this.logger.isDebugEnabled()) {
                                    this.logger.debug(" [ \u7535\u52a8\u81ea\u884c\u8f66\u5145\u7535\u6536\u5165\u5206\u914d\uff08\u5229\u76ca\u76f8\u5173\u65b9\uff09\u6210\u529f ] : " + distTradeOrderId);
                                }
                                cridInfo.setDistFlag("S");
                                cridInfo.setDistDesc("\u7535\u52a8\u81ea\u884c\u8f66\u5145\u7535\u6536\u5165\u5206\u914d\uff08\u5229\u76ca\u76f8\u5173\u65b9\uff09\u6210\u529f");
                                cridInfo.setDistTradeOrderId(distTradeOrderId);
                                cridInfo.setDistSuccessTime(new Date());
                            } else {
                                if (this.logger.isDebugEnabled()) {
                                    this.logger.debug(" [ \u7535\u52a8\u81ea\u884c\u8f66\u5145\u7535\u6536\u5165\u5206\u914d\uff08\u5229\u76ca\u76f8\u5173\u65b9\uff09\u5931\u8d25 ] : " + distTradeOrderId);
                                }
                                cridInfo.setDistFlag("F");
                                cridInfo.setDistDesc("\u7535\u52a8\u81ea\u884c\u8f66\u5145\u7535\u6536\u5165\u5206\u914d\uff08\u5229\u76ca\u76f8\u5173\u65b9\uff09\u5931\u8d25");
                                cridInfo.setDistTradeOrderId(distTradeOrderId);
                            }
                        } else if (tradeOrderCreateResponse != null && ResponseResultEnum.FAILURE.getResult().equals(tradeOrderCreateResponse.getResult())) {
                            cridInfo.setDistFlag("F");
                            cridInfo.setDistDesc("\u7535\u52a8\u81ea\u884c\u8f66\u5145\u7535\u6536\u5165\u5206\u914d\uff08\u5229\u76ca\u76f8\u5173\u65b9\uff09\u5931\u8d25 : \u539f\u56e0\uff08" + tradeOrderCreateResponse.getFailureCode() + ":" + tradeOrderCreateResponse.getFailureMsg() + "\uff09");
                        }
                        cridInfoList.add(cridInfo);
                    }
                }
                orgoprIncomeRatio = orgoprIncomeRatio - allocatedIncomeRatio;
                Double orgoprIncomeMoney = new BigDecimal(incomeExService * orgoprIncomeRatio / 100.0).setScale(2, 4).doubleValue();
                ChargeRecordIncomeDetailInfo orgoprCridInfo = new ChargeRecordIncomeDetailInfo();
                orgoprCridInfo.setChargeRecordId(chargeRecord.getChargeRecordId());
                orgoprCridInfo.setDistSn(++distIndex);
                orgoprCridInfo.setDistUserType("platform_org");
                orgoprCridInfo.setDistUserId(chargeRecord.getOrgNo());
                orgoprCridInfo.setDistRatio(orgoprIncomeRatio);
                orgoprCridInfo.setDistMoney(orgoprIncomeMoney);
                orgoprCridInfo.setDistTime(new Date());
                TradeOrderCreateRequest tradeOrderCreateRequest = new TradeOrderCreateRequest();
                tradeOrderCreateRequest.setUserId(orgoprCridInfo.getDistUserId());
                tradeOrderCreateRequest.setUserType(orgoprCridInfo.getDistUserType());
                tradeOrderCreateRequest.setCounterUserId("10000000");
                tradeOrderCreateRequest.setCounterUserType(EB_TRANSIT_USERTYPE);
                tradeOrderCreateRequest.setOrderMoney(orgoprCridInfo.getDistMoney());
                tradeOrderCreateRequest.setOrderType(OrderTypeEnum.TRADE.getCode());
                tradeOrderCreateRequest.setBusinessModule("ebike_distincome");
                tradeOrderCreateRequest.setBusinessId(chargeRecord.getChargeRecordId() + "_2_" + orgoprCridInfo.getDistSn() + ":" + chargeRecord.getOrgNo());
                tradeOrderCreateRequest.setOrderRemark("\u7535\u52a8\u81ea\u884c\u8f66\u5145\u7535\u6536\u5165\u5206\u914d\uff08\u8fd0\u8425\u65b9\uff09");
                TradeOrderCreateResponse tradeOrderCreateResponse = this.tradeOrderService.createTradeOrder(tradeOrderCreateRequest);
                if (tradeOrderCreateResponse != null && ResponseResultEnum.SUCCESS.getResult().equals(tradeOrderCreateResponse.getResult())) {
                    TradeOrderDo tradeOrder = tradeOrderCreateResponse.getTradeOrder();
                    String orgoprDistTradeOrderId = tradeOrder.getOrderId();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(" [ \u751f\u6210\u6536\u5165\u5206\u914d\u4ea4\u6613\u8ba2\u5355ID ] : " + orgoprDistTradeOrderId);
                    }
                    TradeOrderPayRequest tradeOrderPayRequest = new TradeOrderPayRequest();
                    tradeOrderPayRequest.setOrderId(orgoprDistTradeOrderId);
                    tradeOrderPayRequest.setPayMoney(tradeOrder.getOrderMoney());
                    tradeOrderPayRequest.setPayType(PayTypeEnum.INNERACCT.getCode());
                    TradeOrderPayResponse tradeOrderPayResponse = this.tradeOrderService.payTradeOrder(tradeOrderPayRequest);
                    if (ResponseResultEnum.SUCCESS.getResult().equals(tradeOrderPayResponse.getResult()) && PayResultEnum.PAY_SUCCESS.getResult().equals(tradeOrderPayResponse.getTradeOrderPay().getPayResult())) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug(" [ \u7535\u52a8\u81ea\u884c\u8f66\u5145\u7535\u6536\u5165\u5206\u914d\uff08\u8fd0\u8425\u65b9\uff09\u6210\u529f ] : " + orgoprDistTradeOrderId);
                        }
                        orgoprCridInfo.setDistFlag("S");
                        orgoprCridInfo.setDistDesc("\u7535\u52a8\u81ea\u884c\u8f66\u5145\u7535\u6536\u5165\u5206\u914d\uff08\u8fd0\u8425\u65b9\uff09\u6210\u529f");
                        orgoprCridInfo.setDistTradeOrderId(orgoprDistTradeOrderId);
                        orgoprCridInfo.setDistSuccessTime(new Date());
                    } else {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug(" [ \u7535\u52a8\u81ea\u884c\u8f66\u5145\u7535\u6536\u5165\u5206\u914d\uff08\u8fd0\u8425\u65b9\uff09\u5931\u8d25 ] : " + orgoprDistTradeOrderId);
                        }
                        orgoprCridInfo.setDistFlag("F");
                        orgoprCridInfo.setDistDesc("\u7535\u52a8\u81ea\u884c\u8f66\u5145\u7535\u6536\u5165\u5206\u914d\uff08\u8fd0\u8425\u65b9\uff09\u5931\u8d25");
                        orgoprCridInfo.setDistTradeOrderId(orgoprDistTradeOrderId);
                    }
                } else if (tradeOrderCreateResponse != null && ResponseResultEnum.FAILURE.getResult().equals(tradeOrderCreateResponse.getResult())) {
                    orgoprCridInfo.setDistFlag("F");
                    orgoprCridInfo.setDistDesc("\u7535\u52a8\u81ea\u884c\u8f66\u5145\u7535\u6536\u5165\u5206\u914d\uff08\u8fd0\u8425\u65b9\uff09\u5931\u8d25 : \u539f\u56e0\uff08" + tradeOrderCreateResponse.getFailureCode() + ":" + tradeOrderCreateResponse.getFailureMsg() + "\uff09");
                }
                cridInfoList.add(orgoprCridInfo);
                this.chargeRecordIncomeDetailDao.createChargeRecordIncomeDetailInfoList(cridInfoList);
            }
            this.chargeRecordDao.finshReturnChargeRecord(chargeRecord);
            if (StringUtils.equals((CharSequence)chargeRecord.getReturnFlag(), (CharSequence)"Y")) {
                this.chargeOrderEventPublisher.publishEvent("return", chargeRecord);
            }
            result = true;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" <<<<<<<<<<< end returnChargeRecordHandle <<<<<<<<<<< ");
        }
        return result;
    }

    private class ReturnChargeRecordHandleThread
    extends Thread {
        private ReturnChargeRecordHandleThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (true) {
                    ChargeRecord chargeRecord;
                    if ((chargeRecord = (ChargeRecord)ChargeRecordClosingHandleTask.this.returnLinkedQueue.poll()) == null) {
                        ConcurrentLinkedQueue concurrentLinkedQueue = ChargeRecordClosingHandleTask.this.returnLinkedQueue;
                        synchronized (concurrentLinkedQueue) {
                            ChargeRecordClosingHandleTask.this.returnLinkedQueue.wait(500L);
                            continue;
                        }
                    }
                    if (ChargeRecordClosingHandleTask.this.logger.isInfoEnabled()) {
                        ChargeRecordClosingHandleTask.this.logger.info(" return charge record handle   : " + chargeRecord.toString());
                        ChargeRecordClosingHandleTask.this.logger.info(" tradeOrderService             : " + ChargeRecordClosingHandleTask.this.tradeOrderService);
                    }
                    boolean b = false;
                    try {
                        b = ChargeRecordClosingHandleTask.this.returnChargeRecordHandle(chargeRecord);
                    }
                    catch (Exception e) {
                        ChargeRecordClosingHandleTask.this.logger.error(e.getMessage(), e.fillInStackTrace());
                        TimeUnit.SECONDS.sleep(1L);
                    }
                    if (!b || !ChargeRecordClosingHandleTask.this.logger.isInfoEnabled()) continue;
                    ChargeRecordClosingHandleTask.this.logger.info(" return charge record finish : " + chargeRecord.toString());
                }
            }
            catch (InterruptedException e) {
                ChargeRecordClosingHandleTask.this.logger.error(e.getMessage(), e.fillInStackTrace());
                return;
            }
        }
    }

    private class ReturnHandleChargeRecordScanThread
    extends Thread {
        private ReturnHandleChargeRecordScanThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    List list;
                    while (true) {
                        list = null;
                        try {
                            list = ChargeRecordClosingHandleTask.this.lockTobeReturnChargeRecordList();
                        }
                        catch (Exception e) {
                            ChargeRecordClosingHandleTask.this.logger.error(e.getMessage(), e.fillInStackTrace());
                        }
                        if (!CollectionUtils.sizeIsEmptyIgnoreNull(list)) break;
                        TimeUnit.SECONDS.sleep(1L);
                    }
                    ConcurrentLinkedQueue concurrentLinkedQueue = ChargeRecordClosingHandleTask.this.returnLinkedQueue;
                    synchronized (concurrentLinkedQueue) {
                        for (ChargeRecord chargeRecord : list) {
                            if (ChargeRecordClosingHandleTask.this.logger.isInfoEnabled()) {
                                ChargeRecordClosingHandleTask.this.logger.info(" return charge record scan   : " + chargeRecord.toString());
                            }
                            ChargeRecordClosingHandleTask.this.returnLinkedQueue.offer(chargeRecord);
                        }
                        ChargeRecordClosingHandleTask.this.returnLinkedQueue.notifyAll();
                    }
                }
                catch (InterruptedException _ie) {
                    ChargeRecordClosingHandleTask.this.logger.error(_ie.getMessage(), _ie.fillInStackTrace());
                    return;
                }
            }
        }
    }

    private class ClosingChargeRecordHandleThread
    extends Thread {
        private ClosingChargeRecordHandleThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block10: while (true) {
                try {
                    ChargeRecord chargeRecord;
                    boolean b;
                    do {
                        if ((chargeRecord = (ChargeRecord)ChargeRecordClosingHandleTask.this.closingLinkedQueue.poll()) == null) {
                            ConcurrentLinkedQueue concurrentLinkedQueue = ChargeRecordClosingHandleTask.this.closingLinkedQueue;
                            synchronized (concurrentLinkedQueue) {
                                ChargeRecordClosingHandleTask.this.closingLinkedQueue.wait(100L);
                                continue block10;
                            }
                        }
                        if (ChargeRecordClosingHandleTask.this.logger.isInfoEnabled()) {
                            ChargeRecordClosingHandleTask.this.logger.info(" closing charge record handle : " + chargeRecord.toString());
                        }
                        b = false;
                        try {
                            b = ChargeRecordClosingHandleTask.this.closingChargeRecordHandle(chargeRecord);
                        }
                        catch (Exception e) {
                            ChargeRecordClosingHandleTask.this.logger.error(e.getMessage(), e.fillInStackTrace());
                            TimeUnit.SECONDS.sleep(1L);
                        }
                    } while (!b);
                    if (ChargeRecordClosingHandleTask.this.logger.isInfoEnabled()) {
                        ChargeRecordClosingHandleTask.this.logger.info(" closing charge record finish : " + chargeRecord.toString());
                    }
                    ConcurrentLinkedQueue concurrentLinkedQueue = ChargeRecordClosingHandleTask.this.returnLinkedQueue;
                    synchronized (concurrentLinkedQueue) {
                        ArrayList<ChargeRecord> crList = new ArrayList<ChargeRecord>();
                        crList.add(chargeRecord);
                        ChargeRecordClosingHandleTask.this.chargeRecordDao.lockNotReturnChargeRecordList(crList);
                        if (ChargeRecordClosingHandleTask.this.logger.isInfoEnabled()) {
                            ChargeRecordClosingHandleTask.this.logger.info(" return charge record scan   : " + chargeRecord.toString());
                        }
                        ChargeRecordClosingHandleTask.this.returnLinkedQueue.offer(chargeRecord);
                        ChargeRecordClosingHandleTask.this.returnLinkedQueue.notify();
                    }
                }
                catch (InterruptedException _ie) {
                    ChargeRecordClosingHandleTask.this.logger.error(_ie.getMessage(), _ie.fillInStackTrace());
                    return;
                }
            }
        }
    }

    private class ClosingHandleChargeRecordScanThread
    extends Thread {
        private ClosingHandleChargeRecordScanThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    List list;
                    while (true) {
                        list = null;
                        try {
                            list = ChargeRecordClosingHandleTask.this.lockTobeClosingChargeRecordList();
                        }
                        catch (Exception e) {
                            ChargeRecordClosingHandleTask.this.logger.error(e.getMessage(), e.fillInStackTrace());
                        }
                        if (!CollectionUtils.sizeIsEmptyIgnoreNull(list)) break;
                        TimeUnit.SECONDS.sleep(1L);
                    }
                    ConcurrentLinkedQueue concurrentLinkedQueue = ChargeRecordClosingHandleTask.this.closingLinkedQueue;
                    synchronized (concurrentLinkedQueue) {
                        for (ChargeRecord chargeRecord : list) {
                            if (ChargeRecordClosingHandleTask.this.logger.isInfoEnabled()) {
                                ChargeRecordClosingHandleTask.this.logger.info(" closing charge record scan   : " + chargeRecord.toString());
                            }
                            ChargeRecordClosingHandleTask.this.closingLinkedQueue.offer(chargeRecord);
                        }
                        ChargeRecordClosingHandleTask.this.closingLinkedQueue.notifyAll();
                    }
                }
                catch (InterruptedException _ie) {
                    ChargeRecordClosingHandleTask.this.logger.error(_ie.getMessage(), _ie.fillInStackTrace());
                    return;
                }
            }
        }
    }
}

