/*
 * Decompiled with CFR 0.152.
 */
package cn.yunrui.mqttclient.ebikesrv.handletask;

import cn.yunrui.mqttclient.ebikesrv.common.utils.CollectionUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.DoubleUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.JsonConvertUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.ChargeRecordDao;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.ChargeRecordIncomeDetailDao;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargeRecord;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargeRecordIncomeDetailInfo;
import com.ebikepay.openservices.entity.RefundResultEnum;
import com.ebikepay.openservices.entity.TradeOrderRefundDo;
import com.ebikepay.openservices.request.TradeOrderRefundRequest;
import com.ebikepay.openservices.response.TradeOrderRefundResponse;
import com.ebikepay.openservices.service.TradeOrderService;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CscWorkorderRefundHandleTask {
    private static final String EB_TRANSIT_USERTYPE = "ebike_transit";
    private static final String EB_TRANSIT_USERID = "10000000";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ConcurrentLinkedQueue<ChargeRecord> csrefundLinkedQueue = new ConcurrentLinkedQueue();
    private static final int INTERVAL_WAIT = 60;
    private Thread csrefundHandleChargeRecordScanThread;
    private Thread csrefundChargeRecordHandleThread;
    @Resource(name="tradeOrderService")
    private TradeOrderService tradeOrderService;
    @Resource(name="chargeRecordDao")
    private ChargeRecordDao chargeRecordDao;
    @Resource(name="chargeRecordIncomeDetailDao")
    private ChargeRecordIncomeDetailDao chargeRecordIncomeDetailDao;

    @PostConstruct
    public void init() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start init CscWorkorderRefundHandleTask >>>>>> ");
        }
        this.csrefundHandleChargeRecordScanThread = new CsrefundHandleChargeRecordScanThread();
        this.csrefundHandleChargeRecordScanThread.setDaemon(true);
        this.csrefundHandleChargeRecordScanThread.start();
        this.csrefundChargeRecordHandleThread = new CsrefundChargeRecordHandleThread();
        this.csrefundChargeRecordHandleThread.setDaemon(true);
        this.csrefundChargeRecordHandleThread.start();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" <<<<<<< end init CscWorkorderRefundHandleTask <<<<<<< ");
        }
    }

    @PreDestroy
    public void destroy() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start destroy CscWorkorderRefundHandleTask >>>>>> ");
        }
        if (this.csrefundHandleChargeRecordScanThread != null) {
            try {
                this.csrefundHandleChargeRecordScanThread.join();
            }
            catch (InterruptedException _ie) {
                this.logger.error(_ie.getMessage(), _ie.fillInStackTrace());
            }
        }
        if (this.csrefundChargeRecordHandleThread != null) {
            try {
                this.csrefundChargeRecordHandleThread.join();
            }
            catch (InterruptedException _ie) {
                this.logger.error(_ie.getMessage(), _ie.fillInStackTrace());
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" <<<<<<< end destroy CscWorkorderRefundHandleTask <<<<<<< ");
        }
    }

    private List<ChargeRecord> lockTobeCsrefundChargeRecordList() throws Exception {
        List<ChargeRecord> crList = this.chargeRecordDao.getWaitingCsrefundChargeRecordList();
        if (CollectionUtils.sizeIsNotEmptyIgnoreNull(crList)) {
            this.chargeRecordDao.lockWaitingCsrefundChargeRecordList(crList);
        }
        return crList;
    }

    private boolean checkToCsrefundChargeRecord(ChargeRecord chargeRecord) {
        return StringUtils.equals((CharSequence)"L", (CharSequence)this.chargeRecordDao.getCsrefundResult(chargeRecord.getChargeRecordId(), true));
    }

    private boolean checkCscReturnHandleResult(ChargeRecord chargeRecord) {
        return StringUtils.equals((CharSequence)"Y", (CharSequence)this.chargeRecordDao.getCscReturnHandleResult(chargeRecord));
    }

    private boolean csrefundChargeRecordHandle(ChargeRecord chargeRecord) throws Exception {
        boolean result = false;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>>>>> start csrefundChargeRecordHandle >>>>>>>>>> ");
            this.logger.debug(" ChargeRecord : " + JsonConvertUtils.convertToString(chargeRecord));
        }
        if (this.checkToCsrefundChargeRecord(chargeRecord)) {
            boolean needCsrefund = false;
            if (this.checkCscReturnHandleResult(chargeRecord)) {
                needCsrefund = true;
            }
            String enterUserType = chargeRecord.getEnterUserType();
            String enterUserId = chargeRecord.getEnterUserId();
            Double chargeMoney = DoubleUtils.defaultIfNegValue(chargeRecord.getChargeMoney(), 0.0, 0.0);
            Double totalReturnMoney = DoubleUtils.defaultIfNegValue(chargeRecord.getReturnMoney(), 0.0, 0.0);
            Double income = DoubleUtils.defaultIfNegValue(chargeRecord.getIncome(), 0.0, 0.0);
            Double serviceMoney = DoubleUtils.defaultIfNegValue(chargeRecord.getServiceMoney(), 0.0, 0.0);
            Double incomeExService = DoubleUtils.defaultIfNegValue(chargeRecord.getIncomeExService(), 0.0, 0.0);
            Double csrefundMoney = 0.0;
            if (needCsrefund) {
                if (chargeMoney >= totalReturnMoney) {
                    csrefundMoney = new BigDecimal(chargeMoney - totalReturnMoney).setScale(2, 4).doubleValue();
                    totalReturnMoney = chargeMoney;
                    if (incomeExService.compareTo(0.0) > 0 && StringUtils.equals((CharSequence)EB_TRANSIT_USERTYPE, (CharSequence)enterUserType) && StringUtils.equals((CharSequence)EB_TRANSIT_USERID, (CharSequence)enterUserId)) {
                        List<ChargeRecordIncomeDetailInfo> cridInfoList = this.chargeRecordIncomeDetailDao.getChargeRecordIncomeDetailInfoList(chargeRecord.getChargeRecordId());
                        for (ChargeRecordIncomeDetailInfo cridInfo : cridInfoList) {
                            TradeOrderRefundRequest distRefundRequest = new TradeOrderRefundRequest();
                            distRefundRequest.setOrderId(cridInfo.getDistTradeOrderId());
                            distRefundRequest.setRefundNo(UUID.randomUUID().toString().replaceAll("-", "").toLowerCase());
                            distRefundRequest.setRefundMoney(cridInfo.getDistMoney());
                            TradeOrderRefundResponse distRefundResponse = this.tradeOrderService.refundTradeOrder(distRefundRequest);
                            if (distRefundResponse.isSuccess()) {
                                TradeOrderRefundDo distTradeOrderRefund = distRefundResponse.getTradeOrderRefund();
                                String csrefundDistRefundNo = distRefundResponse.getTradeOrderRefund().getRefundNo();
                                cridInfo.setCsrefundResult("S");
                                cridInfo.setCsrefundMoney(distRefundRequest.getRefundMoney());
                                cridInfo.setCsrefundTime(new Date());
                                cridInfo.setCsrefundTradeOrderId(csrefundDistRefundNo);
                                if (RefundResultEnum.REFUND_SUCCESS.getResult().equals(distTradeOrderRefund.getRefundResult())) {
                                    cridInfo.setCsrefundResult("S");
                                    cridInfo.setCsrefundSuccessTime(new Date());
                                } else if (RefundResultEnum.REFUND_FAILURE.getResult().equals(distTradeOrderRefund.getRefundResult())) {
                                    cridInfo.setCsrefundResult("F");
                                }
                            } else {
                                cridInfo.setCsrefundResult("F");
                                cridInfo.setCsrefundMoney(distRefundRequest.getRefundMoney());
                                cridInfo.setCsrefundTime(new Date());
                                cridInfo.setCsrefundTradeOrderId(null);
                                cridInfo.setCsrefundSuccessTime(null);
                            }
                            this.chargeRecordIncomeDetailDao.updateChargeRecordIncomeDetailInfo(cridInfo);
                        }
                    }
                    if (serviceMoney.compareTo(0.0) > 0 && StringUtils.equals((CharSequence)EB_TRANSIT_USERTYPE, (CharSequence)enterUserType) && StringUtils.equals((CharSequence)EB_TRANSIT_USERID, (CharSequence)enterUserId)) {
                        TradeOrderRefundRequest serviceRefundRequest = new TradeOrderRefundRequest();
                        serviceRefundRequest.setOrderId(chargeRecord.getServiceTradeOrderId());
                        serviceRefundRequest.setRefundNo(UUID.randomUUID().toString().replaceAll("-", "").toLowerCase());
                        serviceRefundRequest.setRefundMoney(serviceMoney);
                        TradeOrderRefundResponse serviceRefundResponse = this.tradeOrderService.refundTradeOrder(serviceRefundRequest);
                        if (serviceRefundResponse.isSuccess()) {
                            String csrefundServiceRefundNo = serviceRefundResponse.getTradeOrderRefund().getRefundNo();
                            chargeRecord.setCsrefundTradeOrderId(csrefundServiceRefundNo);
                        }
                    }
                    TradeOrderRefundRequest chargeRefundRequest = new TradeOrderRefundRequest();
                    chargeRefundRequest.setOrderId(chargeRecord.getChargeTradeOrderId());
                    chargeRefundRequest.setRefundNo(UUID.randomUUID().toString().replaceAll("-", "").toLowerCase());
                    chargeRefundRequest.setRefundMoney(income);
                    TradeOrderRefundResponse chargeRefundResponse = this.tradeOrderService.refundTradeOrder(chargeRefundRequest);
                    if (chargeRefundResponse.isSuccess()) {
                        TradeOrderRefundDo csrefundRefund = chargeRefundResponse.getTradeOrderRefund();
                        String csrefundRefundNo = csrefundRefund.getRefundNo();
                        chargeRecord.setCsrefundResult("S");
                        chargeRecord.setCsrefundMoney(csrefundMoney);
                        chargeRecord.setTotalReturnMoney(totalReturnMoney);
                        chargeRecord.setCsrefundTime(new Date());
                        chargeRecord.setCsrefundTradeOrderId(csrefundRefundNo);
                        if (RefundResultEnum.REFUND_NOTIFY_WAITING.getResult().equals(csrefundRefund.getRefundResult())) {
                            chargeRecord.setCsrefundResult("T");
                        } else if (RefundResultEnum.REFUND_SUCCESS.getResult().equals(csrefundRefund.getRefundResult())) {
                            chargeRecord.setCsrefundResult("S");
                        } else if (RefundResultEnum.REFUND_FAILURE.getResult().equals(csrefundRefund.getRefundResult())) {
                            chargeRecord.setCsrefundResult("F");
                        }
                    } else {
                        chargeRecord.setCsrefundResult("F");
                        chargeRecord.setCsrefundMoney(csrefundMoney);
                        chargeRecord.setTotalReturnMoney(totalReturnMoney);
                        chargeRecord.setCsrefundTime(new Date());
                    }
                } else {
                    chargeRecord.setCsrefundResult("F");
                    chargeRecord.setCsrefundMoney(csrefundMoney);
                    chargeRecord.setCsrefundTime(new Date());
                    chargeRecord.setRemark(StringUtils.isNotBlank((CharSequence)chargeRecord.getRemark()) ? chargeRecord.getRemark() + "\n\u5df2\u7ecf\u9000\u6b3e" : chargeRecord.getRemark());
                }
            } else {
                chargeRecord.setCsrefundResult("F");
                chargeRecord.setCsrefundMoney(csrefundMoney);
                chargeRecord.setCsrefundTime(new Date());
                chargeRecord.setRemark(StringUtils.isNotBlank((CharSequence)chargeRecord.getRemark()) ? chargeRecord.getRemark() + "\n\u4e0d\u4e88\u9000\u6b3e" : chargeRecord.getRemark());
            }
            this.chargeRecordDao.finshCsrefundChargeRecord(chargeRecord);
            result = true;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" <<<<<<<<<<< end csrefundChargeRecordHandle <<<<<<<<<<< ");
        }
        return result;
    }

    private class CsrefundChargeRecordHandleThread
    extends Thread {
        private CsrefundChargeRecordHandleThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (true) {
                    ChargeRecord chargeRecord;
                    if ((chargeRecord = (ChargeRecord)CscWorkorderRefundHandleTask.this.csrefundLinkedQueue.poll()) == null) {
                        ConcurrentLinkedQueue concurrentLinkedQueue = CscWorkorderRefundHandleTask.this.csrefundLinkedQueue;
                        synchronized (concurrentLinkedQueue) {
                            CscWorkorderRefundHandleTask.this.csrefundLinkedQueue.wait(100L);
                            continue;
                        }
                    }
                    if (CscWorkorderRefundHandleTask.this.logger.isInfoEnabled()) {
                        CscWorkorderRefundHandleTask.this.logger.info(" csrefund charge record handle : " + chargeRecord.toString());
                    }
                    boolean b = false;
                    try {
                        b = CscWorkorderRefundHandleTask.this.csrefundChargeRecordHandle(chargeRecord);
                    }
                    catch (Exception e) {
                        CscWorkorderRefundHandleTask.this.logger.error(e.getMessage(), e.fillInStackTrace());
                        TimeUnit.SECONDS.sleep(60L);
                    }
                    if (!b || !CscWorkorderRefundHandleTask.this.logger.isInfoEnabled()) continue;
                    CscWorkorderRefundHandleTask.this.logger.info(" csrefund charge record finish : " + chargeRecord.toString());
                }
            }
            catch (InterruptedException _ie) {
                CscWorkorderRefundHandleTask.this.logger.error(_ie.getMessage(), _ie.fillInStackTrace());
                return;
            }
        }
    }

    private class CsrefundHandleChargeRecordScanThread
    extends Thread {
        private CsrefundHandleChargeRecordScanThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    List list;
                    while (true) {
                        list = null;
                        try {
                            list = CscWorkorderRefundHandleTask.this.lockTobeCsrefundChargeRecordList();
                        }
                        catch (Exception e) {
                            CscWorkorderRefundHandleTask.this.logger.error(e.getMessage(), e.fillInStackTrace());
                        }
                        if (!CollectionUtils.sizeIsEmptyIgnoreNull(list)) break;
                        TimeUnit.SECONDS.sleep(60L);
                    }
                    ConcurrentLinkedQueue concurrentLinkedQueue = CscWorkorderRefundHandleTask.this.csrefundLinkedQueue;
                    synchronized (concurrentLinkedQueue) {
                        for (ChargeRecord chargeRecord : list) {
                            if (CscWorkorderRefundHandleTask.this.logger.isInfoEnabled()) {
                                CscWorkorderRefundHandleTask.this.logger.info(" csrefund charge record scan   : " + chargeRecord.toString());
                            }
                            CscWorkorderRefundHandleTask.this.csrefundLinkedQueue.offer(chargeRecord);
                        }
                        CscWorkorderRefundHandleTask.this.csrefundLinkedQueue.notifyAll();
                    }
                }
                catch (InterruptedException _ie) {
                    CscWorkorderRefundHandleTask.this.logger.error(_ie.getMessage(), _ie.fillInStackTrace());
                    return;
                }
            }
        }
    }
}

