/*
 * Decompiled with CFR 0.152.
 */
package cn.yunrui.mqttclient.ebikesrv.handletask;

import cn.yunrui.mqttclient.ebikesrv.common.utils.CollectionUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.cache.ChargeRecordCache;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargeRecord;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.service.EBikeChargeService;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartChargeRetryHandleTask {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ConcurrentLinkedQueue<ChargeRecord> linkedQueue = new ConcurrentLinkedQueue();
    private static final int INTERVAL_WAIT = 7;
    private Thread startChargeRetryScanThread;
    private Thread startChargeRetryHandleThread;
    @Resource(name="chargeRecordCache")
    private ChargeRecordCache chargeRecordCache;
    @Resource(name="ebikeChargeService")
    private EBikeChargeService ebikeChargeService;

    @PostConstruct
    public void init() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start init StartChargeRetryHandleTask >>>>>> ");
        }
        this.startChargeRetryScanThread = new StartChargeRetryScanThread();
        this.startChargeRetryScanThread.setDaemon(true);
        this.startChargeRetryScanThread.start();
        this.startChargeRetryHandleThread = new StartChargeRetryHandleThread();
        this.startChargeRetryHandleThread.setDaemon(true);
        this.startChargeRetryHandleThread.start();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" <<<<<<< end init StartChargeRetryHandleTask <<<<<<< ");
        }
    }

    @PreDestroy
    public void destroy() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start destroy StartChargeRetryHandleTask >>>>>> ");
        }
        if (this.startChargeRetryScanThread != null) {
            try {
                this.startChargeRetryScanThread.join();
            }
            catch (InterruptedException _ie) {
                this.logger.error(_ie.getMessage(), _ie.fillInStackTrace());
            }
        }
        if (this.startChargeRetryHandleThread != null) {
            try {
                this.startChargeRetryHandleThread.join();
            }
            catch (InterruptedException _ie) {
                this.logger.error(_ie.getMessage(), _ie.fillInStackTrace());
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" <<<<<<< end destroy StartChargeRetryHandleTask <<<<<<< ");
        }
    }

    private List<ChargeRecord> getBeReopeningChargeRecordList() {
        List<ChargeRecord> chargeRecordList = this.chargeRecordCache.getBeReopeningChargeRecordList();
        if (CollectionUtils.sizeIsNotEmptyIgnoreNull(chargeRecordList)) {
            this.chargeRecordCache.lockBeReopeningChargeRecordList(chargeRecordList);
        }
        return chargeRecordList;
    }

    private class StartChargeRetryHandleThread
    extends Thread {
        private StartChargeRetryHandleThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (true) {
                    ChargeRecord chargeRecord;
                    if ((chargeRecord = (ChargeRecord)StartChargeRetryHandleTask.this.linkedQueue.poll()) == null) {
                        ConcurrentLinkedQueue concurrentLinkedQueue = StartChargeRetryHandleTask.this.linkedQueue;
                        synchronized (concurrentLinkedQueue) {
                            StartChargeRetryHandleTask.this.linkedQueue.wait(100L);
                            continue;
                        }
                    }
                    if (StartChargeRetryHandleTask.this.logger.isInfoEnabled()) {
                        StartChargeRetryHandleTask.this.logger.info(" start charge retry handle : " + chargeRecord.toString());
                    }
                    if (!StringUtils.isNotBlank((CharSequence)chargeRecord.getDeviceId()) || !StringUtils.isNotBlank((CharSequence)chargeRecord.getPlugId())) continue;
                    Map<String, Object> valueMap = StartChargeRetryHandleTask.this.chargeRecordCache.getChargeRecordMap(chargeRecord.getDeviceId(), chargeRecord.getPlugId());
                    Double remainElecCons = (Double)valueMap.get("remainElecCons");
                    long remainTime = Math.round((Double)valueMap.get("remainTime"));
                    if (remainTime > 999L) {
                        remainTime = 999L;
                    }
                    String msg2Device = "start#" + chargeRecord.getPlugId() + "#" + Math.round(remainElecCons * 1000.0) + "#" + remainTime;
                    StartChargeRetryHandleTask.this.logger.info("=======\u91cd\u8bd5\u4efb\u52a1-----------------\u5f00\u59cb\u5145\u7535\u62a5\u6587========= : " + msg2Device);
                    valueMap.put("reopeningFlag", "N");
                    valueMap.put("reopens", (Integer)valueMap.get("reopens") + 1);
                    StartChargeRetryHandleTask.this.chargeRecordCache.updateChargeRecord(chargeRecord.getDeviceId(), chargeRecord.getPlugId(), valueMap);
                    StartChargeRetryHandleTask.this.ebikeChargeService.publish2device(chargeRecord.getDeviceId(), msg2Device, "start");
                }
            }
            catch (InterruptedException _ie) {
                StartChargeRetryHandleTask.this.logger.error(_ie.getMessage(), _ie.fillInStackTrace());
                return;
            }
        }
    }

    private class StartChargeRetryScanThread
    extends Thread {
        private StartChargeRetryScanThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    List list;
                    while (CollectionUtils.sizeIsEmptyIgnoreNull(list = StartChargeRetryHandleTask.this.getBeReopeningChargeRecordList())) {
                        TimeUnit.SECONDS.sleep(7L);
                    }
                    ConcurrentLinkedQueue concurrentLinkedQueue = StartChargeRetryHandleTask.this.linkedQueue;
                    synchronized (concurrentLinkedQueue) {
                        for (ChargeRecord chargeRecord : list) {
                            if (StartChargeRetryHandleTask.this.logger.isInfoEnabled()) {
                                StartChargeRetryHandleTask.this.logger.info(" start charge retry scan   : " + chargeRecord.toString());
                            }
                            StartChargeRetryHandleTask.this.linkedQueue.offer(chargeRecord);
                        }
                        StartChargeRetryHandleTask.this.linkedQueue.notifyAll();
                    }
                }
                catch (InterruptedException _ie) {
                    StartChargeRetryHandleTask.this.logger.error(_ie.getMessage(), _ie.fillInStackTrace());
                    return;
                }
            }
        }
    }
}

