/*
 * Decompiled with CFR 0.152.
 */
package cn.yunrui.mqttclient.ebikesrv.handletask;

import cn.yunrui.mqttclient.ebikesrv.common.utils.CollectionUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.IntegerUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.cache.ChargeRecordCache;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargeRecord;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.service.EBikeChargeService;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartChargeTimeoutHandleTask {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ConcurrentLinkedQueue<ChargeRecord> linkedQueue = new ConcurrentLinkedQueue();
    private static final int INTERVAL_WAIT = 30;
    private Thread startChargeTimeoutScanThread;
    private Thread startChargeTimeoutHandleThread;
    @Resource(name="chargeRecordCache")
    private ChargeRecordCache chargeRecordCache;
    @Resource(name="ebikeChargeService")
    private EBikeChargeService ebikeChargeService;

    @PostConstruct
    public void init() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start init StartChargeTimeoutHandleTask >>>>>> ");
        }
        this.startChargeTimeoutScanThread = new StartChargeTimeoutScanThread();
        this.startChargeTimeoutScanThread.setDaemon(true);
        this.startChargeTimeoutScanThread.start();
        this.startChargeTimeoutHandleThread = new StartChargeTimeoutHandleThread();
        this.startChargeTimeoutHandleThread.setDaemon(true);
        this.startChargeTimeoutHandleThread.start();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" <<<<<<< end init StartChargeTimeoutHandleTask <<<<<<< ");
        }
    }

    @PreDestroy
    public void destroy() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start destroy StartChargeTimeoutHandleTask >>>>>> ");
        }
        if (this.startChargeTimeoutScanThread != null) {
            try {
                this.startChargeTimeoutScanThread.join();
            }
            catch (InterruptedException _ie) {
                this.logger.error(_ie.getMessage(), _ie.fillInStackTrace());
            }
        }
        if (this.startChargeTimeoutHandleThread != null) {
            try {
                this.startChargeTimeoutHandleThread.join();
            }
            catch (InterruptedException _ie) {
                this.logger.error(_ie.getMessage(), _ie.fillInStackTrace());
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" <<<<<<< end destroy StartChargeTimeoutHandleTask <<<<<<< ");
        }
    }

    private List<ChargeRecord> getWaitingStartTimeoutChargeRecordList() {
        List<ChargeRecord> chargeRecordList = this.chargeRecordCache.getWaitingStartTimeoutChargeRecordList();
        if (CollectionUtils.sizeIsNotEmptyIgnoreNull(chargeRecordList)) {
            this.chargeRecordCache.lockWaitingTimeoutChargeRecordList(chargeRecordList);
        }
        return chargeRecordList;
    }

    private class StartChargeTimeoutHandleThread
    extends Thread {
        private StartChargeTimeoutHandleThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (true) {
                    ChargeRecord chargeRecord;
                    if ((chargeRecord = (ChargeRecord)StartChargeTimeoutHandleTask.this.linkedQueue.poll()) == null) {
                        ConcurrentLinkedQueue concurrentLinkedQueue = StartChargeTimeoutHandleTask.this.linkedQueue;
                        synchronized (concurrentLinkedQueue) {
                            StartChargeTimeoutHandleTask.this.linkedQueue.wait(100L);
                            continue;
                        }
                    }
                    if (StartChargeTimeoutHandleTask.this.logger.isInfoEnabled()) {
                        StartChargeTimeoutHandleTask.this.logger.info(" start charge timeout handle : " + chargeRecord.toString());
                    }
                    if (!StringUtils.isNotBlank((CharSequence)chargeRecord.getDeviceId()) || !StringUtils.isNotBlank((CharSequence)chargeRecord.getPlugId())) continue;
                    StartChargeTimeoutHandleTask.this.ebikeChargeService.finishChargeRecord(chargeRecord.getDeviceId(), chargeRecord.getPlugId(), chargeRecord.getChargeOpenFlag(), IntegerUtils.parseIntIgnoreIllegal("-99"));
                }
            }
            catch (InterruptedException _ie) {
                StartChargeTimeoutHandleTask.this.logger.error(_ie.getMessage(), _ie.fillInStackTrace());
                return;
            }
        }
    }

    private class StartChargeTimeoutScanThread
    extends Thread {
        private StartChargeTimeoutScanThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    List list;
                    while (CollectionUtils.sizeIsEmptyIgnoreNull(list = StartChargeTimeoutHandleTask.this.getWaitingStartTimeoutChargeRecordList())) {
                        TimeUnit.SECONDS.sleep(30L);
                    }
                    ConcurrentLinkedQueue concurrentLinkedQueue = StartChargeTimeoutHandleTask.this.linkedQueue;
                    synchronized (concurrentLinkedQueue) {
                        for (ChargeRecord chargeRecord : list) {
                            if (StartChargeTimeoutHandleTask.this.logger.isInfoEnabled()) {
                                StartChargeTimeoutHandleTask.this.logger.info(" start charge timeout scan   : " + chargeRecord.toString());
                            }
                            StartChargeTimeoutHandleTask.this.linkedQueue.offer(chargeRecord);
                        }
                        StartChargeTimeoutHandleTask.this.linkedQueue.notifyAll();
                    }
                }
                catch (InterruptedException _ie) {
                    StartChargeTimeoutHandleTask.this.logger.error(_ie.getMessage(), _ie.fillInStackTrace());
                    return;
                }
            }
        }
    }
}

