/*
 * Decompiled with CFR 0.152.
 */
package cn.yunrui.mqttclient.ebikesrv.handletask;

import cn.yunrui.mqttclient.ebikesrv.common.utils.CollectionUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.IntegerUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.cache.ChargeRecordCache;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargeRecord;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.service.EBikeChargeService;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StopChargeTimeoutHandleTask {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ConcurrentLinkedQueue<ChargeRecord> linkedQueue = new ConcurrentLinkedQueue();
    private static final int INTERVAL_WAIT = 30;
    private Thread stopChargeTimeoutScanThread;
    private Thread stopChargeTimeoutHandleThread;
    @Resource(name="chargeRecordCache")
    private ChargeRecordCache chargeRecordCache;
    @Resource(name="ebikeChargeService")
    private EBikeChargeService ebikeChargeService;

    @PostConstruct
    public void init() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start init StopChargeTimeoutHandleTask >>>>>> ");
        }
        this.stopChargeTimeoutScanThread = new StopChargeTimeoutScanThread();
        this.stopChargeTimeoutScanThread.setDaemon(true);
        this.stopChargeTimeoutScanThread.start();
        this.stopChargeTimeoutHandleThread = new StopChargeTimeoutHandleThread();
        this.stopChargeTimeoutHandleThread.setDaemon(true);
        this.stopChargeTimeoutHandleThread.start();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" <<<<<<< end init StopChargeTimeoutHandleTask <<<<<<< ");
        }
    }

    @PreDestroy
    public void destroy() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start destroy StopChargeTimeoutHandleTask >>>>>> ");
        }
        if (this.stopChargeTimeoutScanThread != null) {
            try {
                this.stopChargeTimeoutScanThread.join();
            }
            catch (InterruptedException _ie) {
                this.logger.error(_ie.getMessage(), _ie.fillInStackTrace());
            }
        }
        if (this.stopChargeTimeoutHandleThread != null) {
            try {
                this.stopChargeTimeoutHandleThread.join();
            }
            catch (InterruptedException _ie) {
                this.logger.error(_ie.getMessage(), _ie.fillInStackTrace());
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" <<<<<<< end destroy StopChargeTimeoutHandleTask <<<<<<< ");
        }
    }

    private List<ChargeRecord> getWaitingStopTimeoutChargeRecordList() {
        List<ChargeRecord> chargeRecordList = this.chargeRecordCache.getWaitingStopTimeoutChargeRecordList();
        if (CollectionUtils.sizeIsNotEmptyIgnoreNull(chargeRecordList)) {
            this.chargeRecordCache.lockWaitingTimeoutChargeRecordList(chargeRecordList);
        }
        return chargeRecordList;
    }

    private class StopChargeTimeoutHandleThread
    extends Thread {
        private StopChargeTimeoutHandleThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (true) {
                    ChargeRecord chargeRecord;
                    if ((chargeRecord = (ChargeRecord)StopChargeTimeoutHandleTask.this.linkedQueue.poll()) == null) {
                        ConcurrentLinkedQueue concurrentLinkedQueue = StopChargeTimeoutHandleTask.this.linkedQueue;
                        synchronized (concurrentLinkedQueue) {
                            StopChargeTimeoutHandleTask.this.linkedQueue.wait(100L);
                            continue;
                        }
                    }
                    if (StopChargeTimeoutHandleTask.this.logger.isInfoEnabled()) {
                        StopChargeTimeoutHandleTask.this.logger.info(" stop charge timeout handle : " + chargeRecord.toString());
                    }
                    if (!StringUtils.isNotBlank((CharSequence)chargeRecord.getDeviceId()) || !StringUtils.isNotBlank((CharSequence)chargeRecord.getPlugId())) continue;
                    StopChargeTimeoutHandleTask.this.ebikeChargeService.finishChargeRecord(chargeRecord.getDeviceId(), chargeRecord.getPlugId(), chargeRecord.getChargeOpenFlag(), IntegerUtils.parseIntIgnoreIllegal("-98"));
                }
            }
            catch (InterruptedException _ie) {
                StopChargeTimeoutHandleTask.this.logger.error(_ie.getMessage(), _ie.fillInStackTrace());
                return;
            }
        }
    }

    private class StopChargeTimeoutScanThread
    extends Thread {
        private StopChargeTimeoutScanThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    List list;
                    while (CollectionUtils.sizeIsEmptyIgnoreNull(list = StopChargeTimeoutHandleTask.this.getWaitingStopTimeoutChargeRecordList())) {
                        TimeUnit.SECONDS.sleep(30L);
                    }
                    ConcurrentLinkedQueue concurrentLinkedQueue = StopChargeTimeoutHandleTask.this.linkedQueue;
                    synchronized (concurrentLinkedQueue) {
                        for (ChargeRecord chargeRecord : list) {
                            if (StopChargeTimeoutHandleTask.this.logger.isInfoEnabled()) {
                                StopChargeTimeoutHandleTask.this.logger.info(" stop charge timeout scan   : " + chargeRecord.toString());
                            }
                            StopChargeTimeoutHandleTask.this.linkedQueue.offer(chargeRecord);
                        }
                        StopChargeTimeoutHandleTask.this.linkedQueue.notifyAll();
                    }
                }
                catch (InterruptedException _ie) {
                    StopChargeTimeoutHandleTask.this.logger.error(_ie.getMessage(), _ie.fillInStackTrace());
                    return;
                }
            }
        }
    }
}

