/*
 * Decompiled with CFR 0.152.
 */
package cn.yunrui.mqttclient.ebikesrv.mqttclient.cache;

import cn.yunrui.mqttclient.ebikesrv.common.utils.ArrayUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.CollectionUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.MapUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.ObjectUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.BillingDao;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.ChargeDeviceDao;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.BillingInfo;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargeDeviceOps;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargeDeviceProps;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargePlugProps;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.CostInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChargeDeviceCache {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, ChargeDeviceProps> devicePropsMap = new HashMap<String, ChargeDeviceProps>();
    @Resource(name="chargeDeviceDao")
    private ChargeDeviceDao chargeDeviceDao;
    @Resource(name="billingDao")
    private BillingDao billingDao;

    @PostConstruct
    public void init() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start init ChargeDeviceCache >>>>>> ");
        }
        this.devicePropsMap.clear();
        List<ChargeDeviceProps> cdpList = this.chargeDeviceDao.getAllChargeDevicePropsList();
        if (CollectionUtils.isNotEmpty(cdpList)) {
            for (ChargeDeviceProps cdp : cdpList) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(" put [ " + cdp.getDeviceId() + " ] to cache : " + cdp.toString());
                }
                this.devicePropsMap.put(cdp.getDeviceId(), cdp);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" <<<<<<< end init ChargeDeviceCache <<<<<<< ");
        }
    }

    @PreDestroy
    public void destroy() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start destroy ChargeDeviceCache >>>>>> ");
        }
        this.devicePropsMap.clear();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" <<<<<<< end destroy ChargeDeviceCache <<<<<<< ");
        }
    }

    public ChargeDeviceProps get(String deviceId) {
        ChargeDeviceProps cdp = this.devicePropsMap.get(deviceId);
        if (ObjectUtils.isNull(cdp) && StringUtils.isNotBlank((CharSequence)deviceId)) {
            cdp = this.reload(deviceId);
        }
        return cdp;
    }

    public ChargeDeviceProps reload(String deviceId) {
        if (StringUtils.isNotBlank((CharSequence)deviceId)) {
            this.put(deviceId, this.chargeDeviceDao.getChargeDeviceProps(deviceId));
        }
        return this.devicePropsMap.get(deviceId);
    }

    public void put(String deviceId, ChargeDeviceProps deviceProps) {
        this.devicePropsMap.put(deviceId, deviceProps);
    }

    public void remove(String deviceId) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" remove [ " + deviceId + " ] from cache ");
        }
        this.devicePropsMap.remove(deviceId);
    }

    public void updateOpStatus(String deviceId, String status, String[] plugStatuss) {
        this.chargeDeviceDao.updateOpStatus(deviceId, status, plugStatuss);
        ChargeDeviceProps cdp = this.get(deviceId);
        if (ObjectUtils.isNotNull(cdp)) {
            cdp.setOpStatus(status);
            Map<Integer, ChargePlugProps> plugPropsMap = cdp.getPlugPropsMap();
            if (MapUtils.isNotEmpty(plugPropsMap) && ArrayUtils.isNotEmpty((Object[])plugStatuss) && plugStatuss.length > 0) {
                for (int i = 1; i <= plugStatuss.length; ++i) {
                    ChargePlugProps cpp = plugPropsMap.get(i);
                    String plugStatus = plugStatuss[i - 1];
                    cpp.setOpStatus(plugStatus);
                    cpp.setStatus(this.convertPlugStatus(plugStatus));
                    plugPropsMap.put(i, cpp);
                }
                cdp.setPlugPropsMap(plugPropsMap);
            }
        }
    }

    public void updatePlugStatus(String deviceId, String plugId, String status) {
        Map<Integer, ChargePlugProps> plugPropsMap;
        this.chargeDeviceDao.updatePlugStatus(deviceId, plugId, status);
        ChargeDeviceProps cdp = this.get(deviceId);
        if (ObjectUtils.isNotNull(cdp) && StringUtils.isNotBlank((CharSequence)plugId) && StringUtils.isNotBlank((CharSequence)status) && MapUtils.isNotEmpty(plugPropsMap = cdp.getPlugPropsMap())) {
            try {
                Integer plugSn = Integer.parseInt(plugId);
                ChargePlugProps cpp = plugPropsMap.get(plugSn);
                cpp.setOpStatus(status);
                cpp.setStatus(this.convertPlugStatus(status));
                plugPropsMap.put(plugSn, cpp);
                cdp.setPlugPropsMap(plugPropsMap);
            }
            catch (NumberFormatException _nfe) {
                this.logger.error(_nfe.getMessage(), _nfe.fillInStackTrace());
            }
        }
    }

    public void updateDeviceAssertStatus(String deviceId, String status) {
        this.chargeDeviceDao.updateDeviceAssertStatus(deviceId, status);
        this.put(deviceId, this.chargeDeviceDao.getChargeDeviceProps(deviceId));
    }

    public List<ChargeDeviceOps> getTimeoutChargeDeviceOpsList() {
        return this.chargeDeviceDao.getTimeoutChargeDeviceOpsList();
    }

    public void lockTimeoutChargeDeviceOpsList(List<ChargeDeviceOps> cdoList) {
        this.chargeDeviceDao.lockTimeoutChargeDeviceOpsList(cdoList);
    }

    public BillingInfo getDefaultBillingInfoByDeviceId(String deviceId) {
        return this.billingDao.getDefaultBillingInfoByDeviceId(deviceId);
    }

    public BillingInfo getBillingInfoByDeviceId(String deviceId, String chargeUserId, String cardId) {
        return this.chargeDeviceDao.getBillingInfoByDeviceId(deviceId, chargeUserId, cardId);
    }

    public Integer getCountByDeviceIdAndCardId(String deviceId, String cardId) {
        return this.chargeDeviceDao.getCountByDeviceIdAndCardId(deviceId, cardId);
    }

    public Double getServiceRateByDeviceId(String deviceId) {
        return this.chargeDeviceDao.getServiceRateByDeviceId(deviceId);
    }

    public CostInfo getCostInfoByDeviceId(String deviceId) {
        return this.chargeDeviceDao.getCostInfoByDeviceId(deviceId);
    }

    private String convertPlugStatus(String plugStatus) {
        String result = StringUtils.equals((CharSequence)"1", (CharSequence)plugStatus) ? "U" : (StringUtils.equals((CharSequence)"2", (CharSequence)plugStatus) ? "R" : "F");
        return result;
    }
}

