/*
 * Decompiled with CFR 0.152.
 */
package cn.yunrui.mqttclient.ebikesrv.mqttclient.cache;

import cn.yunrui.mqttclient.ebikesrv.common.utils.CollectionUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.ObjectUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.ChargeCardDao;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.ChargeLoadDao;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.ChargeRecordDao;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargeRecord;
import com.ebikepay.openservices.request.InnerAccountCreateRequest;
import com.ebikepay.openservices.request.InnerAccountLoadRequest;
import com.ebikepay.openservices.request.TradeOrderCreateRequest;
import com.ebikepay.openservices.request.TradeOrderPayRequest;
import com.ebikepay.openservices.response.InnerAccountCreateResponse;
import com.ebikepay.openservices.response.InnerAccountLoadResponse;
import com.ebikepay.openservices.response.TradeOrderCreateResponse;
import com.ebikepay.openservices.response.TradeOrderPayResponse;
import com.ebikepay.openservices.service.InnerAccountService;
import com.ebikepay.openservices.service.TradeOrderService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChargeRecordCache {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, ChargeRecord> chargeRecordMap = new HashMap<String, ChargeRecord>();
    @Resource(name="chargeCardDao")
    private ChargeCardDao chargeCardDao;
    @Resource(name="chargeRecordDao")
    private ChargeRecordDao chargeRecordDao;
    @Resource(name="chargeLoadDao")
    private ChargeLoadDao chargeLoadDao;
    @Resource(name="innerAccountService")
    private InnerAccountService innerAccountService;
    @Resource(name="tradeOrderService")
    private TradeOrderService tradeOrderService;

    @PostConstruct
    public void init() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start init ChargeRecordCache >>>>>> ");
        }
        this.chargeRecordMap.clear();
        List<ChargeRecord> chargeRecordList = this.chargeRecordDao.getBeChargingRecordList();
        if (CollectionUtils.isNotEmpty(chargeRecordList)) {
            for (ChargeRecord chargeRecord : chargeRecordList) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(" put [ " + chargeRecord.getDeviceId() + "_" + chargeRecord.getPlugId() + " ] to cache : " + chargeRecord.toString());
                }
                this.chargeRecordMap.put(chargeRecord.getDeviceId() + "_" + chargeRecord.getPlugId(), chargeRecord);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" <<<<<<< end init ChargeRecordCache <<<<<<< ");
        }
    }

    @PreDestroy
    public void destroy() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start destroy ChargeRecordCache >>>>>> ");
        }
        this.chargeRecordMap.clear();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" <<<<<<< end destroy ChargeRecordCache <<<<<<< ");
        }
    }

    public ChargeRecord get(String deviceId, String plugId) {
        ChargeRecord chargeRecord = this.chargeRecordMap.get(deviceId + "_" + plugId);
        if (ObjectUtils.isNull(chargeRecord) && StringUtils.isNotBlank((CharSequence)deviceId)) {
            chargeRecord = this.reload(deviceId, plugId);
        }
        return chargeRecord;
    }

    public ChargeRecord reload(String deviceId, String plugId) {
        if (StringUtils.isNotBlank((CharSequence)deviceId) && StringUtils.isNotBlank((CharSequence)plugId)) {
            this.put(deviceId, plugId, this.chargeRecordDao.getBeChargingRecordByDeviceIdAndPlugId(deviceId, plugId));
        }
        return this.chargeRecordMap.get(deviceId + "_" + plugId);
    }

    public void put(String deviceId, String plugId, ChargeRecord chargeRecord) {
        this.chargeRecordMap.put(deviceId + "_" + plugId, chargeRecord);
    }

    public int insertChargeRecordByCoinsin(Map<String, Object> chargeRecordMap, String chargeplugNo) {
        return this.chargeRecordDao.insertChargeRecordByCoinsin(chargeRecordMap, chargeplugNo);
    }

    public int insertChargeRecordByCard(Map<String, Object> chargeRecordMap, String chargeplugNo, String cardId) {
        return this.chargeRecordDao.insertChargeRecordByCard(chargeRecordMap, chargeplugNo, cardId);
    }

    public int insertChargeRecordByCustCard(Map<String, Object> chargeRecordMap, String chargeplugNo, String cardId) {
        return this.chargeRecordDao.insertChargeRecordByCustCard(chargeRecordMap, chargeplugNo, cardId);
    }

    public void updateChargeRecord(String deviceId, String plugId, Map<String, Object> valueMap) {
        this.chargeRecordDao.updateChargeRecord(deviceId, plugId, valueMap);
    }

    public void finishChargeRecord(String deviceId, String plugId, Map<String, Object> valueMap) {
        this.chargeRecordDao.finishChargeRecord(deviceId, plugId, valueMap);
    }

    public boolean checkIsCharging(String deviceId, String plugId) {
        return this.chargeRecordDao.checkIsCharging(deviceId, plugId);
    }

    public Map<String, Object> getChargeRecordMap(String deviceId, String plugId) {
        return this.chargeRecordDao.getChargeRecordMap(deviceId, plugId);
    }

    public List<ChargeRecord> getWaitingStartTimeoutChargeRecordList() {
        return this.chargeRecordDao.getWaitingStartTimeoutChargeRecordList();
    }

    public List<ChargeRecord> getWaitingStopTimeoutChargeRecordList() {
        return this.chargeRecordDao.getWaitingStopTimeoutChargeRecordList();
    }

    public void lockWaitingTimeoutChargeRecordList(List<ChargeRecord> chargeRecordList) {
        this.chargeRecordDao.lockWaitingTimeoutChargeRecordList(chargeRecordList);
    }

    public List<ChargeRecord> getBeReopeningChargeRecordList() {
        return this.chargeRecordDao.getBeReopeningChargeRecordList();
    }

    public void lockBeReopeningChargeRecordList(List<ChargeRecord> chargeRecordList) {
        this.chargeRecordDao.lockBeReopeningChargeRecordList(chargeRecordList);
    }

    public ChargeRecord getBeChargingRecord(String chargeRecordId) {
        return this.chargeRecordDao.getBeChargingRecord(chargeRecordId);
    }

    public ChargeRecord getHistroyChargeRecord(String chargeRecordId) {
        return this.chargeRecordDao.getHistroyChargeRecord(chargeRecordId);
    }

    public void saveChargedeviceLoadMap(Map<String, Object> chargedeviceLoadMap) {
        this.chargeLoadDao.saveChargedeviceLoadMap(chargedeviceLoadMap);
    }

    public void saveChargeplugLoadMap(Map<String, Object> chargeplugLoadMap) {
        this.chargeLoadDao.saveChargeplugLoadMap(chargeplugLoadMap);
    }

    public void saveChargeorderLoadMap(Map<String, Object> chargeorderLoadMap) {
        this.chargeLoadDao.saveChargeorderLoadMap(chargeorderLoadMap);
    }

    public String getStatusByCardId(String cardId) {
        return this.chargeCardDao.getStatusByCardId(cardId);
    }

    public Integer getCardTypeByCardId(String cardId) {
        return this.chargeCardDao.getCardTypeByCardId(cardId);
    }

    public String getOrgNoByCustCardId(String cardId) {
        return this.chargeCardDao.getOrgNoByCustCardId(cardId);
    }

    public String getChargeUserIdByCardId(String cardId) {
        return this.chargeCardDao.getChargeUserIdByCardId(cardId);
    }

    public InnerAccountLoadResponse loadInnerAccount(InnerAccountLoadRequest innerAccountLoadRequest) {
        return this.innerAccountService.loadInnerAccount(innerAccountLoadRequest);
    }

    public InnerAccountCreateResponse createInnerAccount(InnerAccountCreateRequest innerAccountCreateRequest) {
        return this.innerAccountService.createInnerAccount(innerAccountCreateRequest);
    }

    public TradeOrderCreateResponse createTradeOrder(TradeOrderCreateRequest tradeOrderCreateRequest) {
        return this.tradeOrderService.createTradeOrder(tradeOrderCreateRequest);
    }

    public TradeOrderPayResponse payTradeOrder(TradeOrderPayRequest tradeOrderPayRequest) {
        return this.tradeOrderService.payTradeOrder(tradeOrderPayRequest);
    }
}

