/*
 * Decompiled with CFR 0.152.
 */
package cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.impl;

import cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.BillingDao;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.BillingInfo;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class BillingDaoImpl
implements BillingDao {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final RowMapper<BillingInfo> biRowMapper = (rs, rowNum) -> {
        BillingInfo bi = new BillingInfo();
        bi.setOrgNo(rs.getString(1));
        bi.setChargestationId(rs.getLong(2));
        bi.setCsbsType(rs.getString(3));
        bi.setSchemeId(rs.getString(4));
        bi.setSchemeType(rs.getString(5));
        bi.setUnitPrice1(rs.getDouble(6));
        bi.setUnitPrice2(rs.getDouble(7));
        bi.setUnitPrice3(rs.getDouble(8));
        bi.setUnitPrice4(rs.getDouble(9));
        bi.setUnitPrice5(rs.getDouble(10));
        bi.setStepCount(rs.getInt(11));
        bi.setStepPower1(rs.getInt(12));
        bi.setStepPower2(rs.getInt(13));
        bi.setStepPower3(rs.getInt(14));
        bi.setStepPower4(rs.getInt(15));
        bi.setMinCharge(rs.getDouble(16));
        bi.setIsReturn(rs.getString(17));
        bi.setClosingPeriod(rs.getInt(18));
        bi.setMaxChargeTime(rs.getInt(19));
        return bi;
    };
    private final JdbcTemplate ebikeJdbcTemplate;

    public BillingDaoImpl(JdbcTemplate ebikeJdbcTemplate) {
        this.ebikeJdbcTemplate = ebikeJdbcTemplate;
    }

    @Override
    public BillingInfo getDefaultBillingInfoByDeviceId(String deviceId) {
        BillingInfo bi;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start getDefaultBillingInfoByDeviceId >>>>>>> ");
            this.logger.debug(" deviceId : " + deviceId);
        }
        StringBuilder sqlBuilder = new StringBuilder();
        ArrayList<String> params = new ArrayList<String>();
        sqlBuilder.append("SELECT acd.subburo, ecd.chargestationId, '00' AS csbsType, bs.schemeId, bs.schemeType, bs.unitPrice1, bs.unitPrice2, bs.unitPrice3, bs.unitPrice4, bs.unitPrice5, bs.stepCount, bs.stepPower1, bs.stepPower2, bs.stepPower3, bs.stepPower4, bs.minCharge, bs.isReturn, bs.closingPeriod, bs.maxChargeTime ");
        sqlBuilder.append("  FROM ebike.ebike_billingscheme bs ");
        sqlBuilder.append(" INNER JOIN ebike.ebike_cs_bs_rela cbr ON cbr.schemeId = bs.schemeId ");
        sqlBuilder.append(" INNER JOIN cisp_dev.dev_ebikechargedevice ecd ON ecd.chargestationId = cbr.chargestationId ");
        sqlBuilder.append(" INNER JOIN ebike.ebike_assets_chargedevice acd ON acd.chargedeviceId = ecd.id ");
        sqlBuilder.append(" WHERE acd.deviceId = ? ");
        params.add(deviceId);
        try {
            bi = (BillingInfo)this.ebikeJdbcTemplate.queryForObject(sqlBuilder.toString(), params.toArray(), this.biRowMapper);
        }
        catch (EmptyResultDataAccessException _erdae) {
            bi = null;
        }
        return bi;
    }
}

