/*
 * Decompiled with CFR 0.152.
 */
package cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.impl;

import cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.ChargeCardDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;

public class ChargeCardDaoImpl
implements ChargeCardDao {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final JdbcTemplate ebikeJdbcTemplate;

    public ChargeCardDaoImpl(JdbcTemplate ebikeJdbcTemplate) {
        this.ebikeJdbcTemplate = ebikeJdbcTemplate;
    }

    @Override
    public String getStatusByCardId(String cardId) {
        String status;
        String sql = "SELECT `status` FROM ebike.card_info WHERE card_id = ? ";
        try {
            status = (String)this.ebikeJdbcTemplate.queryForObject(sql, new Object[]{cardId}, String.class);
        }
        catch (EmptyResultDataAccessException erdae) {
            status = null;
        }
        return status;
    }

    @Override
    public Integer getCardTypeByCardId(String cardId) {
        Integer cardType;
        String sql = "SELECT `card_type` FROM ebike.card_info WHERE card_id = ? ";
        try {
            cardType = (Integer)this.ebikeJdbcTemplate.queryForObject(sql, new Object[]{cardId}, Integer.class);
        }
        catch (EmptyResultDataAccessException erdae) {
            cardType = null;
        }
        return cardType;
    }

    @Override
    public String getOrgNoByCustCardId(String cardId) {
        String orgNo;
        String sql = "SELECT `org_no` FROM ebike.card_info WHERE card_id = ? ";
        try {
            orgNo = (String)this.ebikeJdbcTemplate.queryForObject(sql, new Object[]{cardId}, String.class);
        }
        catch (EmptyResultDataAccessException erdae) {
            orgNo = null;
        }
        return orgNo;
    }

    @Override
    public String getChargeUserIdByCardId(String cardId) {
        String charcgeUserId;
        String sql = "SELECT cu.chargeUserId FROM ebike.card_info ci, ebike.ebike_chargeuser cu WHERE cu.chargeUserNo = ci.charge_user_no AND ci.card_id = ? LIMIT 1 ";
        try {
            charcgeUserId = (String)this.ebikeJdbcTemplate.queryForObject(sql, new Object[]{cardId}, String.class);
        }
        catch (EmptyResultDataAccessException erdae) {
            charcgeUserId = null;
        }
        return charcgeUserId;
    }
}

