/*
 * Decompiled with CFR 0.152.
 */
package cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.impl;

import cn.yunrui.mqttclient.ebikesrv.common.utils.ArrayUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.CollectionUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.DateUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.JsonConvertUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.MapUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.ChargeDeviceDao;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.BillingInfo;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargeDeviceOps;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargeDeviceProps;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargeDeviceProtocolEnum;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargePlugProps;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.CostInfo;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class ChargeDeviceDaoImpl
implements ChargeDeviceDao {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final RowMapper<String> strRowMapper = (rs, rowNum) -> rs.getString(1);
    private final RowMapper<ChargeDeviceOps> cdoRowMapper = (rs, rowNum) -> {
        ChargeDeviceOps cpo = new ChargeDeviceOps();
        cpo.setOrgNo(rs.getString("subburo"));
        cpo.setChargedeviceNo(rs.getString("chargedeviceNo"));
        cpo.setDeviceId(rs.getString("deviceId"));
        cpo.setPlugCount(rs.getInt("plugCount"));
        cpo.setChargedeviceId(rs.getLong("chargedeviceId"));
        cpo.setOpStatus(rs.getString("opStatus"));
        cpo.setLatestCommTime(new Date(rs.getTimestamp("latestCommTime").getTime()));
        return cpo;
    };
    private final RowMapper<ChargeDeviceProps> cdpRowMapper = (rs, rowNum) -> {
        ChargeDeviceProps cdp = new ChargeDeviceProps();
        cdp.setDeviceId(rs.getString("deviceId"));
        cdp.setOrgNo(rs.getString("subburo"));
        cdp.setChargedeviceNo(rs.getString("chargedeviceNo"));
        if (StringUtils.equals((CharSequence)"mqtt.yjm2m", (CharSequence)rs.getString("protocolType"))) {
            if (StringUtils.equals((CharSequence)"201710", (CharSequence)rs.getString("protocolVersion"))) {
                cdp.setChargeDeviceProtocol(ChargeDeviceProtocolEnum.MQTT_YJM2M_201710);
            } else if (StringUtils.equals((CharSequence)"201712", (CharSequence)rs.getString("protocolVersion"))) {
                cdp.setChargeDeviceProtocol(ChargeDeviceProtocolEnum.MQTT_YJM2M_201712);
            } else if (StringUtils.equals((CharSequence)"201801", (CharSequence)rs.getString("protocolVersion"))) {
                cdp.setChargeDeviceProtocol(ChargeDeviceProtocolEnum.MQTT_YJM2M_201801);
            } else if (StringUtils.equals((CharSequence)"201804", (CharSequence)rs.getString("protocolVersion"))) {
                cdp.setChargeDeviceProtocol(ChargeDeviceProtocolEnum.MQTT_YJM2M_201804);
            } else {
                cdp.setChargeDeviceProtocol(ChargeDeviceProtocolEnum.UNKNOWN);
            }
        } else if (StringUtils.equals((CharSequence)"mqtt.ebike", (CharSequence)rs.getString("protocolType"))) {
            if (StringUtils.equals((CharSequence)"201804", (CharSequence)rs.getString("protocolVersion"))) {
                cdp.setChargeDeviceProtocol(ChargeDeviceProtocolEnum.MQTT_EBIKE_201804);
            } else if (StringUtils.equals((CharSequence)"201805", (CharSequence)rs.getString("protocolVersion"))) {
                cdp.setChargeDeviceProtocol(ChargeDeviceProtocolEnum.MQTT_EBIKE_201805);
            } else {
                cdp.setChargeDeviceProtocol(ChargeDeviceProtocolEnum.UNKNOWN);
            }
        } else {
            cdp.setChargeDeviceProtocol(ChargeDeviceProtocolEnum.UNKNOWN);
        }
        cdp.setFactory(rs.getString("factory"));
        cdp.setModelNo(rs.getString("modelNo"));
        cdp.setPlugCount(rs.getInt("plugCount"));
        cdp.setOpStatus(rs.getString("opStatus"));
        if (rs.getTimestamp("latestCommTime") != null) {
            cdp.setLatestCommTime(new Date(rs.getTimestamp("latestCommTime").getTime()));
        }
        cdp.setStatus(rs.getString("status"));
        cdp.setChargedeviceId(rs.getLong("chargedeviceId"));
        if (rs.getTimestamp("importTime") != null) {
            cdp.setImportTime(new Date(rs.getTimestamp("importTime").getTime()));
        }
        if (rs.getTimestamp("installTime") != null) {
            cdp.setInstallTime(new Date(rs.getTimestamp("installTime").getTime()));
        }
        if (rs.getTimestamp("runTime") != null) {
            cdp.setRunTime(new Date(rs.getTimestamp("runTime").getTime()));
        }
        if (rs.getTimestamp("dismantleTime") != null) {
            cdp.setDismantleTime(new Date(rs.getTimestamp("dismantleTime").getTime()));
        }
        cdp.setMqttBrokerHostIp(rs.getString("mqttBrokerHostIp"));
        cdp.setMqttBrokerHostPort(rs.getString("mqttBrokerHostPort"));
        cdp.setServerSubTopic(rs.getString("serverSubTopic"));
        String deviceParams = rs.getString("deviceParams");
        if (StringUtils.isNotBlank((CharSequence)deviceParams)) {
            Map attachParamsMap;
            Map paramsMap;
            Map deviceParamsMap = JsonConvertUtils.convertFromString(Map.class, deviceParams);
            if (deviceParamsMap != null && deviceParamsMap.get("params") != null && (paramsMap = (Map)deviceParamsMap.get("params")) != null) {
                cdp.setParamsMap(paramsMap);
            }
            if (deviceParamsMap != null && deviceParamsMap.get("attachParams") != null && (attachParamsMap = (Map)deviceParamsMap.get("attachParams")) != null) {
                cdp.setAttachParamsMap(attachParamsMap);
            }
        }
        cdp.setChargestationId(rs.getLong("chargestationId"));
        cdp.setBillingSchemeId(rs.getString("schemeId"));
        cdp.setBillingSchemeType(rs.getString("schemeType"));
        cdp.setBillingUnitPrice1(rs.getDouble("unitPrice1"));
        cdp.setBillingUnitPrice2(rs.getDouble("unitPrice2"));
        cdp.setBillingUnitPrice3(rs.getDouble("unitPrice3"));
        cdp.setMinChargeMoney(rs.getDouble("minCharge"));
        cdp.setIsReturn(rs.getString("isReturn"));
        HashMap<Integer, ChargePlugProps> plugPropsMap = new HashMap<Integer, ChargePlugProps>();
        List<ChargePlugProps> cppList = this.getChargePlugPropsList(cdp.getDeviceId());
        for (ChargePlugProps cpp : cppList) {
            plugPropsMap.put(cpp.getPlugSn(), cpp);
        }
        if (MapUtils.isNotEmpty(plugPropsMap)) {
            cdp.setPlugPropsMap(plugPropsMap);
        }
        return cdp;
    };
    private final RowMapper<ChargePlugProps> cppRowMapper = (rs, rowNum) -> {
        ChargePlugProps cpp = new ChargePlugProps();
        cpp.setDeviceId(rs.getString("deviceId"));
        cpp.setPlugId(rs.getString("plugId"));
        cpp.setChargeplugId(rs.getLong("chargeplugId"));
        cpp.setPlugSn(rs.getInt("plugSn"));
        cpp.setOpStatus(rs.getString("opStatus"));
        if (rs.getTimestamp("opStatusTime") != null) {
            cpp.setOpStatusTime(new Date(rs.getTimestamp("opStatusTime").getTime()));
        }
        cpp.setStatus(rs.getString("status"));
        return cpp;
    };
    private final RowMapper<BillingInfo> biRowMapper = (rs, rowNum) -> {
        BillingInfo bi = new BillingInfo();
        bi.setOrgNo(rs.getString(1));
        bi.setChargestationId(rs.getLong(2));
        bi.setCsbsType(rs.getString(3));
        bi.setSchemeId(rs.getString(4));
        bi.setSchemeType(rs.getString(5));
        bi.setUnitPrice1(rs.getDouble(6));
        bi.setUnitPrice2(rs.getDouble(7));
        bi.setUnitPrice3(rs.getDouble(8));
        bi.setUnitPrice4(rs.getDouble(9));
        bi.setUnitPrice5(rs.getDouble(10));
        bi.setStepCount(rs.getInt(11));
        bi.setStepPower1(rs.getInt(12));
        bi.setStepPower2(rs.getInt(13));
        bi.setStepPower3(rs.getInt(14));
        bi.setStepPower4(rs.getInt(15));
        bi.setMinCharge(rs.getDouble(16));
        bi.setIsReturn(rs.getString(17));
        bi.setClosingPeriod(rs.getInt(18));
        bi.setMaxChargeTime(rs.getInt(19));
        return bi;
    };
    private final RowMapper<CostInfo> ciRowMapper = (rs, rowNum) -> {
        CostInfo ci = new CostInfo();
        ci.setOrgNo(rs.getString(1));
        ci.setCostSchemeId(rs.getString(2));
        ci.setCostSchemeNo(rs.getString(3));
        ci.setCostSchemeName(rs.getString(4));
        ci.setCostUnitPrice(rs.getDouble(5));
        return ci;
    };
    private final JdbcTemplate ebikeJdbcTemplate;

    private StringBuilder builderChargeDeviceOpsPreSQL() {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("SELECT eac.buro, eac.subburo, eac.chargedeviceNo, eac.deviceId, eac.plugCount, eco.chargedeviceId, eco.opStatus, eco.latestCommTime ");
        sqlBuilder.append("  FROM ebike.ebike_chargedevice_ops eco ");
        sqlBuilder.append(" INNER JOIN ebike.ebike_assets_chargedevice eac ON eac.chargedeviceId = eco.chargedeviceId ");
        return sqlBuilder;
    }

    private StringBuilder builderChargeDevicePropsPreSQL() {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("SELECT eac.buro, eac.subburo, eac.chargedeviceNo, eac.deviceId, eac.protocolType, eac.protocolVersion, eac.plugCount, eac.factory, eac.modelNo ");
        sqlBuilder.append("     , eac.`status`, eac.chargedeviceId, eac.importTime, eac.installTime, eac.runTime, eac.dismantleTime, eac.mqttBrokerHostIp, eac.mqttBrokerHostPort, eac.serverSubTopic ");
        sqlBuilder.append("     , ops.opStatus, ops.latestCommTime, ecd.deviceParams ");
        sqlBuilder.append("     , ecd.chargestationId, ebs.schemeId, ebs.schemeType, ebs.unitPrice1, ebs.unitPrice2, ebs.unitPrice3, ebs.minCharge, ebs.isReturn ");
        sqlBuilder.append("  FROM ebike.ebike_assets_chargedevice eac ");
        sqlBuilder.append("  LEFT JOIN ebike.ebike_chargedevice_ops ops ON ops.chargedeviceId = eac.chargedeviceId ");
        sqlBuilder.append("  LEFT JOIN cisp_dev.dev_ebikechargedevice ecd ON ecd.id = eac.chargedeviceId ");
        sqlBuilder.append("  LEFT JOIN ebike.ebike_cs_bs_rela cbr ON cbr.chargestationId = ecd.chargestationId ");
        sqlBuilder.append("  LEFT JOIN ebike.ebike_billingscheme ebs ON ebs.schemeId = cbr.schemeId ");
        return sqlBuilder;
    }

    private StringBuilder builderChargePlugPropsPreSQL() {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("SELECT ecd.deviceId, ecp.plugId, ecd.chargedeviceNo, ecp.plugSn, CASE ops.opStatus WHEN '1' THEN 'U' WHEN '2' THEN 'R' ELSE 'F' END AS `status`, ecd.`id` AS chargedeviceId, ecp.`id` AS chargeplugId, ops.opStatus, ops.opStatusTime ");
        sqlBuilder.append("  FROM cisp_dev.dev_ebikechargeplug ecp ");
        sqlBuilder.append(" INNER JOIN cisp_dev.dev_ebikechargedevice ecd ON ecd.`id` = ecp.chargedeviceId ");
        sqlBuilder.append("  LEFT JOIN ebike.ebike_chargeplug_ops ops ON ops.chargeplugId = ecp.`id` ");
        return sqlBuilder;
    }

    public ChargeDeviceDaoImpl(JdbcTemplate ebikeJdbcTemplate) {
        this.ebikeJdbcTemplate = ebikeJdbcTemplate;
    }

    @Override
    public List<ChargeDeviceOps> getTimeoutChargeDeviceOpsList() {
        StringBuilder sqlBuilder = this.builderChargeDeviceOpsPreSQL();
        ArrayList<Object> params = new ArrayList<Object>();
        sqlBuilder.append(" WHERE eco.opStatus = ? ");
        params.add("1");
        sqlBuilder.append("   AND eco.latestCommTime < ? ");
        params.add(DateUtils.addMinutes(new Date(), -30));
        return this.ebikeJdbcTemplate.query(sqlBuilder.toString(), params.toArray(), this.cdoRowMapper);
    }

    @Override
    public void lockTimeoutChargeDeviceOpsList(final List<ChargeDeviceOps> cdoList) {
        if (CollectionUtils.sizeIsNotEmptyIgnoreNull(cdoList)) {
            String sql = "UPDATE ebike.ebike_chargedevice_ops cdo SET cdo.opStatus = '2' WHERE cdo.opStatus = '1' AND cdo.chargedeviceId = ? ";
            this.ebikeJdbcTemplate.batchUpdate(sql, new BatchPreparedStatementSetter(){

                public int getBatchSize() {
                    return cdoList.size();
                }

                public void setValues(PreparedStatement ps, int romNum) throws SQLException {
                    ChargeDeviceOps cdo = (ChargeDeviceOps)cdoList.get(romNum);
                    ps.setLong(1, cdo.getChargedeviceId());
                }
            });
        }
    }

    @Override
    public List<ChargeDeviceProps> getAllChargeDevicePropsList() {
        return this.getChargeDevicePropsList(null, null);
    }

    @Override
    public List<String> getNewUpdatedDeviceIds(Date lastLoadTime) {
        StringBuilder sqlBuilder = new StringBuilder();
        ArrayList<Date> params = new ArrayList<Date>();
        sqlBuilder.append("SELECT eac.deviceId ");
        sqlBuilder.append("  FROM ebike.ebike_assets_chargedevice eac ");
        sqlBuilder.append("  LEFT JOIN cisp_dev.dev_ebikechargedevice ecd ON ecd.id = eac.chargedeviceId ");
        sqlBuilder.append("  LEFT JOIN ebike.ebike_cs_bs_rela cbr ON cbr.chargestationId = ecd.chargestationId ");
        sqlBuilder.append("  LEFT JOIN ebike.ebike_billingscheme ebs ON ebs.schemeId = cbr.schemeId ");
        sqlBuilder.append(" WHERE eac.importTime >= ? ");
        params.add(lastLoadTime);
        sqlBuilder.append("    OR eac.installTime >= ? ");
        params.add(lastLoadTime);
        sqlBuilder.append("    OR eac.runTime >= ? ");
        params.add(lastLoadTime);
        sqlBuilder.append("    OR eac.dismantleTime >= ? ");
        params.add(lastLoadTime);
        sqlBuilder.append("    OR cbr.effTime >= ? ");
        params.add(lastLoadTime);
        sqlBuilder.append("    OR ebs.updateTime >= ? ");
        params.add(lastLoadTime);
        return this.ebikeJdbcTemplate.query(sqlBuilder.toString(), params.toArray(), this.strRowMapper);
    }

    @Override
    public List<ChargeDeviceProps> getChargeDevicePropsList(Map<String, Object> paramsMap, List<String> ordersList) {
        StringBuilder sqlBuilder = this.builderChargeDevicePropsPreSQL();
        ArrayList<Object> params = new ArrayList<Object>();
        sqlBuilder.append(" WHERE 1 = 1 ");
        if (MapUtils.isNotEmpty(paramsMap)) {
            for (String key : paramsMap.keySet()) {
                sqlBuilder.append("   AND ").append(key).append(" = ? ");
                params.add(paramsMap.get(key));
            }
        }
        if (ordersList != null && ordersList.size() > 0) {
            sqlBuilder.append(" ORDER BY ");
            int idx = 0;
            for (String orders : ordersList) {
                if (idx > 0) {
                    sqlBuilder.append(", ");
                }
                sqlBuilder.append(orders);
                ++idx;
            }
        }
        return this.ebikeJdbcTemplate.query(sqlBuilder.toString(), params.toArray(), this.cdpRowMapper);
    }

    @Override
    public ChargeDeviceProps getChargeDeviceProps(String deviceId) {
        if (StringUtils.isNotBlank((CharSequence)deviceId)) {
            ChargeDeviceProps cdp;
            StringBuilder sqlBuilder = this.builderChargeDevicePropsPreSQL();
            ArrayList<String> params = new ArrayList<String>();
            sqlBuilder.append(" WHERE eac.deviceId = ? ");
            params.add(deviceId);
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("sql       : " + sqlBuilder.toString());
                    this.logger.debug("params    : " + Arrays.toString(params.toArray()));
                }
                cdp = (ChargeDeviceProps)this.ebikeJdbcTemplate.queryForObject(sqlBuilder.toString(), params.toArray(), this.cdpRowMapper);
            }
            catch (EmptyResultDataAccessException _erdae) {
                cdp = null;
            }
            return cdp;
        }
        return null;
    }

    @Override
    public ChargeDeviceProps getChargeDevicePropsByChargedeviceNo(String orgNo, String chargedeviceNo) {
        if (StringUtils.isNotBlank((CharSequence)orgNo) && StringUtils.isNotBlank((CharSequence)chargedeviceNo)) {
            ChargeDeviceProps cdp;
            StringBuilder sqlBuilder = this.builderChargeDevicePropsPreSQL();
            ArrayList<String> params = new ArrayList<String>();
            sqlBuilder.append(" WHERE eac.buro = ? AND eac.subburo = ? AND eac.chargedeviceNo = ? ");
            params.add(orgNo);
            params.add(orgNo);
            params.add(chargedeviceNo);
            try {
                cdp = (ChargeDeviceProps)this.ebikeJdbcTemplate.queryForObject(sqlBuilder.toString(), params.toArray(), this.cdpRowMapper);
            }
            catch (EmptyResultDataAccessException _erdae) {
                cdp = null;
            }
            return cdp;
        }
        return null;
    }

    @Override
    public List<ChargePlugProps> getChargePlugPropsList(String deviceId) {
        if (StringUtils.isNotBlank((CharSequence)deviceId)) {
            StringBuilder sqlBuilder = this.builderChargePlugPropsPreSQL();
            ArrayList<String> params = new ArrayList<String>();
            sqlBuilder.append(" WHERE ecd.deviceId = ? ");
            params.add(deviceId);
            return this.ebikeJdbcTemplate.query(sqlBuilder.toString(), params.toArray(), this.cppRowMapper);
        }
        return null;
    }

    @Override
    public ChargePlugProps getChargePlugProps(String deviceId, String plugId) {
        if (StringUtils.isNotBlank((CharSequence)deviceId) && StringUtils.isNotBlank((CharSequence)plugId)) {
            ChargePlugProps cpp;
            StringBuilder sqlBuilder = this.builderChargePlugPropsPreSQL();
            ArrayList<Object> params = new ArrayList<Object>();
            sqlBuilder.append(" WHERE ecd.deviceId = ? AND ecp.plugSn = ? ");
            params.add(deviceId);
            try {
                params.add(Integer.parseInt(plugId));
            }
            catch (NumberFormatException _nfe) {
                this.logger.error(_nfe.getMessage(), _nfe.fillInStackTrace());
                params.add(0);
            }
            try {
                cpp = (ChargePlugProps)this.ebikeJdbcTemplate.queryForObject(sqlBuilder.toString(), params.toArray(), this.cppRowMapper);
            }
            catch (EmptyResultDataAccessException _erdae) {
                cpp = null;
            }
            return cpp;
        }
        return null;
    }

    @Override
    public ChargePlugProps getChargePlugPropsByChargedeviceNo(String orgNo, String chargedeviceNo, Integer plugSn) {
        return null;
    }

    @Override
    public void updateOpStatus(final String deviceId, String status, final String[] plugStatus) {
        String sql;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> updateOpStatus >>>>>> ");
            this.logger.debug(" deviceId   : " + deviceId);
            this.logger.debug(" status     : " + status);
            this.logger.debug(" plugStatus : " + ArrayUtils.toString((Object)plugStatus));
        }
        if (StringUtils.equals((CharSequence)"1", (CharSequence)status)) {
            sql = "INSERT INTO ebike.ebike_chargedevice_ops(chargedeviceId, opStatus, firstCommTime, latestCommTime) SELECT ecd.id, ?, IFNULL(eco.firstCommTime, ?), ? FROM cisp_dev.dev_ebikechargedevice ecd   LEFT JOIN ebike.ebike_chargedevice_ops eco ON eco.chargedeviceId = ecd.id  WHERE ecd.deviceId = ? ON DUPLICATE KEY UPDATE opStatus = VALUES(opStatus), firstCommTime = VALUES(firstCommTime), latestCommTime = VALUES(latestCommTime) ";
            this.ebikeJdbcTemplate.update(sql, new Object[]{status, new Date(), new Date(), deviceId});
        } else {
            sql = "INSERT INTO ebike.ebike_chargedevice_ops(chargedeviceId, opStatus) SELECT ecd.id, ? FROM cisp_dev.dev_ebikechargedevice ecd   LEFT JOIN ebike.ebike_chargedevice_ops eco ON eco.chargedeviceId = ecd.id  WHERE ecd.deviceId = ? ON DUPLICATE KEY UPDATE opStatus = VALUES(opStatus) ";
            this.ebikeJdbcTemplate.update(sql, new Object[]{status, deviceId});
        }
        if (plugStatus != null && plugStatus.length > 0) {
            final Date d = new Date();
            String sql2 = "INSERT INTO ebike.ebike_chargeplug_ops(chargeplugId, opStatus, opStatusTime) SELECT ecp.id, ?, ? FROM cisp_dev.dev_ebikechargeplug ecp  INNER JOIN cisp_dev.dev_ebikechargedevice ecd ON ecd.id = ecp.chargedeviceId   LEFT JOIN ebike.ebike_chargeplug_ops eco ON eco.chargeplugId = ecp.id  WHERE ecd.deviceId = ? AND ecp.plugSn = ? ON DUPLICATE KEY UPDATE opStatus = VALUES(opStatus), opStatusTime = VALUES(opStatusTime) ";
            this.ebikeJdbcTemplate.batchUpdate(sql2, new BatchPreparedStatementSetter(){

                public int getBatchSize() {
                    return plugStatus.length;
                }

                public void setValues(PreparedStatement ps, int i) throws SQLException {
                    ps.setString(1, plugStatus[i]);
                    ps.setTimestamp(2, new Timestamp(d.getTime()));
                    ps.setString(3, deviceId);
                    ps.setInt(4, i + 1);
                }
            });
        }
    }

    @Override
    public void updatePlugStatus(String deviceId, String plugId, String status) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> updatePlugStatus >>>>>> ");
            this.logger.debug(" deviceId : " + deviceId);
            this.logger.debug(" plugId   : " + plugId);
            this.logger.debug(" status   : " + status);
        }
        String sql = "INSERT INTO ebike.ebike_chargeplug_ops(chargeplugId, opStatus, opStatusTime) SELECT ecp.id, ?, ? FROM cisp_dev.dev_ebikechargeplug ecp  INNER JOIN cisp_dev.dev_ebikechargedevice ecd ON ecd.id = ecp.chargedeviceId   LEFT JOIN ebike.ebike_chargeplug_ops eco ON eco.chargeplugId = ecp.id  WHERE ecd.deviceId = ? AND ecp.plugSn = ? ON DUPLICATE KEY UPDATE opStatus = VALUES(opStatus), opStatusTime = VALUES(opStatusTime) ";
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(status);
        params.add(new Date());
        params.add(deviceId);
        try {
            params.add(Integer.parseInt(plugId));
        }
        catch (NumberFormatException _nfe) {
            this.logger.error(_nfe.getMessage(), _nfe.fillInStackTrace());
            params.add(0);
        }
        this.ebikeJdbcTemplate.update(sql, params.toArray());
    }

    @Override
    public void updateDeviceAssertStatus(String deviceId, String status) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> updateDeviceAssertStatus >>>>>> ");
            this.logger.debug(" deviceId : " + deviceId);
            this.logger.debug(" status   : " + status);
        }
        if (StringUtils.isNotBlank((CharSequence)deviceId) && StringUtils.isNotBlank((CharSequence)status)) {
            StringBuilder sqlBuilder = new StringBuilder();
            ArrayList<Object> params = new ArrayList<Object>();
            sqlBuilder.append("UPDATE ebike.ebike_assets_chargedevice eac ");
            sqlBuilder.append("   SET eac.`status` = ? ");
            params.add(status);
            if (StringUtils.equals((CharSequence)"03", (CharSequence)status)) {
                sqlBuilder.append("     , eac.runTime = ? ");
                params.add(new Date());
                sqlBuilder.append("     , eac.dismantleTime = NULL ");
            }
            sqlBuilder.append(" WHERE eac.deviceId = ? ");
            params.add(deviceId);
            if (StringUtils.equals((CharSequence)"03", (CharSequence)status)) {
                sqlBuilder.append("   AND eac.`status` = '02' ");
            }
            this.ebikeJdbcTemplate.update(sqlBuilder.toString(), params.toArray());
        }
    }

    @Override
    public BillingInfo getBillingInfoByDeviceId(String deviceId, String chargeUserId, String cardId) {
        BillingInfo bi;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start getBillingInfoByDeviceId >>>>>>> ");
            this.logger.debug(" deviceId     : " + deviceId);
            this.logger.debug(" chargeUserId : " + chargeUserId);
            this.logger.debug(" cardId       : " + cardId);
        }
        StringBuilder sqlBuilder1 = new StringBuilder();
        ArrayList<String> params1 = new ArrayList<String>();
        sqlBuilder1.append("SELECT acd.subburo, ecd.chargestationId, '00' AS csbsType, bs.schemeId, bs.schemeType, bs.unitPrice1, bs.unitPrice2, bs.unitPrice3, bs.unitPrice4, bs.unitPrice5, bs.stepCount, bs.stepPower1, bs.stepPower2, bs.stepPower3, bs.stepPower4, bs.minCharge, bs.isReturn, bs.closingPeriod, bs.maxChargeTime ");
        sqlBuilder1.append("  FROM ebike.ebike_billingscheme bs ");
        sqlBuilder1.append(" INNER JOIN ebike.ebike_csbs_info cbi ON cbi.schemeId = bs.schemeId ");
        sqlBuilder1.append(" INNER JOIN ebike.ebike_csbs_info_userlist cbiul ON cbiul.csbsUsersListId = cbi.csbsUsersListId ");
        sqlBuilder1.append(" INNER JOIN ebike.ebike_chargeuser cu ON cu.chargeUserMobile = cbiul.csbsUserMobile ");
        sqlBuilder1.append(" INNER JOIN cisp_dev.dev_ebikechargedevice ecd ON ecd.chargestationId = cbi.chargestationId AND cbi.csbsType = '01' AND cbi.csbsStatus IN ('00', '02', '03') ");
        sqlBuilder1.append(" INNER JOIN ebike.ebike_assets_chargedevice acd ON acd.chargedeviceId = ecd.id ");
        sqlBuilder1.append(" WHERE acd.deviceId = ? AND cu.chargeUserId = ? ");
        sqlBuilder1.append(" LIMIT 1 ");
        params1.add(deviceId);
        params1.add(chargeUserId);
        try {
            bi = (BillingInfo)this.ebikeJdbcTemplate.queryForObject(sqlBuilder1.toString(), params1.toArray(), this.biRowMapper);
        }
        catch (EmptyResultDataAccessException erdae) {
            bi = null;
        }
        if (bi == null) {
            StringBuilder sqlBuilder2 = new StringBuilder();
            ArrayList<String> params2 = new ArrayList<String>();
            sqlBuilder2.append("SELECT acd.subburo, ecd.chargestationId, '00' AS csbsType, bs.schemeId, bs.schemeType, bs.unitPrice1, bs.unitPrice2, bs.unitPrice3, bs.unitPrice4, bs.unitPrice5, bs.stepCount, bs.stepPower1, bs.stepPower2, bs.stepPower3, bs.stepPower4, bs.minCharge, bs.isReturn, bs.closingPeriod, bs.maxChargeTime ");
            sqlBuilder2.append("  FROM ebike.ebike_billingscheme bs ");
            sqlBuilder2.append(" INNER JOIN ebike.ebike_cs_bs_rela cbr ON cbr.schemeId = bs.schemeId ");
            sqlBuilder2.append(" INNER JOIN cisp_dev.dev_ebikechargedevice ecd ON ecd.chargestationId = cbr.chargestationId ");
            sqlBuilder2.append(" INNER JOIN ebike.ebike_assets_chargedevice acd ON acd.chargedeviceId = ecd.id ");
            sqlBuilder2.append(" WHERE acd.deviceId = ? AND cbr.disabled = 'F' ");
            sqlBuilder2.append(" LIMIT 1 ");
            params2.add(deviceId);
            try {
                bi = (BillingInfo)this.ebikeJdbcTemplate.queryForObject(sqlBuilder2.toString(), params2.toArray(), this.biRowMapper);
            }
            catch (EmptyResultDataAccessException erdae) {
                bi = null;
            }
        }
        return bi;
    }

    @Override
    public int getCountByDeviceIdAndCardId(String deviceId, String cardId) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start getCountByDeviceIdAndCardId >>>>>>> ");
            this.logger.debug(" deviceId     : " + deviceId);
            this.logger.debug(" cardId       : " + cardId);
        }
        int count = 0;
        StringBuilder sqlBuilder1 = new StringBuilder();
        ArrayList<String> params1 = new ArrayList<String>();
        sqlBuilder1.append("SELECT COUNT(*) AS CNT ");
        sqlBuilder1.append("  FROM ebike.card_info ci ");
        sqlBuilder1.append(" INNER JOIN ebike.card_custom_purchase_apply_relacs ccpar ON ccpar.purchase_apply_id = ci.purchase_apply_id ");
        sqlBuilder1.append(" INNER JOIN cisp_dev.dev_ebikechargedevice ecd ON ecd.chargestationId = ccpar.chargestation_id ");
        sqlBuilder1.append(" INNER JOIN ebike.ebike_assets_chargedevice acd ON acd.chargedeviceId = ecd.id ");
        sqlBuilder1.append(" WHERE ci.card_id = ? AND acd.deviceId = ? ");
        params1.add(deviceId);
        params1.add(cardId);
        try {
            count = (Integer)this.ebikeJdbcTemplate.queryForObject(sqlBuilder1.toString(), params1.toArray(), Integer.class);
        }
        catch (EmptyResultDataAccessException erdae) {
            count = 0;
        }
        return count;
    }

    @Override
    public Double getServiceRateByDeviceId(String deviceId) {
        Double serviceRate;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("deviceId  : " + deviceId);
        }
        String sql = "SELECT IFNULL(ecc.serviceRate, IFNULL(oo.serviceRate, 0.0)) AS serviceRate   FROM cisp_dev.dev_ebikechargestation ecs  INNER JOIN cisp_dev.dev_powersystemresource pss ON pss.id = ecs.id AND pss.className = 'EBikeChargeStation'   LEFT JOIN ebike.ebike_orgopr oo ON oo.subburo = pss.subburo   LEFT JOIN ebike.ebike_cssr_config ecc ON ecc.chargestationId = ecs.id  INNER JOIN cisp_dev.dev_ebikechargedevice ecd ON ecd.chargestationId = ecs.id  WHERE ecd.deviceId = ?  LIMIT 1 ";
        try {
            serviceRate = (Double)this.ebikeJdbcTemplate.queryForObject(sql, new Object[]{deviceId}, Double.class);
        }
        catch (EmptyResultDataAccessException erdae) {
            serviceRate = 0.0;
        }
        return serviceRate;
    }

    @Override
    public CostInfo getCostInfoByDeviceId(String deviceId) {
        CostInfo ci;
        StringBuilder sqlBuilder = new StringBuilder();
        ArrayList<String> params = new ArrayList<String>();
        sqlBuilder.append("SELECT ecs.subburo, ecs.costSchemeId, ecs.costSchemeNo, ecs.costSchemeName, ecs.costUnitPrice ");
        sqlBuilder.append("  FROM ebike.ebike_costscheme ecs ");
        sqlBuilder.append(" INNER JOIN ebike.ebike_cs_cs_rela ccr ON ccr.costSchemeId = ecs.costSchemeId ");
        sqlBuilder.append(" INNER JOIN cisp_dev.dev_ebikechargedevice ecd ON ecd.chargestationId = ccr.chargestationId ");
        sqlBuilder.append(" INNER JOIN cisp_dev.dev_powersystemresource pss ON pss.`id` = ecd.`id` AND pss.className = 'EBikeChargeDevice' ");
        sqlBuilder.append(" WHERE ecd.deviceId = ? ");
        params.add(deviceId);
        sqlBuilder.append(" LIMIT 1 ");
        try {
            ci = (CostInfo)this.ebikeJdbcTemplate.queryForObject(sqlBuilder.toString(), params.toArray(), this.ciRowMapper);
        }
        catch (EmptyResultDataAccessException erdae) {
            ci = null;
        }
        return ci;
    }
}

