/*
 * Decompiled with CFR 0.152.
 */
package cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.impl;

import cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.ChargeLoadDao;
import cn.yunrui.mqttclient.ebikesrv.tablestore.TableStoreTemplate;
import com.alicloud.openservices.tablestore.model.Column;
import com.alicloud.openservices.tablestore.model.ColumnValue;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.PrimaryKeyBuilder;
import com.alicloud.openservices.tablestore.model.PrimaryKeyValue;
import com.alicloud.openservices.tablestore.model.PutRowRequest;
import com.alicloud.openservices.tablestore.model.RowPutChange;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class ChargeLoadDaoImpl
implements ChargeLoadDao {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final JdbcTemplate ebikeJdbcTemplate;
    private final TableStoreTemplate ebikeTableStoreTemplate;

    public ChargeLoadDaoImpl(JdbcTemplate ebikeJdbcTemplate, TableStoreTemplate ebikeTableStoreTemplate) {
        this.ebikeJdbcTemplate = ebikeJdbcTemplate;
        this.ebikeTableStoreTemplate = ebikeTableStoreTemplate;
    }

    @Override
    public void saveChargedeviceLoadMap(Map<String, Object> chargedeviceLoadMap) {
        long timestamp = new Date().getTime();
        PrimaryKeyBuilder primaryKeyBuilder = PrimaryKeyBuilder.createPrimaryKeyBuilder();
        primaryKeyBuilder.addPrimaryKeyColumn("CHGDEVICENO", PrimaryKeyValue.fromString((String)((String)chargedeviceLoadMap.get("CHGDEVICENO"))));
        primaryKeyBuilder.addPrimaryKeyColumn("LOADTIME", PrimaryKeyValue.fromString((String)((String)chargedeviceLoadMap.get("LOADTIME"))));
        PrimaryKey primaryKey = primaryKeyBuilder.build();
        RowPutChange rowPutChange = new RowPutChange("LOAD_CHG_DEVICE", primaryKey);
        rowPutChange.addColumn(new Column("DEVICEID", ColumnValue.fromString((String)((String)chargedeviceLoadMap.get("DEVICEID"))), timestamp));
        rowPutChange.addColumn(new Column("PLUG_COUNT", ColumnValue.fromLong((long)((Integer)chargedeviceLoadMap.get("PLUG_COUNT")).intValue()), timestamp));
        rowPutChange.addColumn(new Column("SUM_LOADVALUE", ColumnValue.fromDouble((double)((Double)chargedeviceLoadMap.get("SUM_LOADVALUE"))), timestamp));
        Integer plugCount = (Integer)chargedeviceLoadMap.get("PLUG_COUNT");
        if (plugCount != null && plugCount > 0) {
            for (int i = 1; i <= plugCount && i < 100; ++i) {
                rowPutChange.addColumn(new Column("P" + String.format("%02d", i) + "_LOADVALUE", ColumnValue.fromDouble((double)((Double)chargedeviceLoadMap.get("P" + String.format("%02d", i) + "_LOADVALUE"))), timestamp));
            }
        }
        PutRowRequest putRowRequest = new PutRowRequest(rowPutChange);
        this.ebikeTableStoreTemplate.putRowSync(putRowRequest);
        BigDecimal curPower = new BigDecimal(chargedeviceLoadMap.get("SUM_LOADVALUE") != null ? chargedeviceLoadMap.get("SUM_LOADVALUE").toString() : "0.0");
        Date curPowerTime = new Date();
        Long chargedeviceId = (Long)chargedeviceLoadMap.get("CHGDEVICEID");
        String sql = "UPDATE ebike.ebike_chargedevice_ops SET curPower = ?, curPowerTime = ? WHERE chargedeviceId = ? ";
        this.ebikeJdbcTemplate.update(sql, new Object[]{curPower, curPowerTime, chargedeviceId});
    }

    @Override
    public void saveChargeplugLoadMap(Map<String, Object> chargeplugLoadMap) {
        long timestamp = new Date().getTime();
        PrimaryKeyBuilder primaryKeyBuilder = PrimaryKeyBuilder.createPrimaryKeyBuilder();
        primaryKeyBuilder.addPrimaryKeyColumn("CHGPLUGNO", PrimaryKeyValue.fromString((String)((String)chargeplugLoadMap.get("CHGPLUGNO"))));
        primaryKeyBuilder.addPrimaryKeyColumn("LOADTIME", PrimaryKeyValue.fromString((String)((String)chargeplugLoadMap.get("LOADTIME"))));
        PrimaryKey primaryKey = primaryKeyBuilder.build();
        RowPutChange rowPutChange = new RowPutChange("LOAD_CHG_PLUG", primaryKey);
        rowPutChange.addColumn(new Column("LOADVALUE", ColumnValue.fromDouble((double)((Double)chargeplugLoadMap.get("LOADVALUE"))), timestamp));
        PutRowRequest putRowRequest = new PutRowRequest(rowPutChange);
        this.ebikeTableStoreTemplate.putRowSync(putRowRequest);
        BigDecimal curPower = new BigDecimal(chargeplugLoadMap.get("LOADVALUE") != null ? chargeplugLoadMap.get("LOADVALUE").toString() : "0.0");
        Date curPowerTime = new Date();
        String chargeplugNo = (String)chargeplugLoadMap.get("CHGPLUGNO");
        String sql = "UPDATE ebike.ebike_chargeplug_ops ops INNER JOIN cisp_dev.dev_ebikechargeplug ecp ON ecp.id = ops.chargeplugId SET ops.curPower = ?, ops.curPowerTime = ? WHERE ecp.chargeplugNo = ? ";
        this.ebikeJdbcTemplate.update(sql, new Object[]{curPower, curPowerTime, chargeplugNo});
    }

    @Override
    public void saveChargeorderLoadMap(Map<String, Object> chargeorderLoadMap) {
        long timestamp = new Date().getTime();
        PrimaryKeyBuilder primaryKeyBuilder = PrimaryKeyBuilder.createPrimaryKeyBuilder();
        primaryKeyBuilder.addPrimaryKeyColumn("CHGORDERNO", PrimaryKeyValue.fromString((String)((String)chargeorderLoadMap.get("CHGORDERNO"))));
        primaryKeyBuilder.addPrimaryKeyColumn("LOADTIME", PrimaryKeyValue.fromString((String)((String)chargeorderLoadMap.get("LOADTIME"))));
        PrimaryKey primaryKey = primaryKeyBuilder.build();
        RowPutChange rowPutChange = new RowPutChange("LOAD_CHG_ORDER", primaryKey);
        rowPutChange.addColumn(new Column("LOADVALUE", ColumnValue.fromDouble((double)((Double)chargeorderLoadMap.get("LOADVALUE"))), timestamp));
        PutRowRequest putRowRequest = new PutRowRequest(rowPutChange);
        this.ebikeTableStoreTemplate.putRowSync(putRowRequest);
    }
}

