/*
 * Decompiled with CFR 0.152.
 */
package cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.impl;

import cn.yunrui.mqttclient.ebikesrv.common.utils.JsonConvertUtils;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.ChargeRecordIncomeDetailDao;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargeRecordIncomeDetailInfo;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class ChargeRecordIncomeDetailDaoImpl
implements ChargeRecordIncomeDetailDao {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final RowMapper<ChargeRecordIncomeDetailInfo> cridInfoRowMapper = (rs, rowNum) -> {
        ChargeRecordIncomeDetailInfo cridInfo = new ChargeRecordIncomeDetailInfo();
        cridInfo.setChargeRecordId(rs.getString("chargeRecordId"));
        cridInfo.setDistSn(rs.getInt("distSn"));
        cridInfo.setDistUserType(rs.getString("distUserType"));
        cridInfo.setDistUserId(rs.getString("distUserId"));
        cridInfo.setDistRatio(rs.getDouble("distRatio"));
        cridInfo.setDistMoney(rs.getDouble("distMoney"));
        cridInfo.setDistTime(rs.getTimestamp("distTime"));
        cridInfo.setDistDesc(rs.getString("distDesc"));
        cridInfo.setDistFlag(rs.getString("distFlag"));
        cridInfo.setDistTradeOrderId(rs.getString("distTradeOrderId"));
        cridInfo.setDistSuccessTime(rs.getTimestamp("distSuccessTime"));
        cridInfo.setCsrefundResult(rs.getString("csrefundResult"));
        cridInfo.setCsrefundMoney(rs.getDouble("csrefundMoney"));
        cridInfo.setCsrefundTime(rs.getTimestamp("csrefundTime"));
        cridInfo.setCsrefundTradeOrderId(rs.getString("csrefundTradeOrderId"));
        cridInfo.setCsrefundSuccessTime(rs.getTimestamp("csrefundSuccessTime"));
        return cridInfo;
    };
    private final JdbcTemplate ebikeJdbcTemplate;

    public ChargeRecordIncomeDetailDaoImpl(JdbcTemplate ebikeJdbcTemplate) {
        this.ebikeJdbcTemplate = ebikeJdbcTemplate;
    }

    @Override
    public void createChargeRecordIncomeDetailInfoList(final List<ChargeRecordIncomeDetailInfo> cridInfoList) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>>>>> start createChargeRecordIncomeDetailInfoList >>>>>>>>>> ");
            this.logger.debug(" cridInfoList : " + JsonConvertUtils.convertToString(cridInfoList));
        }
        if (cridInfoList != null && cridInfoList.size() > 0) {
            String sql = "INSERT INTO ebike.ebike_chargerecord_incomedetail(chargeRecordId, distSn, distUserType, distUserId, distRatio, distMoney, distTime, distDesc, distFlag, distTradeOrderId, distSuccessTime) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ";
            this.ebikeJdbcTemplate.batchUpdate(sql, new BatchPreparedStatementSetter(){

                public int getBatchSize() {
                    return cridInfoList.size();
                }

                public void setValues(PreparedStatement ps, int i) throws SQLException {
                    ps.setString(1, ((ChargeRecordIncomeDetailInfo)cridInfoList.get(i)).getChargeRecordId());
                    ps.setInt(2, ((ChargeRecordIncomeDetailInfo)cridInfoList.get(i)).getDistSn());
                    ps.setString(3, ((ChargeRecordIncomeDetailInfo)cridInfoList.get(i)).getDistUserType());
                    ps.setString(4, ((ChargeRecordIncomeDetailInfo)cridInfoList.get(i)).getDistUserId());
                    ps.setDouble(5, ((ChargeRecordIncomeDetailInfo)cridInfoList.get(i)).getDistRatio());
                    ps.setDouble(6, ((ChargeRecordIncomeDetailInfo)cridInfoList.get(i)).getDistMoney());
                    ps.setTimestamp(7, ((ChargeRecordIncomeDetailInfo)cridInfoList.get(i)).getDistTime() != null ? new Timestamp(((ChargeRecordIncomeDetailInfo)cridInfoList.get(i)).getDistTime().getTime()) : null);
                    ps.setString(8, ((ChargeRecordIncomeDetailInfo)cridInfoList.get(i)).getDistDesc());
                    ps.setString(9, ((ChargeRecordIncomeDetailInfo)cridInfoList.get(i)).getDistFlag());
                    ps.setString(10, ((ChargeRecordIncomeDetailInfo)cridInfoList.get(i)).getDistTradeOrderId());
                    ps.setTimestamp(11, ((ChargeRecordIncomeDetailInfo)cridInfoList.get(i)).getDistTime() != null ? new Timestamp(((ChargeRecordIncomeDetailInfo)cridInfoList.get(i)).getDistTime().getTime()) : null);
                }
            });
        }
    }

    @Override
    public void updateChargeRecordIncomeDetailInfoList(final List<ChargeRecordIncomeDetailInfo> cridInfoList) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>>>>> start updateChargeRecordIncomeDetailInfoList >>>>>>>>>> ");
            this.logger.debug(" cridInfoList : " + JsonConvertUtils.convertToString(cridInfoList));
        }
        if (cridInfoList != null && cridInfoList.size() > 0) {
            String sql = "UPDATE ebike.ebike_chargerecord_incomedetail SET distDesc = ?, distFlag = ?, distTradeOrderId = ?, distSuccessTime = ?, csrefundResult = ?, csrefundMoney = ?, csrefundTime = ?, csrefundTradeOrderId = ?, csrefundSuccessTime = ? WHERE chargeRecordId = ? AND distSn = ? ";
            this.ebikeJdbcTemplate.batchUpdate(sql, new BatchPreparedStatementSetter(){

                public int getBatchSize() {
                    return cridInfoList.size();
                }

                public void setValues(PreparedStatement ps, int i) throws SQLException {
                    ps.setString(1, ((ChargeRecordIncomeDetailInfo)cridInfoList.get(i)).getDistDesc());
                    ps.setString(2, ((ChargeRecordIncomeDetailInfo)cridInfoList.get(i)).getDistFlag());
                    ps.setString(3, ((ChargeRecordIncomeDetailInfo)cridInfoList.get(i)).getDistTradeOrderId());
                    ps.setTimestamp(4, ((ChargeRecordIncomeDetailInfo)cridInfoList.get(i)).getDistTime() != null ? new Timestamp(((ChargeRecordIncomeDetailInfo)cridInfoList.get(i)).getDistTime().getTime()) : null);
                    ps.setString(5, ((ChargeRecordIncomeDetailInfo)cridInfoList.get(i)).getCsrefundResult());
                    if (((ChargeRecordIncomeDetailInfo)cridInfoList.get(i)).getCsrefundMoney() != null) {
                        ps.setDouble(6, ((ChargeRecordIncomeDetailInfo)cridInfoList.get(i)).getCsrefundMoney());
                    } else {
                        ps.setObject(6, null);
                    }
                    ps.setTimestamp(7, ((ChargeRecordIncomeDetailInfo)cridInfoList.get(i)).getCsrefundTime() != null ? new Timestamp(((ChargeRecordIncomeDetailInfo)cridInfoList.get(i)).getCsrefundTime().getTime()) : null);
                    ps.setString(8, ((ChargeRecordIncomeDetailInfo)cridInfoList.get(i)).getCsrefundTradeOrderId());
                    ps.setTimestamp(9, ((ChargeRecordIncomeDetailInfo)cridInfoList.get(i)).getCsrefundSuccessTime() != null ? new Timestamp(((ChargeRecordIncomeDetailInfo)cridInfoList.get(i)).getCsrefundSuccessTime().getTime()) : null);
                    ps.setString(10, ((ChargeRecordIncomeDetailInfo)cridInfoList.get(i)).getChargeRecordId());
                    ps.setInt(11, ((ChargeRecordIncomeDetailInfo)cridInfoList.get(i)).getDistSn());
                }
            });
        }
    }

    @Override
    public void updateChargeRecordIncomeDetailInfo(ChargeRecordIncomeDetailInfo cridInfo) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>>>>> start updateChargeRecordIncomeDetailInfo >>>>>>>>>> ");
            this.logger.debug(" cridInfoList : " + JsonConvertUtils.convertToString(cridInfo));
        }
        if (cridInfo != null) {
            String sqlUpdate = "UPDATE ebike.ebike_chargerecord_incomedetail SET distDesc = ?, distFlag = ?, distTradeOrderId = ?, distSuccessTime = ?, csrefundResult = ?, csrefundMoney = ?, csrefundTime = ?, csrefundTradeOrderId = ?, csrefundSuccessTime = ? WHERE chargeRecordId = ? AND distSn = ? ";
            ArrayList<Object> paramsUpdate = new ArrayList<Object>();
            paramsUpdate.add(cridInfo.getDistDesc());
            paramsUpdate.add(cridInfo.getDistFlag());
            paramsUpdate.add(cridInfo.getDistTradeOrderId());
            paramsUpdate.add(cridInfo.getDistSuccessTime());
            paramsUpdate.add(cridInfo.getCsrefundResult());
            paramsUpdate.add(cridInfo.getCsrefundMoney());
            paramsUpdate.add(cridInfo.getCsrefundTime());
            paramsUpdate.add(cridInfo.getCsrefundTradeOrderId());
            paramsUpdate.add(cridInfo.getCsrefundSuccessTime());
            paramsUpdate.add(cridInfo.getChargeRecordId());
            paramsUpdate.add(cridInfo.getDistSn());
            this.ebikeJdbcTemplate.update(sqlUpdate, paramsUpdate.toArray());
        }
    }

    @Override
    public List<ChargeRecordIncomeDetailInfo> getChargeRecordIncomeDetailInfoList(String chargeRecordId) {
        String sql = "SELECT * FROM ebike.ebike_chargerecord_incomedetail WHERE chargeRecordId = ? ORDER BY distSn ";
        return this.ebikeJdbcTemplate.query(sql, new Object[]{chargeRecordId}, this.cridInfoRowMapper);
    }

    @Override
    public ChargeRecordIncomeDetailInfo getChargeRecordIncomeDetailInfo(String chargeRecordId, Integer distSn) {
        ChargeRecordIncomeDetailInfo cridInfo;
        String sql = "SELECT * FROM ebike.ebike_chargerecord_incomedetail WHERE chargeRecordId = ? AND distSn = ? ";
        try {
            cridInfo = (ChargeRecordIncomeDetailInfo)this.ebikeJdbcTemplate.queryForObject(sql, new Object[]{chargeRecordId, distSn}, this.cridInfoRowMapper);
        }
        catch (EmptyResultDataAccessException _erdae) {
            cridInfo = null;
        }
        return cridInfo;
    }

    @Override
    public ChargeRecordIncomeDetailInfo getChargeRecordIncomeDetailInfoByTradeOrderId(String distTradeOrderId) {
        ChargeRecordIncomeDetailInfo cridInfo;
        String sql = "SELECT * FROM ebike.ebike_chargerecord_incomedetail WHERE distTradeOrderId = ? LIMIT 1 ";
        try {
            cridInfo = (ChargeRecordIncomeDetailInfo)this.ebikeJdbcTemplate.queryForObject(sql, new Object[]{distTradeOrderId}, this.cridInfoRowMapper);
        }
        catch (EmptyResultDataAccessException _erdae) {
            cridInfo = null;
        }
        return cridInfo;
    }
}

