/*
 * Decompiled with CFR 0.152.
 */
package cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.impl;

import cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.CsshDistschemeDao;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.CsshDistSchemeInfo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class CsshDistschemeDaoImpl
implements CsshDistschemeDao {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final RowMapper<CsshDistSchemeInfo> cdsInfoRowMapper = (rs, rowNum) -> {
        CsshDistSchemeInfo cdsInfo = new CsshDistSchemeInfo();
        cdsInfo.setCsshDistSchemeId(rs.getString("csshDistSchemeId"));
        cdsInfo.setChargestationId(rs.getLong("chargestationId"));
        cdsInfo.setOrgoprOrgNo(rs.getString("orgoprOrgNo"));
        cdsInfo.setStakeholderOrgNo(rs.getString("stakeholderOrgNo"));
        cdsInfo.setCsshdsStatus(rs.getString("csshdsStatus"));
        cdsInfo.setIncomeRatio(rs.getDouble("incomeRatio"));
        cdsInfo.setCostRatio(rs.getDouble("costRatio"));
        return cdsInfo;
    };
    private final JdbcTemplate ebikeJdbcTemplate;

    public CsshDistschemeDaoImpl(JdbcTemplate ebikeJdbcTemplate) {
        this.ebikeJdbcTemplate = ebikeJdbcTemplate;
    }

    @Override
    public List<CsshDistSchemeInfo> getCsshDistSchemeInfoList(Long chargestationId) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>>>>> start getCsshDistSchemeInfoList >>>>>>>>>> ");
            this.logger.debug(" chargestationId : " + chargestationId);
        }
        String sql = "SELECT * FROM ebike.ebike_cssh_distscheme WHERE chargestationId = ? AND csshdsStatus IN ('00', '02', '03') ORDER BY effTime ";
        return this.ebikeJdbcTemplate.query(sql, new Object[]{chargestationId}, this.cdsInfoRowMapper);
    }
}

