/*
 * Decompiled with CFR 0.152.
 */
package cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.impl;

import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.TestingDao;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargeDeviceProtocolEnum;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.TestingChargeDevice;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.TestingChargePlug;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class TestingDaoImpl
implements TestingDao {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final RowMapper<TestingChargeDevice> tcdRowMapper = (rs, rowNum) -> {
        TestingChargeDevice tcd = new TestingChargeDevice();
        tcd.setOrgNo(rs.getString("subburo"));
        tcd.setChargedeviceNo(rs.getString("chargedeviceNo"));
        tcd.setDeviceId(rs.getString("deviceId"));
        if (StringUtils.equals((CharSequence)"mqtt.yjm2m", (CharSequence)rs.getString("protocolType"))) {
            if (StringUtils.equals((CharSequence)"201801", (CharSequence)rs.getString("protocolVersion"))) {
                tcd.setChargeDeviceProtocol(ChargeDeviceProtocolEnum.MQTT_YJM2M_201801);
            } else if (StringUtils.equals((CharSequence)"201804", (CharSequence)rs.getString("protocolVersion"))) {
                tcd.setChargeDeviceProtocol(ChargeDeviceProtocolEnum.MQTT_YJM2M_201804);
            }
        } else if (StringUtils.equals((CharSequence)"mqtt.ebike", (CharSequence)rs.getString("protocolType"))) {
            if (StringUtils.equals((CharSequence)"201804", (CharSequence)rs.getString("protocolVersion"))) {
                tcd.setChargeDeviceProtocol(ChargeDeviceProtocolEnum.MQTT_EBIKE_201804);
            } else if (StringUtils.equals((CharSequence)"201805", (CharSequence)rs.getString("protocolVersion"))) {
                tcd.setChargeDeviceProtocol(ChargeDeviceProtocolEnum.MQTT_EBIKE_201805);
            }
        }
        if (tcd.getChargeDeviceProtocol() == null) {
            tcd.setChargeDeviceProtocol(ChargeDeviceProtocolEnum.UNKNOWN);
        }
        tcd.setPlugCount(rs.getInt("plugCount"));
        tcd.setFactory(rs.getString("factory"));
        tcd.setModelNo(rs.getString("modelNo"));
        tcd.setStatus(rs.getString("status"));
        tcd.setOpStatus(rs.getString("opStatus"));
        tcd.setBinder(rs.getString("binder"));
        if (rs.getTimestamp("bindTime") != null) {
            tcd.setBindTime(new Date(rs.getTimestamp("bindTime").getTime()));
        }
        tcd.setTestCount(rs.getInt("testCount"));
        tcd.setLatestTester(rs.getString("latestTester"));
        if (rs.getTimestamp("latestTestTime") != null) {
            tcd.setLatestTestTime(new Date(rs.getTimestamp("latestTestTime").getTime()));
        }
        tcd.setLatestTestResult(rs.getString("latestTestResult"));
        tcd.setLatestTestFailCause(rs.getString("latestTestFailCause"));
        if (rs.getTimestamp("importAssetTime") != null) {
            tcd.setImportAssetTime(new Date(rs.getTimestamp("importAssetTime").getTime()));
        }
        tcd.setImportAssetResult(rs.getString("importAssetResult"));
        tcd.setImportAssetFailCause(rs.getString("importAssetFailCause"));
        return tcd;
    };
    private final RowMapper<TestingChargePlug> tcpRowMapper = (rs, rowNum) -> {
        TestingChargePlug tcp = new TestingChargePlug();
        tcp.setOrgNo(rs.getString("subburo"));
        tcp.setChargedeviceNo(rs.getString("chargedeviceNo"));
        tcp.setPlugSn(rs.getInt("plugSn"));
        tcp.setTestStatus(rs.getString("testStatus"));
        tcp.setTestStatusDesc(rs.getString("testStatusDesc"));
        tcp.setTester(rs.getString("tester"));
        if (rs.getTimestamp("startTestTime") != null) {
            tcp.setStartTestTime(new Date(rs.getTimestamp("startTestTime").getTime()));
        }
        if (rs.getTimestamp("endTestTime") != null) {
            tcp.setEndTestTime(new Date(rs.getTimestamp("endTestTime").getTime()));
        }
        return tcp;
    };
    private final JdbcTemplate ebikeJdbcTemplate;

    public TestingDaoImpl(JdbcTemplate ebikeJdbcTemplate) {
        this.ebikeJdbcTemplate = ebikeJdbcTemplate;
    }

    @Override
    public TestingChargeDevice getTestingChargeDeviceByDeviceId(String deviceId) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>>>>> getTestingChargeDeviceByDeviceId >>>>>>>>>> ");
            this.logger.debug(" deviceId : " + deviceId);
        }
        String sql = "SELECT tbd.* FROM ebike.test_binding_chargedevice tbd WHERE tbd.deviceId = ? LIMIT 1 ";
        TestingChargeDevice tcd = null;
        try {
            tcd = (TestingChargeDevice)this.ebikeJdbcTemplate.queryForObject(sql, new Object[]{deviceId}, this.tcdRowMapper);
        }
        catch (EmptyResultDataAccessException _erdae) {
            tcd = null;
        }
        return tcd;
    }

    @Override
    public TestingChargeDevice getTestingChargeDeviceByChargedeviceNo(String chargedeviceNo) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>>>>> getTestingChargeDeviceByChargedeviceNo >>>>>>>>>> ");
            this.logger.debug(" chargedeviceNo : " + chargedeviceNo);
        }
        String sql = "SELECT tbd.* FROM ebike.test_binding_chargedevice tbd WHERE tbd.chargedeviceNo = ? LIMIT 1 ";
        TestingChargeDevice tcd = null;
        try {
            tcd = (TestingChargeDevice)this.ebikeJdbcTemplate.queryForObject(sql, new Object[]{chargedeviceNo}, this.tcdRowMapper);
        }
        catch (EmptyResultDataAccessException _erdae) {
            tcd = null;
        }
        return tcd;
    }

    @Override
    public void insertTestingChargeDevice(TestingChargeDevice testingChargeDevice) {
        String sql = "INSERT INTO ebike.test_binding_chargedevice(buro, subburo, chargedeviceNo, deviceId, protocolType, protocolVersion, plugCount, factory, modelNo, status, opStatus, binder, bindTime, testCount, latestTestResult) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ";
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(testingChargeDevice.getOrgNo());
        params.add(testingChargeDevice.getOrgNo());
        params.add(testingChargeDevice.getChargedeviceNo());
        params.add(testingChargeDevice.getDeviceId());
        params.add(testingChargeDevice.getChargeDeviceProtocol().getType());
        params.add(testingChargeDevice.getChargeDeviceProtocol().getVersion());
        params.add(testingChargeDevice.getPlugCount());
        params.add(testingChargeDevice.getFactory());
        params.add(testingChargeDevice.getModelNo());
        params.add(testingChargeDevice.getStatus());
        params.add(testingChargeDevice.getOpStatus());
        params.add(testingChargeDevice.getBinder());
        params.add(testingChargeDevice.getBindTime());
        params.add(testingChargeDevice.getTestCount());
        params.add(testingChargeDevice.getLatestTestResult());
        this.ebikeJdbcTemplate.update(sql, params.toArray());
    }

    @Override
    public void updateTestingChargeDevice(TestingChargeDevice testingChargeDevice) {
        String sql = "UPDATE ebike.test_binding_chargedevice SET status = ?, opStatus = ?, testCount = ?, latestTester = ?, latestTestTime = ?, latestTestResult = ?, latestTestFailCause = ?, importAssetTime = ?, importAssetResult = ?, importAssetFailCause = ? WHERE buro = ? AND subburo = ? AND chargedeviceNo = ? ";
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(testingChargeDevice.getStatus());
        params.add(testingChargeDevice.getOpStatus());
        params.add(testingChargeDevice.getTestCount());
        params.add(testingChargeDevice.getLatestTester());
        params.add(testingChargeDevice.getLatestTestTime());
        params.add(testingChargeDevice.getLatestTestResult());
        params.add(testingChargeDevice.getLatestTestFailCause());
        params.add(testingChargeDevice.getImportAssetTime());
        params.add(testingChargeDevice.getImportAssetResult());
        params.add(testingChargeDevice.getImportAssetFailCause());
        params.add(testingChargeDevice.getOrgNo());
        params.add(testingChargeDevice.getOrgNo());
        params.add(testingChargeDevice.getChargedeviceNo());
        this.ebikeJdbcTemplate.update(sql, params.toArray());
    }

    @Override
    public List<TestingChargePlug> getTestingChargePlugListByDeviceId(String deviceId) {
        String sql = "SELECT ttc.* FROM ebike.test_testing_chargeplug ttc INNER JOIN ebike.test_binding_chargedevice tbc ON tbc.buro = ttc.buro AND tbc.subburo = ttc.subburo AND tbc.chargedeviceNo = ttc.chargedeviceNo WHERE tbc.deviceId = ? ORDER BY ttc.plugSn";
        return this.ebikeJdbcTemplate.query(sql, new Object[]{deviceId}, this.tcpRowMapper);
    }

    @Override
    public List<TestingChargePlug> getTestingChargePlugListByChargedeviceNo(String chargedeviceNo) {
        String sql = "SELECT ttc.* FROM ebike.test_testing_chargeplug ttc WHERE ttc.chargedeviceNo = ? ORDER BY ttc.plugSn";
        return this.ebikeJdbcTemplate.query(sql, new Object[]{chargedeviceNo}, this.tcpRowMapper);
    }

    @Override
    public TestingChargePlug getTestingChargePlugByDeviceIdAndPlugSn(String deviceId, Integer plugSn) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>>>>> getTestingChargePlugByDeviceIdAndPlugSn >>>>>>>>>> ");
            this.logger.debug(" deviceId : " + deviceId);
            this.logger.debug(" plugSn   : " + plugSn);
        }
        String sql = "SELECT ttc.* FROM ebike.test_testing_chargeplug ttc INNER JOIN ebike.test_binding_chargedevice tbc ON tbc.buro = ttc.buro AND tbc.subburo = ttc.subburo AND tbc.chargedeviceNo = ttc.chargedeviceNo WHERE tbc.deviceId = ? AND ttc.plugSn = ? LIMIT 1 ";
        TestingChargePlug tcp = null;
        try {
            tcp = (TestingChargePlug)this.ebikeJdbcTemplate.queryForObject(sql, new Object[]{deviceId, plugSn}, this.tcpRowMapper);
        }
        catch (EmptyResultDataAccessException _erdae) {
            tcp = null;
        }
        return tcp;
    }

    @Override
    public TestingChargePlug getTestingChargePlugByChargedeviceNoAndPlugSn(String chargedeviceNo, Integer plugSn) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>>>>> getTestingChargePlugByDeviceIdAndPlugSn >>>>>>>>>> ");
            this.logger.debug(" chargedeviceNo   : " + chargedeviceNo);
            this.logger.debug(" plugSn           : " + plugSn);
        }
        String sql = "SELECT ttc.* FROM ebike.test_testing_chargeplug ttc WHERE ttc.chargedeviceNo = ? AND ttc.plugSn = ? LIMIT 1 ";
        TestingChargePlug tcp = null;
        try {
            tcp = (TestingChargePlug)this.ebikeJdbcTemplate.queryForObject(sql, new Object[]{chargedeviceNo, plugSn}, this.tcpRowMapper);
        }
        catch (EmptyResultDataAccessException _erdae) {
            tcp = null;
        }
        return tcp;
    }

    @Override
    public void updateTestingChargePlug(TestingChargePlug testingChargePlug) {
        String sql = "UPDATE ebike.test_testing_chargeplug SET testStatus = ?, testStatusDesc = ?, tester = ?, startTestTime = ?, endTestTime = ? WHERE buro = ? AND subburo = ? AND chargedeviceNo = ? AND plugSn = ? ";
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(testingChargePlug.getTestStatus());
        params.add(testingChargePlug.getTestStatusDesc());
        params.add(testingChargePlug.getTester());
        params.add(testingChargePlug.getStartTestTime());
        params.add(testingChargePlug.getEndTestTime());
        params.add(testingChargePlug.getOrgNo());
        params.add(testingChargePlug.getOrgNo());
        params.add(testingChargePlug.getChargedeviceNo());
        params.add(testingChargePlug.getPlugSn());
        this.ebikeJdbcTemplate.update(sql, params.toArray());
    }
}

