/*
 * Decompiled with CFR 0.152.
 */
package cn.yunrui.mqttclient.ebikesrv.mqttclient.handler.impl;

import cn.yunrui.mqttclient.ebikesrv.common.utils.JsonConvertUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.MapUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.ObjectUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.MqttMsgLogDao;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.BillingInfo;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargeDeviceProps;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.CostInfo;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.MsgHandleResponse;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.handler.MqttMessageHandler;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.handler.impl.MqttMessageHandlerImpl;
import com.ebikepay.openservices.entity.OrderTypeEnum;
import com.ebikepay.openservices.entity.PayTypeEnum;
import com.ebikepay.openservices.request.InnerAccountCreateRequest;
import com.ebikepay.openservices.request.InnerAccountLoadRequest;
import com.ebikepay.openservices.request.TradeOrderCreateRequest;
import com.ebikepay.openservices.request.TradeOrderPayRequest;
import com.ebikepay.openservices.response.InnerAccountCreateResponse;
import com.ebikepay.openservices.response.InnerAccountLoadResponse;
import com.ebikepay.openservices.response.TradeOrderCreateResponse;
import com.ebikepay.openservices.response.TradeOrderPayResponse;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class CardChargeHandlerImpl
extends MqttMessageHandlerImpl
implements MqttMessageHandler {
    public CardChargeHandlerImpl(MqttClient mqttClient, MqttMsgLogDao mqttMsgLogDao) {
        super("cardCharge", mqttClient, mqttMsgLogDao, true);
    }

    @Override
    public MsgHandleResponse handleUpMessage(ChargeDeviceProps chargeDeviceProps, MqttMessage mqttMessage) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start handleUpMessage >>>>>> ");
        }
        MsgHandleResponse res = new MsgHandleResponse();
        res.setStatus(-1);
        res.setMsg("\u5904\u7406\u4e0a\u884c\uff08\u8bbe\u5907\u5230\u670d\u52a1\u5668\uff09\u6d88\u606f\u5931\u8d25 <<< \u5237\u5361\u5145\u7535\u8bf7\u6c42 ");
        if (chargeDeviceProps != null && StringUtils.isNotBlank((CharSequence)chargeDeviceProps.getDeviceId())) {
            String deviceId = chargeDeviceProps.getDeviceId();
            String rcvdMsg = new String(mqttMessage.getPayload());
            String[] rcvdMsgArray = rcvdMsg.split("#");
            String plugId = null;
            String cardId = null;
            if (rcvdMsgArray.length >= 4) {
                plugId = rcvdMsgArray[2];
                cardId = rcvdMsgArray[3];
            }
            res.setStatus(0);
            res.setMsg("\u5904\u7406\u4e0a\u884c\uff08\u8bbe\u5907\u5230\u670d\u52a1\u5668\uff09\u6d88\u606f\u6210\u529f <<< \u5237\u5361\u5145\u7535\u8bf7\u6c42 ");
            if (this.needRespond && res.getStatus() == 0) {
                res = this.handleDownMessage(chargeDeviceProps, deviceId, plugId, cardId);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" <<<<<<< end handleUpMessage <<<<<<< ");
        }
        return res;
    }

    private MsgHandleResponse handleDownMessage(ChargeDeviceProps chargeDeviceProps, String deviceId, String plugId, String cardId) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start handleDownMessage >>>>>> ");
            this.logger.debug(" chargeDeviceProps    : " + JsonConvertUtils.convertToString(chargeDeviceProps));
            this.logger.debug(" deviceId             : " + deviceId);
            this.logger.debug(" plugId               : " + plugId);
            this.logger.debug(" cardId               : " + cardId);
        }
        MsgHandleResponse res = new MsgHandleResponse();
        res.setStatus(-1);
        res.setMsg("\u5904\u7406\u4e0b\u884c\uff08\u670d\u52a1\u5668\u5230\u8bbe\u5907\uff09\u6d88\u606f\u5931\u8d25 >>> \u5237\u5361\u5145\u7535\u8bf7\u6c42");
        if (StringUtils.isNotBlank((CharSequence)cardId)) {
            String cardStatus = this.chargeRecordCache.getStatusByCardId(cardId);
            Integer cardType = this.chargeRecordCache.getCardTypeByCardId(cardId);
            String orgNo = this.chargeRecordCache.getOrgNoByCustCardId(cardId);
            if (StringUtils.equals((CharSequence)"1", (CharSequence)cardStatus)) {
                InnerAccountLoadRequest innerAccountLoadRequest = new InnerAccountLoadRequest();
                innerAccountLoadRequest.setUserId(cardId);
                innerAccountLoadRequest.setUserType("bike_card");
                InnerAccountLoadResponse innerAccountLoadResponse = this.chargeRecordCache.loadInnerAccount(innerAccountLoadRequest);
                if (innerAccountLoadResponse != null && innerAccountLoadResponse.isSuccess()) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(" InnerAccount         : " + JsonConvertUtils.convertToString(innerAccountLoadResponse.getInnerAccount()));
                    }
                    String chargeUserId = this.chargeRecordCache.getChargeUserIdByCardId(cardId);
                    BillingInfo bi = this.chargeDeviceCache.getBillingInfoByDeviceId(deviceId, chargeUserId, cardId);
                    CostInfo ci = this.chargeDeviceCache.getCostInfoByDeviceId(deviceId);
                    Double serviceRate = this.chargeDeviceCache.getServiceRateByDeviceId(deviceId);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(" chargeUserId         : " + chargeUserId);
                        this.logger.debug(" cardStatus           : " + cardStatus);
                        this.logger.debug(" cardType             : " + cardType);
                        this.logger.debug(" BillingInfo          : " + JsonConvertUtils.convertToString(bi));
                        this.logger.debug(" CostInfo             : " + JsonConvertUtils.convertToString(ci));
                        this.logger.debug(" serviceRate          : " + serviceRate);
                    }
                    int custCardCount = 0;
                    if (cardType != null && cardType == 2) {
                        custCardCount = this.chargeDeviceCache.getCountByDeviceIdAndCardId(deviceId, cardId);
                    }
                    if (cardType != null && cardType == 2 && custCardCount <= 0) {
                        String voiceId = "6";
                        String msg2Device = "voice#" + voiceId;
                        this.response2device(deviceId, msg2Device, "voice");
                    } else if (bi != null) {
                        Double chargeMoney;
                        String billingSchemeType = bi.getSchemeType();
                        if (StringUtils.equals((CharSequence)billingSchemeType, (CharSequence)"03")) {
                            chargeMoney = bi.getUnitPrice1();
                        } else {
                            chargeMoney = 1.0;
                            if (bi.getMinCharge() != null && bi.getMinCharge().compareTo(0.0) > 0) {
                                chargeMoney = bi.getMinCharge();
                            } else if (bi.getUnitPrice1() != null && bi.getUnitPrice1().compareTo(0.0) == 0) {
                                chargeMoney = 0.0;
                            }
                        }
                        Double accountBalance = innerAccountLoadResponse.getInnerAccount().getAccountBalance();
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug(" [\u3000\u8ba1\u8d39\u7c7b\u578b]       : " + billingSchemeType);
                            this.logger.debug(" [\u3000\u5145\u7535\u91d1\u989d]       : " + chargeMoney);
                            this.logger.debug(" [\u5145\u7535\u5361\u4f59\u989d]       : " + accountBalance);
                        }
                        if (accountBalance >= chargeMoney) {
                            Map<String, Object> chargeRecordMap = this.chargeRecordCache.getChargeRecordMap(deviceId, plugId);
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug(" 1.1. ");
                                this.logger.debug(" deviceId         : " + deviceId);
                                this.logger.debug(" plugId           : " + plugId);
                                this.logger.debug(" chargeRecordMap  : " + JsonConvertUtils.convertToString(chargeRecordMap));
                            }
                            int chargeType = MapUtils.isNotEmpty(chargeRecordMap) ? (StringUtils.equals((CharSequence)billingSchemeType, (CharSequence)"03") ? 9 : (StringUtils.notEquals((String)chargeRecordMap.get("schemeType"), "03") && StringUtils.equals((CharSequence)((String)chargeRecordMap.get("card_id")), (CharSequence)cardId) ? 2 : 9)) : 1;
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug(" chargeType       : " + chargeType);
                                this.logger.debug(" deviceId         : " + deviceId);
                                this.logger.debug(" plugId           : " + plugId);
                            }
                            if (chargeType == 1) {
                                if (this.logger.isDebugEnabled()) {
                                    this.logger.debug(" old chargeRecordMap      : " + JsonConvertUtils.convertToString(chargeRecordMap));
                                }
                                if (this.fitconnDebuggingCache.checkIsDebugging(deviceId, plugId)) {
                                    HashMap<String, Object> valueMap = new HashMap<String, Object>();
                                    valueMap.put("debugFinishTime", new Date());
                                    this.fitconnDebuggingCache.finishFitconnDebuggingLog(deviceId, plugId, valueMap);
                                    this.chargeDeviceCache.updatePlugStatus(deviceId, plugId, "0");
                                }
                                String chargeplugNo = chargeDeviceProps.getChargedeviceNo() + String.format("%02d", Integer.parseInt(plugId));
                                Date chargeTime = new Date();
                                String chargeRecordId = this.getNewChargeRecordId(chargeplugNo, chargeTime);
                                chargeRecordMap = this.getChargeRecordMapByCard(bi, chargeMoney);
                                if (this.logger.isDebugEnabled()) {
                                    this.logger.debug(" getChargeRecordMapByCard : " + JsonConvertUtils.convertToString(chargeRecordMap));
                                }
                                if (chargeMoney.compareTo(0.0) > 0) {
                                    TradeOrderCreateRequest tradeOrderCreateRequest = new TradeOrderCreateRequest();
                                    if (cardType != null && cardType == 2) {
                                        InnerAccountLoadRequest loadEbikeOrgCustCardAccountRequest = new InnerAccountLoadRequest();
                                        loadEbikeOrgCustCardAccountRequest.setUserId(orgNo);
                                        loadEbikeOrgCustCardAccountRequest.setUserType("ebike_org_cust_card");
                                        InnerAccountLoadResponse loadEbikeOrgCustCardAccountResponse = this.chargeRecordCache.loadInnerAccount(loadEbikeOrgCustCardAccountRequest);
                                        if (loadEbikeOrgCustCardAccountResponse == null || !loadEbikeOrgCustCardAccountResponse.isSuccess()) {
                                            InnerAccountCreateRequest ebikeOrgCustCardAccountCreateRequest = new InnerAccountCreateRequest();
                                            ebikeOrgCustCardAccountCreateRequest.setUserId(orgNo);
                                            ebikeOrgCustCardAccountCreateRequest.setUserType("ebike_org_cust_card");
                                            ebikeOrgCustCardAccountCreateRequest.setUserName(orgNo);
                                            InnerAccountCreateResponse innerAccountCreateResponse = this.chargeRecordCache.createInnerAccount(ebikeOrgCustCardAccountCreateRequest);
                                        }
                                        tradeOrderCreateRequest.setUserId(orgNo);
                                        tradeOrderCreateRequest.setUserType("ebike_org_cust_card");
                                    } else {
                                        tradeOrderCreateRequest.setUserId("10000000");
                                        tradeOrderCreateRequest.setUserType("ebike_transit");
                                    }
                                    tradeOrderCreateRequest.setCounterUserId(cardId);
                                    tradeOrderCreateRequest.setCounterUserType("bike_card");
                                    tradeOrderCreateRequest.setOrderMoney(chargeMoney);
                                    tradeOrderCreateRequest.setOrderType(OrderTypeEnum.TRADE.getCode());
                                    tradeOrderCreateRequest.setBusinessModule("ebike-card-charge");
                                    tradeOrderCreateRequest.setBusinessId(chargeRecordId);
                                    tradeOrderCreateRequest.setOrderRemark("\u5145\u7535\u5361[" + cardId + "]\u5145\u7535\uff0c\u5145\u7535\u91d1\u989d\uff1a" + chargeMoney + "\u5143");
                                    TradeOrderCreateResponse tradeOrderCreateResponse = this.chargeRecordCache.createTradeOrder(tradeOrderCreateRequest);
                                    if (tradeOrderCreateResponse != null && tradeOrderCreateResponse.isSuccess()) {
                                        TradeOrderPayRequest tradeOrderPayRequest = new TradeOrderPayRequest();
                                        tradeOrderPayRequest.setOrderId(tradeOrderCreateResponse.getTradeOrder().getOrderId());
                                        tradeOrderPayRequest.setPayMoney(chargeMoney);
                                        tradeOrderPayRequest.setPayType(PayTypeEnum.INNERACCT.getCode());
                                        TradeOrderPayResponse tradeOrderPayResponse = this.chargeRecordCache.payTradeOrder(tradeOrderPayRequest);
                                        if (tradeOrderPayResponse != null && tradeOrderPayResponse.isSuccess() && chargeRecordMap != null) {
                                            chargeRecordMap.put("chargeRecordId", chargeRecordId);
                                            chargeRecordMap.put("chargeTime", chargeTime);
                                            chargeRecordMap.put("chargeplugId", chargeDeviceProps.getPlugPropsMap().get(Integer.parseInt(plugId)).getChargeplugId());
                                            chargeRecordMap.put("chargedeviceId", chargeDeviceProps.getChargedeviceId());
                                            chargeRecordMap.put("chargestationId", chargeDeviceProps.getChargestationId());
                                            chargeRecordMap.put("chargeUserId", chargeUserId);
                                            chargeRecordMap.put("chargeTradeOrderId", tradeOrderPayResponse.getTradeOrder().getOrderId());
                                            if (cardType != null && cardType == 2) {
                                                chargeRecordMap.put("enterUserType", "ebike_org_cust_card");
                                                chargeRecordMap.put("enterUserId", orgNo);
                                            } else {
                                                chargeRecordMap.put("enterUserType", "ebike_transit");
                                                chargeRecordMap.put("enterUserId", "10000000");
                                            }
                                            chargeRecordMap.put("serviceRate", serviceRate);
                                            if (ObjectUtils.isNotNull(ci)) {
                                                chargeRecordMap.put("costSchemeId", ci.getCostSchemeId());
                                                chargeRecordMap.put("costUnitPrice", ci.getCostUnitPrice());
                                            }
                                            Double remainElecCons = (Double)chargeRecordMap.get("remainElecCons");
                                            Double remainTime = (Double)chargeRecordMap.get("remainTime");
                                            String msg2Device = "cardCharge#" + cardId + "#0#" + plugId + "#" + Math.round(remainElecCons * 1000.0) + "#" + Math.round(remainTime);
                                            int result = 0;
                                            result = cardType != null && cardType == 2 ? this.chargeRecordCache.insertChargeRecordByCustCard(chargeRecordMap, chargeplugNo, cardId) : this.chargeRecordCache.insertChargeRecordByCard(chargeRecordMap, chargeplugNo, cardId);
                                            if (result > 0) {
                                                boolean r = this.response2device(deviceId, msg2Device, "cardCharge");
                                                if (this.logger.isInfoEnabled()) {
                                                    this.logger.info("\u5237\u5361\u5145\u7535\u8bf7\u6c42\u4e0b\u53d1\u5f00\u59cb\u5145\u7535\u547d\u4ee4" + (r ? "\u6210\u529f" : "\u5931\u8d25"));
                                                }
                                            }
                                        }
                                    } else {
                                        String msg2Device = "cardCharge#" + cardId + "#-5";
                                        boolean r = this.response2device(deviceId, msg2Device, "cardCharge");
                                        if (this.logger.isInfoEnabled()) {
                                            this.logger.info("\u5237\u5361\u5145\u7535\u8bf7\u6c42\u4e0b\u53d1\u5f00\u59cb\u5145\u7535\u547d\u4ee4" + (r ? "\u6210\u529f" : "\u5931\u8d25"));
                                        }
                                    }
                                } else if (chargeRecordMap != null) {
                                    chargeRecordMap.put("chargeRecordId", chargeRecordId);
                                    chargeRecordMap.put("chargeTime", chargeTime);
                                    chargeRecordMap.put("chargeplugId", chargeDeviceProps.getPlugPropsMap().get(Integer.parseInt(plugId)).getChargeplugId());
                                    chargeRecordMap.put("chargedeviceId", chargeDeviceProps.getChargedeviceId());
                                    chargeRecordMap.put("chargestationId", chargeDeviceProps.getChargestationId());
                                    chargeRecordMap.put("chargeUserId", chargeUserId);
                                    chargeRecordMap.put("chargeTradeOrderId", null);
                                    chargeRecordMap.put("enterUserType", null);
                                    chargeRecordMap.put("enterUserId", null);
                                    chargeRecordMap.put("serviceRate", null);
                                    if (ObjectUtils.isNotNull(ci)) {
                                        chargeRecordMap.put("costSchemeId", ci.getCostSchemeId());
                                        chargeRecordMap.put("costUnitPrice", ci.getCostUnitPrice());
                                    }
                                    Double remainElecCons = (Double)chargeRecordMap.get("remainElecCons");
                                    Double remainTime = (Double)chargeRecordMap.get("remainTime");
                                    String msg2Device = "cardCharge#" + cardId + "#0#" + plugId + "#" + Math.round(remainElecCons * 1000.0) + "#" + Math.round(remainTime);
                                    int result = 0;
                                    result = cardType != null && cardType == 2 ? this.chargeRecordCache.insertChargeRecordByCustCard(chargeRecordMap, chargeplugNo, cardId) : this.chargeRecordCache.insertChargeRecordByCard(chargeRecordMap, chargeplugNo, cardId);
                                    if (result > 0) {
                                        boolean r = this.response2device(deviceId, msg2Device, "cardCharge");
                                        if (this.logger.isInfoEnabled()) {
                                            this.logger.info("\u5237\u5361\u5145\u7535\u8bf7\u6c42\u4e0b\u53d1\u5f00\u59cb\u5145\u7535\u547d\u4ee4" + (r ? "\u6210\u529f" : "\u5931\u8d25"));
                                        }
                                    }
                                }
                            } else if (chargeType == 2) {
                                if (this.logger.isDebugEnabled()) {
                                    this.logger.debug(" old chargeRecordMap      : " + JsonConvertUtils.convertToString(chargeRecordMap));
                                }
                                Map<String, Object> newChargeRecordMap = this.getChargeRecordMapByCard(bi, chargeMoney);
                                if (this.logger.isDebugEnabled()) {
                                    this.logger.debug(" new add chargeRecordMap      : " + JsonConvertUtils.convertToString(newChargeRecordMap));
                                }
                            } else {
                                String voiceId = "9";
                                String msg2Device = "voice#" + voiceId;
                                this.response2device(deviceId, msg2Device, "voice");
                            }
                        } else {
                            String voiceId = "7";
                            String msg2Device = "voice#" + voiceId;
                            this.response2device(deviceId, msg2Device, "voice");
                        }
                    } else {
                        String voiceId = "6";
                        String msg2Device = "voice#" + voiceId;
                        this.response2device(deviceId, msg2Device, "voice");
                    }
                } else {
                    String voiceId = "7";
                    String msg2Device = "voice#" + voiceId;
                    this.response2device(deviceId, msg2Device, "voice");
                }
            } else if (StringUtils.equals((CharSequence)"2", (CharSequence)cardStatus)) {
                String voiceId = "1";
                String msg2Device = "voice#" + voiceId;
                this.response2device(deviceId, msg2Device, "voice");
            } else if (StringUtils.equals((CharSequence)"0", (CharSequence)cardStatus)) {
                String voiceId = "1";
                String msg2Device = "voice#" + voiceId;
                this.response2device(deviceId, msg2Device, "voice");
            } else {
                String voiceId = "6";
                String msg2Device = "voice#" + voiceId;
                this.response2device(deviceId, msg2Device, "voice");
            }
        } else {
            String voiceId = "6";
            String msg2Device = "voice#" + voiceId;
            this.response2device(deviceId, msg2Device, "voice");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" <<<<<<< end handleDownMessage <<<<<<< ");
        }
        return res;
    }
}

