/*
 * Decompiled with CFR 0.152.
 */
package cn.yunrui.mqttclient.ebikesrv.mqttclient.handler.impl;

import cn.yunrui.mqttclient.ebikesrv.common.utils.JsonConvertUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.MapUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.MqttMsgLogDao;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.BillingInfo;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargeDeviceProps;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargeDeviceProtocolEnum;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.MsgHandleResponse;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.handler.MqttMessageHandler;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.handler.impl.MqttMessageHandlerImpl;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class CoinChargeHandlerImpl
extends MqttMessageHandlerImpl
implements MqttMessageHandler {
    public CoinChargeHandlerImpl(MqttClient mqttClient, MqttMsgLogDao mqttMsgLogDao) {
        super("coinCharge", mqttClient, mqttMsgLogDao, true);
    }

    @Override
    public MsgHandleResponse handleUpMessage(ChargeDeviceProps chargeDeviceProps, MqttMessage mqttMessage) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start handleUpMessage >>>>>> ");
        }
        MsgHandleResponse res = new MsgHandleResponse();
        res.setStatus(-1);
        res.setMsg("\u5904\u7406\u4e0a\u884c\uff08\u8bbe\u5907\u5230\u670d\u52a1\u5668\uff09\u6d88\u606f\u5931\u8d25 <<< \u6295\u5e01\u5145\u7535\u8bf7\u6c42");
        if (chargeDeviceProps != null && StringUtils.isNotBlank((CharSequence)chargeDeviceProps.getDeviceId())) {
            String deviceId = chargeDeviceProps.getDeviceId();
            String rcvdMsg = new String(mqttMessage.getPayload());
            String[] rcvdMsgArray = rcvdMsg.split("#");
            String plugId = null;
            String smoney = null;
            Date currTime = new Date();
            if (rcvdMsgArray.length >= 4) {
                plugId = rcvdMsgArray[2];
                smoney = rcvdMsgArray[3];
            }
            Double money = 0.0;
            if (smoney != null) {
                try {
                    money = Double.parseDouble(smoney);
                }
                catch (NumberFormatException _nfe) {
                    this.logger.error(_nfe.getMessage(), _nfe.fillInStackTrace());
                }
            }
            res.setStatus(0);
            res.setMsg("\u5904\u7406\u4e0a\u884c\uff08\u8bbe\u5907\u5230\u670d\u52a1\u5668\uff09\u6d88\u606f\u6210\u529f <<< \u6295\u5e01\u5145\u7535\u8bf7\u6c42");
            if (this.needRespond && res.getStatus() == 0) {
                res = this.handleDownMessage(chargeDeviceProps, plugId, money);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" <<<<<<< end handleUpMessage <<<<<<< ");
        }
        return res;
    }

    private MsgHandleResponse handleDownMessage(ChargeDeviceProps chargeDeviceProps, String plugId, Double money) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start handleDownMessage >>>>>> ");
            this.logger.debug(" chargeDeviceProps    : " + JsonConvertUtils.convertToString(chargeDeviceProps));
            this.logger.debug(" plugId               : " + plugId);
            this.logger.debug(" money                : " + money);
        }
        MsgHandleResponse res = new MsgHandleResponse();
        res.setStatus(-1);
        res.setMsg("\u5904\u7406\u4e0b\u884c\uff08\u670d\u52a1\u5668\u5230\u8bbe\u5907\uff09\u6d88\u606f\u5931\u8d25 >>> \u6295\u5e01\u5145\u7535\u8bf7\u6c42");
        if (chargeDeviceProps != null && StringUtils.isNotBlank((CharSequence)chargeDeviceProps.getDeviceId()) && StringUtils.isNotBlank((CharSequence)plugId)) {
            String deviceId = chargeDeviceProps.getDeviceId();
            Map<String, Object> chargeRecordMap = this.chargeRecordCache.getChargeRecordMap(deviceId, plugId);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(" chargeRecordMap      : " + JsonConvertUtils.convertToString(chargeRecordMap));
            }
            if (MapUtils.isNotEmpty(chargeRecordMap)) {
                res.setStatus(-2);
                res.setMsg("\u5904\u7406\u4e0b\u884c\uff08\u670d\u52a1\u5668\u5230\u8bbe\u5907\uff09\u6d88\u606f\u5931\u8d25 >>> \u6295\u5e01\u5145\u7535\u8bf7\u6c42\uff0c\u5145\u7535\u63d2\u5ea7\u6b63\u5728\u5145\u7535");
            } else {
                if (this.fitconnDebuggingCache.checkIsDebugging(deviceId, plugId)) {
                    HashMap<String, Object> valueMap = new HashMap<String, Object>();
                    valueMap.put("debugFinishTime", new Date());
                    this.fitconnDebuggingCache.finishFitconnDebuggingLog(deviceId, plugId, valueMap);
                    this.chargeDeviceCache.updatePlugStatus(deviceId, plugId, "0");
                }
                if (chargeDeviceProps.getChargeDeviceProtocol().equals(ChargeDeviceProtocolEnum.MQTT_YJM2M_201804)) {
                    money = money / 100.0;
                }
                BillingInfo bi = this.chargeDeviceCache.getDefaultBillingInfoByDeviceId(deviceId);
                chargeRecordMap = this.getChargeRecordMapByCoinsin(bi, money);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(" BillingInfo          : " + JsonConvertUtils.convertToString(bi));
                    this.logger.debug(" chargeRecordMap      : " + JsonConvertUtils.convertToString(chargeRecordMap));
                }
                String chargeplugNo = chargeDeviceProps.getChargedeviceNo() + String.format("%02d", Integer.parseInt(plugId));
                String chargeUserId = "000000-ebike-coinsin-charge-user";
                Date chargeTime = new Date();
                if (chargeRecordMap != null) {
                    chargeRecordMap.put("chargeRecordId", this.getNewChargeRecordId(chargeplugNo, chargeTime));
                    chargeRecordMap.put("chargeTime", chargeTime);
                    chargeRecordMap.put("chargeUserId", chargeUserId);
                    Double remainElecCons = (Double)chargeRecordMap.get("remainElecCons");
                    Double remainTime = (Double)chargeRecordMap.get("remainTime");
                    String msg2Device = "coinCharge#" + plugId + "#" + Math.round(remainElecCons * 1000.0) + "#" + Math.round(remainTime);
                    int result = this.chargeRecordCache.insertChargeRecordByCoinsin(chargeRecordMap, chargeplugNo);
                    if (result > 0) {
                        boolean r = this.response2device(deviceId, msg2Device, "coinCharge");
                        if (this.logger.isInfoEnabled()) {
                            this.logger.info("\u6295\u5e01\u4e0b\u53d1\u5f00\u59cb\u5145\u7535\u547d\u4ee4" + (r ? "\u6210\u529f" : "\u5931\u8d25"));
                        }
                    }
                }
                res.setStatus(0);
                res.setMsg("\u5904\u7406\u4e0b\u884c\uff08\u8bbe\u5907\u5230\u670d\u52a1\u5668\uff09\u6d88\u606f\u6210\u529f >>> \u6295\u5e01\u5145\u7535\u8bf7\u6c42");
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" <<<<<<< end handleDownMessage <<<<<<< ");
        }
        return res;
    }
}

