/*
 * Decompiled with CFR 0.152.
 */
package cn.yunrui.mqttclient.ebikesrv.mqttclient.handler.impl;

import cn.yunrui.mqttclient.ebikesrv.common.utils.CollectionUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.DateFormatUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.MapUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.NumberUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.WorkOrderIdUtils;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.MqttMsgLogDao;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargeDeviceProps;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargePlugProps;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.MsgHandleResponse;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.OpsWorkOrder;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.handler.MqttMessageHandler;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.handler.impl.MqttMessageHandlerImpl;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class EventHandlerImpl
extends MqttMessageHandlerImpl
implements MqttMessageHandler {
    public EventHandlerImpl(MqttClient mqttClient, MqttMsgLogDao mqttMsgLogDao) {
        super("event", mqttClient, mqttMsgLogDao, false);
    }

    @Override
    public MsgHandleResponse handleUpMessage(ChargeDeviceProps chargeDeviceProps, MqttMessage mqttMessage) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start handleUpMessage >>>>>> ");
        }
        MsgHandleResponse res = new MsgHandleResponse();
        res.setStatus(-1);
        res.setMsg("\u5904\u7406\u4e0a\u884c\uff08\u8bbe\u5907\u5230\u670d\u52a1\u5668\uff09\u6d88\u606f\u5931\u8d25 <<< \u544a\u8b66\u4e8b\u4ef6\u62a5\u6587");
        if (chargeDeviceProps != null && StringUtils.isNotBlank((CharSequence)chargeDeviceProps.getDeviceId())) {
            String deviceId = chargeDeviceProps.getDeviceId();
            String rcvdMsg = new String(mqttMessage.getPayload());
            String[] rcvdMsgArray = rcvdMsg.split("#");
            String plugId = null;
            String eventCode = null;
            String eventValue = null;
            Date currTime = new Date();
            if (rcvdMsgArray.length >= 4) {
                plugId = rcvdMsgArray[2];
                eventCode = rcvdMsgArray[3];
                if (rcvdMsgArray.length >= 5) {
                    eventValue = rcvdMsgArray[4];
                }
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("deviceId      : " + deviceId);
                this.logger.debug("plugId        : " + plugId);
                this.logger.debug("eventCode     : " + eventCode);
                this.logger.debug("eventValue    : " + eventValue);
                this.logger.debug("currTime      : " + DateFormatUtils.format((Date)currTime, (String)"yyyy-MM-dd HH:mm:ss.SSS"));
            }
            Integer plugSn = 0;
            Integer eventNo = 0;
            if (NumberUtils.isParsable((String)plugId) && NumberUtils.isParsable((String)eventCode)) {
                plugSn = Integer.parseInt(plugId);
                eventNo = Integer.parseInt(eventCode);
            }
            if (eventNo == 1 && plugSn == 0) {
                List<OpsWorkOrder> opsWorkOrderList;
                if (StringUtils.isNotBlank((CharSequence)chargeDeviceProps.getDeviceId()) && chargeDeviceProps.getPlugCount() != null && chargeDeviceProps.getPlugCount() > 0) {
                    Object[] plugStatus = new String[chargeDeviceProps.getPlugCount().intValue()];
                    Arrays.fill(plugStatus, "9");
                    ChargeDeviceProps cdp = this.chargeDeviceCache.get(chargeDeviceProps.getDeviceId());
                    if (cdp != null && MapUtils.isNotEmpty(cdp.getPlugPropsMap())) {
                        for (int i = 0; i < cdp.getPlugPropsMap().size(); ++i) {
                            ChargePlugProps cpp = cdp.getPlugPropsMap().get(i + 1);
                            if (cpp == null || !StringUtils.isNotBlank((CharSequence)cpp.getOpStatus())) continue;
                            if (StringUtils.equals((CharSequence)"1", (CharSequence)cpp.getOpStatus())) {
                                plugStatus[i] = "1";
                                continue;
                            }
                            if (StringUtils.equals((CharSequence)"2", (CharSequence)cpp.getOpStatus())) {
                                plugStatus[i] = "2";
                                continue;
                            }
                            if (!StringUtils.equals((CharSequence)"8", (CharSequence)cpp.getOpStatus())) continue;
                            plugStatus[i] = "8";
                        }
                    }
                    this.chargeDeviceCache.updateOpStatus(chargeDeviceProps.getDeviceId(), "0", (String[])plugStatus);
                }
                if (CollectionUtils.sizeIsNotEmptyIgnoreNull(opsWorkOrderList = this.opsWorkOrderCache.getOpsWorkOrderList(deviceId, String.valueOf(plugSn), "102", "N"))) {
                    int index = 1;
                    for (OpsWorkOrder opsWorkOrder : opsWorkOrderList) {
                        if (index > 1) {
                            opsWorkOrder.setIsRecovery("Y");
                            opsWorkOrder.setRecoveryTime(new Date());
                            this.opsWorkOrderCache.recoveryOpsWorkOrder(opsWorkOrder);
                        }
                        ++index;
                    }
                } else {
                    OpsWorkOrder opsWorkOrder = new OpsWorkOrder();
                    opsWorkOrder.setOpsworkorderId(WorkOrderIdUtils.getNewOpsWorkOrderId(chargeDeviceProps.getChargedeviceNo(), "102"));
                    opsWorkOrder.setOpsworkorderType("102");
                    opsWorkOrder.setOpsworkorderStatus("10");
                    opsWorkOrder.setOpsObjectType("EBikeChargeDevice");
                    opsWorkOrder.setOpsObjectId(chargeDeviceProps.getChargedeviceId());
                    opsWorkOrder.setOpsworkorderDesc("\u8bbe\u5907\u505c\u7535");
                    this.opsWorkOrderCache.createOpsWorkOrder(opsWorkOrder);
                }
            }
            res.setStatus(0);
            res.setMsg("\u5904\u7406\u4e0a\u884c\uff08\u8bbe\u5907\u5230\u670d\u52a1\u5668\uff09\u6d88\u606f\u6210\u529f <<< \u544a\u8b66\u4e8b\u4ef6\u62a5\u6587");
            if (this.needRespond && res.getStatus() == 0) {
                res = this.handleDownMessage(chargeDeviceProps);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" <<<<<<< end handleUpMessage <<<<<<< ");
        }
        return res;
    }

    @Override
    protected MsgHandleResponse handleDownMessage(ChargeDeviceProps chargeDeviceProps) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start handleDownMessage >>>>>> ");
        }
        MsgHandleResponse res = new MsgHandleResponse();
        res.setStatus(0);
        res.setMsg("\u5904\u7406\u4e0b\u884c\uff08\u670d\u52a1\u5668\u5230\u8bbe\u5907\uff09\u6d88\u606f\u6210\u529f >>> \u544a\u8b66\u4e8b\u4ef6\u62a5\u6587");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" <<<<<<< end handleDownMessage <<<<<<< ");
        }
        return res;
    }
}

