/*
 * Decompiled with CFR 0.152.
 */
package cn.yunrui.mqttclient.ebikesrv.mqttclient.handler.impl;

import cn.yunrui.mqttclient.ebikesrv.common.utils.JsonConvertUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.ObjectUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.MqttMsgLogDao;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargeDeviceProps;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.MsgHandleResponse;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.handler.MqttMessageHandler;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.handler.impl.MqttMessageHandlerImpl;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class MqttHandlerImpl
extends MqttMessageHandlerImpl
implements MqttMessageHandler {
    public MqttHandlerImpl(MqttClient mqttClient, MqttMsgLogDao mqttMsgLogDao) {
        super("mqtt", mqttClient, mqttMsgLogDao, true);
    }

    @Override
    public MsgHandleResponse handleUpMessage(ChargeDeviceProps chargeDeviceProps, MqttMessage mqttMessage) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start handleUpMessage >>>>>> ");
        }
        MsgHandleResponse res = new MsgHandleResponse();
        res.setStatus(-1);
        res.setMsg("\u5904\u7406\u4e0a\u884c\uff08\u8bbe\u5907\u5230\u670d\u52a1\u5668\uff09\u6d88\u606f\u5931\u8d25 <<< MQTT\u5730\u5740\u7aef\u53e3\u8bf7\u6c42");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" ChargeDeviceProps : " + JsonConvertUtils.convertToString(chargeDeviceProps));
        }
        if (chargeDeviceProps != null && StringUtils.isNotBlank((CharSequence)chargeDeviceProps.getDeviceId())) {
            res.setStatus(0);
            res.setMsg("\u5904\u7406\u4e0a\u884c\uff08\u8bbe\u5907\u5230\u670d\u52a1\u5668\uff09\u6d88\u606f\u6210\u529f <<< MQTT\u5730\u5740\u7aef\u53e3\u8bf7\u6c42");
            chargeDeviceProps = this.chargeDeviceCache.reload(chargeDeviceProps.getDeviceId());
            if (this.needRespond && res.getStatus() == 0) {
                res = this.handleDownMessage(chargeDeviceProps);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" <<<<<<< end handleUpMessage <<<<<<< ");
        }
        return res;
    }

    @Override
    protected MsgHandleResponse handleDownMessage(ChargeDeviceProps chargeDeviceProps) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start handleDownMessage >>>>>> ");
        }
        MsgHandleResponse res = new MsgHandleResponse();
        res.setStatus(-1);
        res.setMsg("\u5904\u7406\u4e0b\u884c\uff08\u670d\u52a1\u5668\u5230\u8bbe\u5907\uff09\u6d88\u606f\u5931\u8d25 >>> MQTT\u5730\u5740\u7aef\u53e3\u8bf7\u6c42");
        String ip = "116.62.193.121";
        String port = "61613";
        String topic = "001";
        if (ObjectUtils.isNotNull(chargeDeviceProps) && StringUtils.isNotBlank((CharSequence)chargeDeviceProps.getDeviceId())) {
            if (StringUtils.isNotBlank((CharSequence)chargeDeviceProps.getMqttBrokerHostIp())) {
                ip = chargeDeviceProps.getMqttBrokerHostIp().trim();
            }
            if (StringUtils.isNotBlank((CharSequence)chargeDeviceProps.getMqttBrokerHostPort())) {
                port = chargeDeviceProps.getMqttBrokerHostPort().trim();
            }
            if (StringUtils.isNotBlank((CharSequence)chargeDeviceProps.getServerSubTopic())) {
                topic = chargeDeviceProps.getServerSubTopic().trim();
            }
            String msg2Device = this.opType + "#" + ip + "#" + port + "#" + topic;
            boolean bp = this.response2device(chargeDeviceProps.getDeviceId(), msg2Device, this.opType);
            if (bp) {
                res.setStatus(0);
                res.setMsg("\u5904\u7406\u4e0b\u884c\uff08\u670d\u52a1\u5668\u5230\u8bbe\u5907\uff09\u6d88\u606f\u6210\u529f >>> MQTT\u5730\u5740\u7aef\u53e3\u8bf7\u6c42");
            }
        } else {
            String msg2Device = this.opType + "#ERROR";
            boolean bp = this.response2device(chargeDeviceProps.getDeviceId(), msg2Device, this.opType);
            if (bp) {
                res.setStatus(0);
                res.setMsg("\u5904\u7406\u4e0b\u884c\uff08\u670d\u52a1\u5668\u5230\u8bbe\u5907\uff09\u6d88\u606f\u6210\u529f >>> MQTT\u5730\u5740\u7aef\u53e3\u8bf7\u6c42");
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" <<<<<<< end handleDownMessage <<<<<<< ");
        }
        return res;
    }
}

