/*
 * Decompiled with CFR 0.152.
 */
package cn.yunrui.mqttclient.ebikesrv.mqttclient.handler.impl;

import cn.yunrui.mqttclient.ebikesrv.common.utils.DoubleUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.IntegerUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.JsonConvertUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.NumberUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.ObjectUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.cache.ChargeDeviceCache;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.cache.ChargeRecordCache;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.cache.FitconnDebuggingCache;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.cache.OpsWorkOrderCache;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.MqttMsgLogDao;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.BillingInfo;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargeDeviceProps;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargeDeviceProtocolEnum;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.MsgHandleResponse;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.RefreshChargeRecordResult;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.handler.MqttMessageHandler;
import cn.yunrui.mqttclient.ebikesrv.syncevent.publisher.ChargeOrderEventPublisher;
import com.google.common.base.Joiner;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.collections.MapUtils;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttTopic;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MqttMessageHandlerImpl
implements MqttMessageHandler {
    private static final int QOS = 1;
    private static final boolean RETAINED = false;
    private static final long WAITTIMEOUT = 3000L;
    private static final Double MAX_CHARGE_EC = 9000.0;
    private static final Integer MAX_CHARGE_TIME_FOR_FREE = 600;
    private static final Double MAX_CHARGE_TIME = 900.0;
    private static final Double MAX_CHARGE_EC_FOR_FREE = 2000.0;
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    final String opType;
    final boolean needRespond;
    protected final MqttClient mqttClient;
    protected final MqttMsgLogDao mqttMsgLogDao;
    ChargeDeviceCache chargeDeviceCache;
    ChargeRecordCache chargeRecordCache;
    FitconnDebuggingCache fitconnDebuggingCache;
    OpsWorkOrderCache opsWorkOrderCache;
    ChargeOrderEventPublisher chargeOrderEventPublisher;

    MqttMessageHandlerImpl(String opType, MqttClient mqttClient, MqttMsgLogDao mqttMsgLogDao, boolean needRespond) {
        this.opType = opType;
        this.mqttClient = mqttClient;
        this.mqttMsgLogDao = mqttMsgLogDao;
        this.needRespond = needRespond;
    }

    String getNewChargeRecordId(String chargeplugNo, Date chargeTime) {
        return Joiner.on((String)"-").skipNulls().join((Object)("EB" + chargeplugNo), (Object)new DateTime((Object)chargeTime).toString("yyyyMMddHHmmssSSS"), new Object[0]);
    }

    Map<String, Object> getChargeRecordMapByCoinsin(BillingInfo billingInfo, Double coinMoney) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start getChargeRecordMapByCoinsin >>>>>>> ");
            this.logger.debug(" billingInfo  : " + (billingInfo != null ? billingInfo.toString() : null));
            this.logger.debug(" coinMoney    : " + coinMoney);
        }
        Double chargeMoney = 0.0;
        coinMoney = coinMoney != null ? coinMoney : 0.0;
        HashMap<String, Object> chargeRecordMap = new HashMap<String, Object>();
        chargeRecordMap.put("chargeMoney", chargeMoney);
        chargeRecordMap.put("coinMoney", coinMoney);
        if (billingInfo != null) {
            chargeRecordMap.put("schemeId", billingInfo.getSchemeId());
            chargeRecordMap.put("schemeType", billingInfo.getSchemeType());
            chargeRecordMap.put("unitPrice1", billingInfo.getUnitPrice1());
            chargeRecordMap.put("unitPrice2", billingInfo.getUnitPrice2());
            chargeRecordMap.put("unitPrice3", billingInfo.getUnitPrice3());
            chargeRecordMap.put("unitPrice4", billingInfo.getUnitPrice4());
            chargeRecordMap.put("unitPrice5", billingInfo.getUnitPrice5());
            chargeRecordMap.put("stepCount", billingInfo.getStepCount());
            chargeRecordMap.put("stepPower1", billingInfo.getStepPower1());
            chargeRecordMap.put("stepPower2", billingInfo.getStepPower2());
            chargeRecordMap.put("stepPower3", billingInfo.getStepPower3());
            chargeRecordMap.put("stepPower4", billingInfo.getStepPower4());
            chargeRecordMap.put("minCharge", billingInfo.getMinCharge());
            chargeRecordMap.put("isReturn", billingInfo.getIsReturn());
            chargeRecordMap.put("closingPeriod", billingInfo.getClosingPeriod());
        }
        chargeRecordMap.put("chargeOpenFlag", 1);
        Integer firstUnitPriceFlag = 1;
        Double firstChargeAmount = 0.0;
        Double usageAmount = 0.0;
        Double surplusAmount = 0.0;
        Double usageElecCons = 0.0;
        if (billingInfo != null && StringUtils.equals((CharSequence)"01", (CharSequence)billingInfo.getSchemeType())) {
            firstUnitPriceFlag = 1;
            if (billingInfo.getUnitPrice1() != null && billingInfo.getUnitPrice1().compareTo(0.0) > 0) {
                firstChargeAmount = coinMoney * billingInfo.getUnitPrice1() * 60.0;
                BigDecimal bd = new BigDecimal(firstChargeAmount);
                bd = bd.setScale(4, 4);
                firstChargeAmount = bd.doubleValue();
            } else if (billingInfo.getUnitPrice1() != null && billingInfo.getUnitPrice1().compareTo(0.0) == 0) {
                firstChargeAmount = (double)(billingInfo.getMaxChargeTime() != null ? billingInfo.getMaxChargeTime() : MAX_CHARGE_TIME_FOR_FREE).intValue() * 1.0;
            }
            surplusAmount = firstChargeAmount - usageAmount;
        } else {
            firstUnitPriceFlag = 1;
            firstChargeAmount = (double)MAX_CHARGE_TIME_FOR_FREE.intValue() * 1.0;
            surplusAmount = firstChargeAmount - usageAmount;
        }
        chargeRecordMap.put("firstUnitPriceFlag", firstUnitPriceFlag);
        chargeRecordMap.put("firstChargeAmount", firstChargeAmount);
        chargeRecordMap.put("currUnitPriceFlag", firstUnitPriceFlag);
        chargeRecordMap.put("chargeAmount", firstChargeAmount);
        chargeRecordMap.put("usageAmount", usageAmount);
        chargeRecordMap.put("surplusAmount", surplusAmount);
        chargeRecordMap.put("usageElecCons", usageElecCons);
        chargeRecordMap.put("remainElecCons", MAX_CHARGE_EC / 1000.0);
        chargeRecordMap.put("remainTime", firstChargeAmount);
        return chargeRecordMap;
    }

    Map<String, Object> getChargeRecordMapByCard(BillingInfo billingInfo, Double chargeMoney) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start getChargeRecordMapByCard >>>>>>> ");
            this.logger.debug(" billingInfo  : " + (billingInfo != null ? billingInfo.toString() : null));
            this.logger.debug(" chargeMoney  : " + chargeMoney);
        }
        if (billingInfo == null) {
            return null;
        }
        chargeMoney = chargeMoney != null ? chargeMoney : 0.0;
        Double coinMoney = 0.0;
        HashMap<String, Object> chargeRecordMap = new HashMap<String, Object>();
        chargeRecordMap.put("chargeMoney", chargeMoney);
        chargeRecordMap.put("coinMoney", coinMoney);
        if (billingInfo != null) {
            chargeRecordMap.put("schemeId", billingInfo.getSchemeId());
            chargeRecordMap.put("schemeType", billingInfo.getSchemeType());
            chargeRecordMap.put("unitPrice1", billingInfo.getUnitPrice1());
            chargeRecordMap.put("unitPrice2", billingInfo.getUnitPrice2());
            chargeRecordMap.put("unitPrice3", billingInfo.getUnitPrice3());
            chargeRecordMap.put("unitPrice4", billingInfo.getUnitPrice4());
            chargeRecordMap.put("unitPrice5", billingInfo.getUnitPrice5());
            chargeRecordMap.put("stepCount", billingInfo.getStepCount());
            chargeRecordMap.put("stepPower1", billingInfo.getStepPower1());
            chargeRecordMap.put("stepPower2", billingInfo.getStepPower2());
            chargeRecordMap.put("stepPower3", billingInfo.getStepPower3());
            chargeRecordMap.put("stepPower4", billingInfo.getStepPower4());
            chargeRecordMap.put("minCharge", billingInfo.getMinCharge());
            chargeRecordMap.put("isReturn", billingInfo.getIsReturn());
            chargeRecordMap.put("closingPeriod", billingInfo.getClosingPeriod());
        }
        chargeRecordMap.put("chargeOpenFlag", 1);
        Integer firstUnitPriceFlag = 1;
        Double firstChargeAmount = 0.0;
        Double usageAmount = 0.0;
        Double surplusAmount = 0.0;
        Double usageElecCons = 0.0;
        if (StringUtils.equals((CharSequence)"01", (CharSequence)billingInfo.getSchemeType())) {
            firstUnitPriceFlag = 1;
            if (billingInfo.getUnitPrice1() != null && billingInfo.getUnitPrice1().compareTo(0.0) > 0) {
                firstChargeAmount = chargeMoney * billingInfo.getUnitPrice1() * 60.0;
                BigDecimal bd = new BigDecimal(firstChargeAmount);
                bd = bd.setScale(4, 4);
                firstChargeAmount = bd.doubleValue();
            } else if (billingInfo.getUnitPrice1() != null && billingInfo.getUnitPrice1().compareTo(0.0) == 0) {
                firstChargeAmount = (double)(billingInfo.getMaxChargeTime() != null ? billingInfo.getMaxChargeTime() : MAX_CHARGE_TIME_FOR_FREE).intValue() * 1.0;
            }
            surplusAmount = firstChargeAmount - usageAmount;
        } else if (StringUtils.equals((CharSequence)"02", (CharSequence)billingInfo.getSchemeType())) {
            firstUnitPriceFlag = 1;
            if (billingInfo.getUnitPrice1() != null && billingInfo.getUnitPrice1().compareTo(0.0) > 0) {
                firstChargeAmount = chargeMoney * billingInfo.getUnitPrice1();
                BigDecimal bd = new BigDecimal(firstChargeAmount);
                bd = bd.setScale(4, 4);
                firstChargeAmount = bd.doubleValue();
            } else if (billingInfo.getUnitPrice1() != null && billingInfo.getUnitPrice1().compareTo(0.0) == 0) {
                firstChargeAmount = MAX_CHARGE_EC_FOR_FREE / 1000.0;
            }
            surplusAmount = firstChargeAmount - usageAmount;
        } else {
            firstUnitPriceFlag = 1;
            firstChargeAmount = (double)MAX_CHARGE_TIME_FOR_FREE.intValue() * 1.0;
            surplusAmount = firstChargeAmount - usageAmount;
        }
        chargeRecordMap.put("firstUnitPriceFlag", firstUnitPriceFlag);
        chargeRecordMap.put("firstChargeAmount", firstChargeAmount);
        chargeRecordMap.put("currUnitPriceFlag", firstUnitPriceFlag);
        chargeRecordMap.put("chargeAmount", firstChargeAmount);
        chargeRecordMap.put("usageAmount", usageAmount);
        chargeRecordMap.put("surplusAmount", surplusAmount);
        chargeRecordMap.put("usageElecCons", usageElecCons);
        if (StringUtils.equals((CharSequence)"02", (CharSequence)billingInfo.getSchemeType())) {
            chargeRecordMap.put("remainElecCons", firstChargeAmount);
            chargeRecordMap.put("remainTime", MAX_CHARGE_TIME);
        } else {
            chargeRecordMap.put("remainElecCons", MAX_CHARGE_EC / 1000.0);
            chargeRecordMap.put("remainTime", firstChargeAmount);
        }
        return chargeRecordMap;
    }

    boolean response2device(String deviceId, String message, String type) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start response2device >>>>>> ");
            this.logger.debug(" [ deviceId : " + deviceId + ", message : " + message + ", type : " + type + " ] ");
        }
        if (this.chargeDeviceCache.get(deviceId) != null && StringUtils.equals((CharSequence)"hzchaoxiang", (CharSequence)this.chargeDeviceCache.get(deviceId).getFactory())) {
            message = message + "#";
        } else if (this.chargeDeviceCache.get(deviceId) != null && StringUtils.equals((CharSequence)"silan", (CharSequence)this.chargeDeviceCache.get(deviceId).getFactory())) {
            message = message + "#" + String.format("%010d", new DateTime(DateTimeZone.forID((String)"Etc/GMT-8")).getMillis() / 1000L);
        }
        MqttTopic mqttTopicDevice = this.mqttClient.getTopic(this.chargeDeviceCache.get(deviceId) != null && StringUtils.equals((CharSequence)"hzchaoxiang", (CharSequence)this.chargeDeviceCache.get(deviceId).getFactory()) ? "$client/" + deviceId : deviceId);
        boolean result = false;
        try {
            MqttMessage mm = new MqttMessage(message.getBytes());
            mm.setQos(1);
            mm.setRetained(false);
            MqttDeliveryToken token = mqttTopicDevice.publish(mm);
            token.waitForCompletion(3000L);
            if (token.isComplete()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(" [ response2device MqttMessage ] : " + JsonConvertUtils.convertToString(mm));
                    this.logger.debug(" >>>>>> completion : " + token.isComplete() + " >>>>>> ");
                }
                this.mqttMsgLogDao.insertMqttMsgLog(mqttTopicDevice.getName(), mm, deviceId, type, "down", "response");
                if (StringUtils.equalsAny((CharSequence)type, (CharSequence[])new CharSequence[]{"start", "cardCharge", "cardCharge2", "coinCharge"})) {
                    String plugId = null;
                    if (StringUtils.isNotBlank((CharSequence)message)) {
                        String[] msgArray = message.split("#");
                        if (msgArray.length >= 2 && StringUtils.equalsAny((CharSequence)type, (CharSequence[])new CharSequence[]{"start", "coinCharge"})) {
                            plugId = msgArray[1];
                        }
                        if (msgArray.length >= 4 && StringUtils.equalsAny((CharSequence)type, (CharSequence[])new CharSequence[]{"cardCharge", "cardCharge2"})) {
                            plugId = msgArray[3];
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)deviceId) && StringUtils.isNotBlank(plugId)) {
                        this.chargeDeviceCache.updatePlugStatus(deviceId, plugId, "1");
                    }
                    ChargeDeviceProps cdp = this.chargeDeviceCache.reload(deviceId);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(" >>> \u91cd\u65b0\u52a0\u8f7d\u7f13\u5b58 >>> ");
                        this.logger.debug(" ChargeDeviceProps : " + (cdp != null ? cdp.toString() : null));
                    }
                }
            }
            result = token.isComplete();
        }
        catch (MqttException _me) {
            this.logger.error(_me.getMessage(), _me.fillInStackTrace());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" <<<<<<< end response2device <<<<<<< ");
        }
        return result;
    }

    RefreshChargeRecordResult refreshChargeRecord(String deviceId, String plugId, Double remain, Double power, Double remainTime, Date currTime) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start refreshChargeRecord >>>>>> ");
            this.logger.debug(" deviceId     : " + deviceId);
            this.logger.debug(" plugId       : " + plugId);
            this.logger.debug(" remain       : " + remain);
            this.logger.debug(" power        : " + power);
            this.logger.debug(" remainTime   : " + remainTime);
            this.logger.debug(" currTime     : " + currTime);
        }
        if (remain != null) {
            remain = DoubleUtils.defaultIfNegValue(remain, 0.0, 0.0) / 1000.0;
        }
        if (power != null) {
            power = DoubleUtils.defaultIfNegValue(power, 0.0, 0.0) / 1000.0;
        }
        if (remainTime != null) {
            remainTime = DoubleUtils.defaultIfNegValue(remainTime, 0.0, 0.0);
        }
        boolean resendParamFlag = false;
        Map<String, Object> valueMap = this.chargeRecordCache.getChargeRecordMap(deviceId, plugId);
        if (MapUtils.isNotEmpty(valueMap)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(" before handle [ valueMap ] : " + JsonConvertUtils.convertToString(valueMap));
            }
            this.handleWaitingChargeOpenFlag(remain, remainTime, valueMap);
            this.calcPowerChar(power, currTime, valueMap);
            if (this.calcChargeUsage(remain, remainTime, valueMap)) {
                resendParamFlag = true;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(" after handle [ valueMap ]  : " + JsonConvertUtils.convertToString(valueMap));
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" <<<<<<< end refreshChargeRecord <<<<<<< ");
        }
        return new RefreshChargeRecordResult(resendParamFlag, valueMap);
    }

    String makeupParamDownMsg(ChargeDeviceProps chargeDeviceProps) {
        String maxPlugPower = "600";
        String maxDevicePower = "2500";
        String cardPassword = "000000000000";
        String factor = "1000";
        String reporttime = "5";
        String remain = "0";
        String time = "0";
        StringBuilder msg2Device = new StringBuilder();
        if (ObjectUtils.isNotNull(chargeDeviceProps)) {
            if (ObjectUtils.isNotNull(chargeDeviceProps.getParamsMap())) {
                maxPlugPower = (String)StringUtils.defaultIfBlank((CharSequence)chargeDeviceProps.getParamsMap().get("maxPlugPower"), (CharSequence)maxPlugPower);
                maxDevicePower = (String)StringUtils.defaultIfBlank((CharSequence)chargeDeviceProps.getParamsMap().get("maxDevicePower"), (CharSequence)maxDevicePower);
                cardPassword = (String)StringUtils.defaultIfBlank((CharSequence)chargeDeviceProps.getParamsMap().get("cardPassword"), (CharSequence)cardPassword);
                factor = (String)StringUtils.defaultIfBlank((CharSequence)chargeDeviceProps.getParamsMap().get("factor"), (CharSequence)factor);
                reporttime = (String)StringUtils.defaultIfBlank((CharSequence)chargeDeviceProps.getParamsMap().get("reporttime"), (CharSequence)reporttime);
            }
            msg2Device.append("param");
            if (chargeDeviceProps.getChargeDeviceProtocol().equals(ChargeDeviceProtocolEnum.MQTT_YJM2M_201710) || chargeDeviceProps.getChargeDeviceProtocol().equals(ChargeDeviceProtocolEnum.MQTT_YJM2M_201712) || chargeDeviceProps.getChargeDeviceProtocol().equals(ChargeDeviceProtocolEnum.MQTT_YJM2M_201801) || chargeDeviceProps.getChargeDeviceProtocol().equals(ChargeDeviceProtocolEnum.MQTT_YJM2M_201804)) {
                msg2Device.append("#").append(maxPlugPower);
                msg2Device.append("#").append(maxDevicePower);
                msg2Device.append("#").append(cardPassword);
                msg2Device.append("#").append(factor);
            } else if (chargeDeviceProps.getChargeDeviceProtocol().equals(ChargeDeviceProtocolEnum.MQTT_EBIKE_201804)) {
                msg2Device.append("#").append(maxPlugPower);
                msg2Device.append("#").append(maxDevicePower);
                msg2Device.append("#").append(factor);
            } else if (chargeDeviceProps.getChargeDeviceProtocol().equals(ChargeDeviceProtocolEnum.MQTT_EBIKE_201805)) {
                msg2Device.append("#").append(maxPlugPower);
                msg2Device.append("#").append(maxDevicePower);
                msg2Device.append("#").append(factor);
                msg2Device.append("#").append(reporttime);
            } else {
                msg2Device.append("#").append(maxPlugPower);
                msg2Device.append("#").append(maxDevicePower);
                msg2Device.append("#").append(cardPassword);
                msg2Device.append("#").append(factor);
            }
            String deviceId = chargeDeviceProps.getDeviceId();
            Integer plugCount = IntegerUtils.defaultIfNull(chargeDeviceProps.getPlugCount(), 0);
            if (StringUtils.isNotBlank((CharSequence)deviceId)) {
                block8: for (int i = 1; i <= plugCount; ++i) {
                    String plugId = String.valueOf(i);
                    String r = remain;
                    String t = time;
                    Map<String, Object> chargeRecordMap = this.chargeRecordCache.getChargeRecordMap(deviceId, plugId);
                    if (cn.yunrui.mqttclient.ebikesrv.common.utils.MapUtils.isNotEmpty(chargeRecordMap)) {
                        r = String.valueOf(Math.round((Double)ObjectUtils.defaultIfNull((Object)chargeRecordMap.get("remainElecCons"), (Object)0.0) * 1000.0));
                        t = String.valueOf(Math.round((Double)ObjectUtils.defaultIfNull((Object)chargeRecordMap.get("remainTime"), (Object)0.0)));
                    }
                    switch (chargeDeviceProps.getChargeDeviceProtocol()) {
                        case MQTT_YJM2M_201710: {
                            msg2Device.append("#").append(r);
                            continue block8;
                        }
                        case MQTT_YJM2M_201712: {
                            msg2Device.append("#").append(r).append(",").append(t);
                            continue block8;
                        }
                        case MQTT_YJM2M_201801: {
                            msg2Device.append("#").append(r).append(",").append(t);
                            continue block8;
                        }
                        case MQTT_YJM2M_201804: {
                            msg2Device.append("#").append(r).append(",").append(t);
                            continue block8;
                        }
                        case MQTT_EBIKE_201804: {
                            msg2Device.append("#").append(r).append(",").append(t);
                            continue block8;
                        }
                        case MQTT_EBIKE_201805: {
                            msg2Device.append("#").append(r).append(",").append(t);
                            continue block8;
                        }
                        default: {
                            msg2Device.append("#").append(r).append(",").append(t);
                        }
                    }
                }
            }
        }
        return msg2Device.toString();
    }

    String makeupAttachParamDownMsg(ChargeDeviceProps chargeDeviceProps) {
        String floatChargeTime = "120";
        String noloadTime = "180";
        String unitLimit = "1000";
        String unitLimitTime = "180";
        StringBuilder msg2Device = new StringBuilder();
        if (ObjectUtils.isNotNull(chargeDeviceProps)) {
            BillingInfo bi = this.chargeDeviceCache.getDefaultBillingInfoByDeviceId(chargeDeviceProps.getDeviceId());
            if (bi != null && StringUtils.equals((CharSequence)"01", (CharSequence)bi.getSchemeType()) && bi.getUnitPrice1() != null) {
                unitLimitTime = bi.getUnitPrice1() > 0.0 ? "" + Math.round(bi.getUnitPrice1() * 60.0) : "" + IntegerUtils.defaultIfNull(bi.getMaxChargeTime(), MAX_CHARGE_TIME_FOR_FREE);
            }
            if (ObjectUtils.isNotNull(chargeDeviceProps.getAttachParamsMap()) && StringUtils.isNotBlank((CharSequence)chargeDeviceProps.getAttachParamsMap().get("floatChargeTime"))) {
                floatChargeTime = chargeDeviceProps.getAttachParamsMap().get("floatChargeTime");
            }
            if (ObjectUtils.isNotNull(chargeDeviceProps.getAttachParamsMap())) {
                noloadTime = (String)StringUtils.defaultIfBlank((CharSequence)chargeDeviceProps.getAttachParamsMap().get("noloadTime"), (CharSequence)noloadTime);
            }
            msg2Device.append("attachParam");
            if (chargeDeviceProps.getChargeDeviceProtocol().equals(ChargeDeviceProtocolEnum.MQTT_YJM2M_201710) || chargeDeviceProps.getChargeDeviceProtocol().equals(ChargeDeviceProtocolEnum.MQTT_YJM2M_201712) || chargeDeviceProps.getChargeDeviceProtocol().equals(ChargeDeviceProtocolEnum.MQTT_YJM2M_201801) || chargeDeviceProps.getChargeDeviceProtocol().equals(ChargeDeviceProtocolEnum.MQTT_YJM2M_201804)) {
                msg2Device.append("#").append(floatChargeTime);
            } else if (chargeDeviceProps.getChargeDeviceProtocol().equals(ChargeDeviceProtocolEnum.MQTT_EBIKE_201804)) {
                if (StringUtils.equals((CharSequence)"hzchaoxiang", (CharSequence)chargeDeviceProps.getFactory())) {
                    try {
                        msg2Device.append("#").append(String.valueOf(Integer.parseInt(floatChargeTime) * 60));
                    }
                    catch (NumberFormatException nfe) {
                        msg2Device.append("#").append(String.valueOf(7200));
                    }
                } else {
                    msg2Device.append("#").append(floatChargeTime);
                }
                if (StringUtils.equals((CharSequence)"hzchaoxiang", (CharSequence)chargeDeviceProps.getFactory())) {
                    msg2Device.append("#").append(Math.round(NumberUtils.toDouble((String)noloadTime) / 2.0));
                } else {
                    msg2Device.append("#").append(noloadTime);
                }
                msg2Device.append("#").append(unitLimit);
                msg2Device.append("#").append(unitLimitTime);
            } else if (chargeDeviceProps.getChargeDeviceProtocol().equals(ChargeDeviceProtocolEnum.MQTT_EBIKE_201805)) {
                msg2Device.append("#").append(floatChargeTime);
                msg2Device.append("#").append(noloadTime);
                if (StringUtils.equals((CharSequence)"gaea", (CharSequence)chargeDeviceProps.getFactory())) {
                    msg2Device.append("#").append(unitLimit);
                    msg2Device.append("#").append(unitLimitTime);
                }
            } else {
                msg2Device.append("#").append(floatChargeTime);
            }
        }
        return msg2Device.toString();
    }

    String makeupSynctimeDownMsg(ChargeDeviceProps chargeDeviceProps) {
        StringBuilder msg2Device = new StringBuilder();
        if (ObjectUtils.isNotNull(chargeDeviceProps)) {
            msg2Device.append("synctime");
            msg2Device.append("#").append(String.format("%010d", new DateTime(DateTimeZone.forID((String)"Etc/GMT-8")).getMillis() / 1000L));
        }
        return msg2Device.toString();
    }

    private void handleWaitingChargeOpenFlag(Double remain, Double remainTime, Map<String, Object> valueMap) {
        Integer chargeOpenFlag = (Integer)ObjectUtils.defaultIfNull((Object)valueMap.get("chargeOpenFlag"), (Object)0);
        if (chargeOpenFlag == 1) {
            if (remain != null && remainTime != null && remain.compareTo(0.0) > 0 && remainTime.compareTo(0.0) > 0 || remain != null && remainTime == null && remain.compareTo(0.0) > 0 || remain == null && remainTime != null && remainTime.compareTo(0.0) > 0) {
                valueMap.put("chargeOpenFlag", 0);
                valueMap.put("chargeOpenTime", new Date());
            } else {
                valueMap.put("chargeOpenFlag", -99);
                valueMap.put("chargeOpenTime", new Date());
            }
        }
    }

    private void calcPowerChar(Double power, Date currTime, Map<String, Object> valueMap) {
        Double maxPower = (Double)ObjectUtils.defaultIfNull((Object)valueMap.get("maxPower"), (Object)-1.0);
        Double minPower = (Double)ObjectUtils.defaultIfNull((Object)valueMap.get("minPower"), (Object)-1.0);
        Double avgPower = (Double)ObjectUtils.defaultIfNull((Object)valueMap.get("avgPower"), (Object)0.0);
        Integer statPowerCount = (Integer)ObjectUtils.defaultIfNull((Object)valueMap.get("statPowerCount"), (Object)0);
        if (power != null) {
            valueMap.put("curPower", power);
            if (power.compareTo(maxPower) > 0 || maxPower.compareTo(0.0) < 0) {
                valueMap.put("maxPower", power);
                valueMap.put("maxPowerTime", currTime != null ? currTime : new Date());
            }
            if (power.compareTo(minPower) < 0 || minPower.compareTo(0.0) < 0) {
                valueMap.put("minPower", power);
                valueMap.put("minPowerTime", currTime != null ? currTime : new Date());
            }
            avgPower = (power + avgPower * (double)statPowerCount.intValue()) / (double)(statPowerCount + 1);
            statPowerCount = statPowerCount + 1;
            valueMap.put("avgPower", avgPower);
            valueMap.put("statPowerCount", statPowerCount);
        }
    }

    private boolean calcChargeUsage(Double remain, Double remainTime, Map<String, Object> valueMap) {
        boolean changeChargeAmount = false;
        String schemeType = (String)ObjectUtils.defaultIfNull((Object)valueMap.get("schemeType"), (Object)"");
        Double chargeAmount = (Double)ObjectUtils.defaultIfNull((Object)valueMap.get("chargeAmount"), (Object)0.0);
        Double usageAmount = (Double)ObjectUtils.defaultIfNull((Object)valueMap.get("usageAmount"), (Object)0.0);
        Double surplusAmount = (Double)ObjectUtils.defaultIfNull((Object)valueMap.get("surplusAmount"), (Object)0.0);
        Double usageElecCons = (Double)ObjectUtils.defaultIfNull((Object)valueMap.get("usageElecCons"), (Object)0.0);
        Double lastRemainElecCons = (Double)ObjectUtils.defaultIfNull((Object)valueMap.get("remainElecCons"), (Object)0.0);
        Double lastRemainTime = (Double)ObjectUtils.defaultIfNull((Object)valueMap.get("remainTime"), (Object)0.0);
        Double ttUsageElecCons = 0.0;
        Double ttUsageTime = 0.0;
        ttUsageElecCons = remain != null && remain.compareTo(0.0) > 0 && lastRemainElecCons - remain > 0.0 ? lastRemainElecCons - remain : 0.0;
        ttUsageTime = remainTime != null && remainTime.compareTo(0.0) > 0 && lastRemainTime - remainTime > 0.0 ? lastRemainTime - remainTime : 0.0;
        if (StringUtils.equals((CharSequence)"02", (CharSequence)schemeType)) {
            Double d = surplusAmount = remain != null ? remain : surplusAmount;
            if (chargeAmount.compareTo(0.0) >= 0 && surplusAmount.compareTo(0.0) >= 0 && chargeAmount.compareTo(surplusAmount) >= 0) {
                usageElecCons = usageAmount = Double.valueOf(chargeAmount - surplusAmount);
            }
        } else if (StringUtils.equals((CharSequence)"05", (CharSequence)schemeType)) {
            Integer currUnitPriceFlag;
            Double d = surplusAmount = remain != null ? remain : surplusAmount;
            if (chargeAmount.compareTo(0.0) >= 0 && surplusAmount.compareTo(0.0) >= 0 && chargeAmount.compareTo(surplusAmount) >= 0) {
                usageElecCons = usageAmount = Double.valueOf(chargeAmount - surplusAmount);
            }
            Double chargeMoney = (Double)valueMap.get("chargeMoney");
            Double maxPower = (Double)valueMap.get("maxPower");
            Integer stepCount = (Integer)valueMap.get("stepCount");
            Integer stepPower1 = (Integer)valueMap.get("stepPower1");
            Integer stepPower2 = (Integer)valueMap.get("stepPower2");
            Integer stepPower3 = (Integer)valueMap.get("stepPower3");
            Integer stepPower4 = (Integer)valueMap.get("stepPower4");
            Double unitPrice1 = (Double)valueMap.get("unitPrice1");
            Double unitPrice2 = (Double)valueMap.get("unitPrice2");
            Double unitPrice3 = (Double)valueMap.get("unitPrice3");
            Double unitPrice4 = (Double)valueMap.get("unitPrice4");
            Double unitPrice5 = (Double)valueMap.get("unitPrice5");
            LinkedList<Integer> validSteps = new LinkedList<Integer>();
            if (stepCount >= 1 && stepPower1 != null) {
                validSteps.add(stepPower1);
            }
            if (stepCount >= 2 && stepPower2 != null && stepPower2 != 0) {
                validSteps.add(stepPower2);
            }
            if (stepCount >= 3 && stepPower3 != null && stepPower3 != 0) {
                validSteps.add(stepPower3);
            }
            if (stepCount >= 4 && stepPower4 != null && stepPower4 != 0) {
                validSteps.add(stepPower4);
            }
            LinkedList<Double> unitPriceList = new LinkedList<Double>();
            if (stepCount >= 1 && stepPower1 != null) {
                unitPriceList.add(unitPrice2);
            }
            if (stepCount >= 2 && stepPower2 != null && unitPrice3 != 0.0) {
                unitPriceList.add(unitPrice3);
            }
            if (stepCount >= 3 && stepPower3 != null && unitPrice4 != 0.0) {
                unitPriceList.add(unitPrice4);
            }
            if (stepCount >= 4 && stepPower4 != null && unitPrice5 != 0.0) {
                unitPriceList.add(unitPrice5);
            }
            int targetInterval = 0;
            for (int i = 0; i < validSteps.size(); ++i) {
                if (!(maxPower * 1000.0 <= ((Integer)validSteps.get(i)).doubleValue())) continue;
                targetInterval = i + 1;
                break;
            }
            if (targetInterval == 0) {
                targetInterval = validSteps.size() + 1;
            }
            if ((currUnitPriceFlag = (Integer)valueMap.get("currUnitPriceFlag")) != targetInterval) {
                Integer powerResult = targetInterval > validSteps.size() ? Integer.valueOf((Integer)validSteps.get(targetInterval - 2) + 200) : (Integer)validSteps.get(targetInterval - 1);
                Double addPrice = (Double)unitPriceList.get(targetInterval - 1) / (Double.valueOf(powerResult.intValue()) * 0.001);
                Double resultPrice = unitPrice1 + addPrice;
                changeChargeAmount = true;
                Double resultAmount = chargeMoney / resultPrice;
                surplusAmount = resultAmount.compareTo(usageAmount) > 0 ? resultAmount - usageAmount : resultAmount;
                valueMap.put("currUnitPriceFlag", targetInterval);
                valueMap.put("chargeAmount", resultAmount);
                if (valueMap.get("schemeDetails") != null) {
                    JSONObject schemeDetails = JSONObject.fromObject((Object)valueMap.get("schemeDetails").toString());
                    schemeDetails.put((Object)"charge_service_fee", (Object)addPrice);
                    valueMap.put("schemeDetails", schemeDetails.toString());
                }
            }
        } else {
            Double d = surplusAmount = remainTime != null ? remainTime : surplusAmount;
            if (chargeAmount > 999.0) {
                chargeAmount = 999.0;
            }
            if (chargeAmount.compareTo(0.0) >= 0 && surplusAmount.compareTo(0.0) >= 0 && chargeAmount.compareTo(surplusAmount) >= 0) {
                usageAmount = chargeAmount - surplusAmount;
                usageElecCons = usageElecCons + ttUsageElecCons;
            }
            Double chargeMoney = (Double)valueMap.get("chargeMoney");
            Double maxPower = (Double)valueMap.get("maxPower");
            Double avgPower = (Double)valueMap.get("avgPower");
            Integer stepCount = (Integer)valueMap.get("stepCount");
            Integer stepPower1 = (Integer)valueMap.get("stepPower1");
            Integer stepPower2 = (Integer)valueMap.get("stepPower2");
            Integer stepPower3 = (Integer)valueMap.get("stepPower3");
            Integer stepPower4 = (Integer)valueMap.get("stepPower4");
            Double unitPrice1 = (Double)valueMap.get("unitPrice1");
            Double unitPrice2 = (Double)valueMap.get("unitPrice2");
            Double unitPrice3 = (Double)valueMap.get("unitPrice3");
            Double unitPrice4 = (Double)valueMap.get("unitPrice4");
            Double unitPrice5 = (Double)valueMap.get("unitPrice5");
            Integer currUnitPriceFlag = (Integer)valueMap.get("currUnitPriceFlag");
            Integer unitPriceFlag = 0;
            Double unitPrice = 0.0;
            if (stepCount < 1) {
                stepCount = 1;
            } else if (stepCount > 5) {
                stepCount = 5;
            }
            if (stepCount == 1) {
                unitPriceFlag = 1;
                unitPrice = unitPrice1;
            } else if (stepCount == 2) {
                if (Double.compare(NumberUtils.min((double[])new double[]{maxPower, avgPower}), (double)stepPower1.intValue() / 1000.0) <= 0) {
                    unitPriceFlag = 1;
                    unitPrice = unitPrice1;
                } else {
                    unitPriceFlag = 2;
                    unitPrice = unitPrice2;
                }
            } else if (stepCount == 3) {
                if (Double.compare(NumberUtils.min((double[])new double[]{maxPower, avgPower}), (double)stepPower1.intValue() / 1000.0) <= 0) {
                    unitPriceFlag = 1;
                    unitPrice = unitPrice1;
                } else if (Double.compare(NumberUtils.min((double[])new double[]{maxPower, avgPower}), (double)stepPower1.intValue() / 1000.0) > 0 && Double.compare(NumberUtils.min((double[])new double[]{maxPower, avgPower}), (double)stepPower2.intValue() / 1000.0) <= 0) {
                    unitPriceFlag = 2;
                    unitPrice = unitPrice2;
                } else {
                    unitPriceFlag = 3;
                    unitPrice = unitPrice3;
                }
            } else if (stepCount == 4) {
                if (Double.compare(NumberUtils.min((double[])new double[]{maxPower, avgPower}), (double)stepPower1.intValue() / 1000.0) <= 0) {
                    unitPriceFlag = 1;
                    unitPrice = unitPrice1;
                } else if (Double.compare(NumberUtils.min((double[])new double[]{maxPower, avgPower}), (double)stepPower1.intValue() / 1000.0) > 0 && Double.compare(NumberUtils.min((double[])new double[]{maxPower, avgPower}), (double)stepPower2.intValue() / 1000.0) <= 0) {
                    unitPriceFlag = 2;
                    unitPrice = unitPrice2;
                } else if (Double.compare(NumberUtils.min((double[])new double[]{maxPower, avgPower}), (double)stepPower2.intValue() / 1000.0) > 0 && Double.compare(NumberUtils.min((double[])new double[]{maxPower, avgPower}), (double)stepPower3.intValue() / 1000.0) <= 0) {
                    unitPriceFlag = 3;
                    unitPrice = unitPrice3;
                } else {
                    unitPriceFlag = 4;
                    unitPrice = unitPrice4;
                }
            } else if (Double.compare(NumberUtils.min((double[])new double[]{maxPower, avgPower}), (double)stepPower1.intValue() / 1000.0) <= 0) {
                unitPriceFlag = 1;
                unitPrice = unitPrice1;
            } else if (Double.compare(NumberUtils.min((double[])new double[]{maxPower, avgPower}), (double)stepPower1.intValue() / 1000.0) > 0 && Double.compare(NumberUtils.min((double[])new double[]{maxPower, avgPower}), (double)stepPower2.intValue() / 1000.0) <= 0) {
                unitPriceFlag = 2;
                unitPrice = unitPrice2;
            } else if (Double.compare(NumberUtils.min((double[])new double[]{maxPower, avgPower}), (double)stepPower2.intValue() / 1000.0) > 0 && Double.compare(NumberUtils.min((double[])new double[]{maxPower, avgPower}), (double)stepPower3.intValue() / 1000.0) <= 0) {
                unitPriceFlag = 3;
                unitPrice = unitPrice3;
            } else if (Double.compare(NumberUtils.min((double[])new double[]{maxPower, avgPower}), (double)stepPower3.intValue() / 1000.0) > 0 && Double.compare(NumberUtils.min((double[])new double[]{maxPower, avgPower}), (double)stepPower4.intValue() / 1000.0) <= 0) {
                unitPriceFlag = 4;
                unitPrice = unitPrice4;
            } else {
                unitPriceFlag = 5;
                unitPrice = unitPrice5;
            }
            if (unitPriceFlag.compareTo(currUnitPriceFlag) > 0 && unitPrice.compareTo(0.0) > 0) {
                Double currChargeAmount = chargeMoney * unitPrice * 60.0;
                BigDecimal bd = new BigDecimal(currChargeAmount);
                currChargeAmount = (bd = bd.setScale(4, 4)).doubleValue();
                if (currChargeAmount.compareTo(chargeAmount) < 0) {
                    changeChargeAmount = true;
                    chargeAmount = currChargeAmount;
                    remainTime = surplusAmount = Double.valueOf(chargeAmount.compareTo(usageAmount) > 0 ? chargeAmount - usageAmount : 0.0);
                    valueMap.put("currUnitPriceFlag", unitPriceFlag);
                    valueMap.put("chargeAmount", chargeAmount);
                }
            }
        }
        valueMap.put("usageAmount", usageAmount);
        valueMap.put("surplusAmount", surplusAmount);
        valueMap.put("usageElecCons", usageElecCons);
        if (remain != null) {
            valueMap.put("remainElecCons", remain);
        }
        if (remainTime != null) {
            valueMap.put("remainTime", remainTime);
        }
        return changeChargeAmount;
    }

    @Override
    public void setChargeDeviceCache(ChargeDeviceCache chargeDeviceCache) {
        this.chargeDeviceCache = chargeDeviceCache;
    }

    @Override
    public void setChargeRecordCache(ChargeRecordCache chargeRecordCache) {
        this.chargeRecordCache = chargeRecordCache;
    }

    @Override
    public void setFitconnDebuggingCache(FitconnDebuggingCache fitconnDebuggingCache) {
        this.fitconnDebuggingCache = fitconnDebuggingCache;
    }

    @Override
    public void setOpsWorkOrderCache(OpsWorkOrderCache opsWorkOrderCache) {
        this.opsWorkOrderCache = opsWorkOrderCache;
    }

    @Override
    public void setChargeOrderEventPublisher(ChargeOrderEventPublisher chargeOrderEventPublisher) {
        this.chargeOrderEventPublisher = chargeOrderEventPublisher;
    }

    @Override
    public MsgHandleResponse handleUpMessage(ChargeDeviceProps chargeDeviceProps, MqttMessage mqttMessage) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start handleUpMessage >>>>>> ");
            this.logger.debug(" chargeDeviceProps : " + JsonConvertUtils.convertToString(chargeDeviceProps));
        }
        MsgHandleResponse res = new MsgHandleResponse();
        res.setStatus(0);
        res.setMsg("\u5904\u7406\u4e0a\u884c\uff08\u8bbe\u5907\u5230\u670d\u52a1\u5668\uff09\u6d88\u606f\u6210\u529f");
        if (this.needRespond && res.getStatus() == 0) {
            res = this.handleDownMessage(chargeDeviceProps);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" <<<<<<< end handleUpMessage <<<<<<< ");
        }
        return res;
    }

    protected MsgHandleResponse handleDownMessage(ChargeDeviceProps chargeDeviceProps) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start handleDownMessage >>>>>> ");
            this.logger.debug(" chargeDeviceProps    : " + JsonConvertUtils.convertToString(chargeDeviceProps));
        }
        MsgHandleResponse res = new MsgHandleResponse();
        res.setStatus(0);
        res.setMsg("\u5904\u7406\u4e0b\u884c\uff08\u670d\u52a1\u5668\u5230\u8bbe\u5907\uff09\u6d88\u606f\u6210\u529f");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" <<<<<<< end handleDownMessage <<<<<<< ");
        }
        return res;
    }

    protected MsgHandleResponse handleDownMessage(ChargeDeviceProps chargeDeviceProps, String plugId) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start handleDownMessage >>>>>> ");
            this.logger.debug(" chargeDeviceProps    : " + JsonConvertUtils.convertToString(chargeDeviceProps));
            this.logger.debug(" plugId               : " + plugId);
        }
        MsgHandleResponse res = new MsgHandleResponse();
        res.setStatus(0);
        res.setMsg("\u5904\u7406\u4e0b\u884c\uff08\u670d\u52a1\u5668\u5230\u8bbe\u5907\uff09\u6d88\u606f\u6210\u529f");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" <<<<<<< end handleDownMessage <<<<<<< ");
        }
        return res;
    }
}

